# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_LSS_METADATA = Metadata(
    id="f59c06c71271844acbd9b7f7f4806ab324672634.boutiques",
    name="3dLSS",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dLssParameters = typing.TypedDict('V3dLssParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dLSS"]],
    "matrix": InputPathType,
    "input": typing.NotRequired[InputPathType | None],
    "nodata": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "automask": bool,
    "prefix": typing.NotRequired[str | None],
    "save1D": typing.NotRequired[str | None],
    "verbose": bool,
})
V3dLssParametersTagged = typing.TypedDict('V3dLssParametersTagged', {
    "@type": typing.Literal["afni/3dLSS"],
    "matrix": InputPathType,
    "input": typing.NotRequired[InputPathType | None],
    "nodata": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "automask": bool,
    "prefix": typing.NotRequired[str | None],
    "save1D": typing.NotRequired[str | None],
    "verbose": bool,
})


class V3dLssOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dLssParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType
    """Output dataset containing the LSS estimates of the beta weights for the
    '-stim_times_IM' stimuli."""
    save1_d_output: OutputPathType | None
    """Estimator vectors saved in a 1D formatted file."""


def v_3d_lss_params(
    matrix: InputPathType,
    input_: InputPathType | None = None,
    nodata: bool = False,
    mask: InputPathType | None = None,
    automask: bool = False,
    prefix: str | None = None,
    save1_d: str | None = None,
    verbose: bool = False,
) -> V3dLssParametersTagged:
    """
    Build parameters.
    
    Args:
        matrix: Read the matrix 'mmm', which should have been output from\
            3dDeconvolve via the '-x1D' option. It should have included exactly one\
            '-stim_times_IM' option.
        input_: Read time series dataset 'ddd'.
        nodata: Just compute the estimator matrix -- to be saved with\
            '-save1D'.
        mask: Dataset 'MMM' will be used as a mask for the input; voxels\
            outside the mask will not be fit by the regression model.
        automask: If you don't know what this does by now, please don't use\
            this program.
        prefix: Prefix name for the output dataset; this dataset will contain\
            ONLY the LSS estimates of the beta weights for the '-stim_times_IM'\
            stimuli.
        save1_d: Save the estimator vectors to a 1D formatted file named 'qqq'.
        verbose: Write out progress reports.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dLSS",
        "matrix": matrix,
        "nodata": nodata,
        "automask": automask,
        "verbose": verbose,
    }
    if input_ is not None:
        params["input"] = input_
    if mask is not None:
        params["mask"] = mask
    if prefix is not None:
        params["prefix"] = prefix
    if save1_d is not None:
        params["save1D"] = save1_d
    return params


def v_3d_lss_cargs(
    params: V3dLssParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dLSS")
    cargs.extend([
        "-matrix",
        execution.input_file(params.get("matrix", None))
    ])
    if params.get("input", None) is not None:
        cargs.extend([
            "-input",
            execution.input_file(params.get("input", None))
        ])
    if params.get("nodata", False):
        cargs.append("-nodata")
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("automask", False):
        cargs.append("-automask")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("save1D", None) is not None:
        cargs.extend([
            "-save1D",
            params.get("save1D", None)
        ])
    if params.get("verbose", False):
        cargs.append("-verb")
    return cargs


def v_3d_lss_outputs(
    params: V3dLssParameters,
    execution: Execution,
) -> V3dLssOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dLssOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file("LSSout+orig.HEAD"),
        save1_d_output=execution.output_file(params.get("save1D", None)) if (params.get("save1D") is not None) else None,
    )
    return ret


def v_3d_lss_execute(
    params: V3dLssParameters,
    runner: Runner | None = None,
) -> V3dLssOutputs:
    """
    3dLSS
    
    Least-Squares-Sum (LSS) estimation tool from a -stim_times_IM matrix for
    multivoxel pattern classification analyses.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dLssOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_LSS_METADATA)
    params = execution.params(params)
    cargs = v_3d_lss_cargs(params, execution)
    ret = v_3d_lss_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_lss(
    matrix: InputPathType,
    input_: InputPathType | None = None,
    nodata: bool = False,
    mask: InputPathType | None = None,
    automask: bool = False,
    prefix: str | None = None,
    save1_d: str | None = None,
    verbose: bool = False,
    runner: Runner | None = None,
) -> V3dLssOutputs:
    """
    3dLSS
    
    Least-Squares-Sum (LSS) estimation tool from a -stim_times_IM matrix for
    multivoxel pattern classification analyses.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        matrix: Read the matrix 'mmm', which should have been output from\
            3dDeconvolve via the '-x1D' option. It should have included exactly one\
            '-stim_times_IM' option.
        input_: Read time series dataset 'ddd'.
        nodata: Just compute the estimator matrix -- to be saved with\
            '-save1D'.
        mask: Dataset 'MMM' will be used as a mask for the input; voxels\
            outside the mask will not be fit by the regression model.
        automask: If you don't know what this does by now, please don't use\
            this program.
        prefix: Prefix name for the output dataset; this dataset will contain\
            ONLY the LSS estimates of the beta weights for the '-stim_times_IM'\
            stimuli.
        save1_d: Save the estimator vectors to a 1D formatted file named 'qqq'.
        verbose: Write out progress reports.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dLssOutputs`).
    """
    params = v_3d_lss_params(
        matrix=matrix,
        input_=input_,
        nodata=nodata,
        mask=mask,
        automask=automask,
        prefix=prefix,
        save1_d=save1_d,
        verbose=verbose,
    )
    return v_3d_lss_execute(params, runner)


__all__ = [
    "V3dLssOutputs",
    "V_3D_LSS_METADATA",
    "v_3d_lss",
    "v_3d_lss_execute",
    "v_3d_lss_params",
]
