# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_MANN_WHITNEY_METADATA = Metadata(
    id="fb00db9925fb8e8685faf28f5dd4c98d2b2e2420.boutiques",
    name="3dMannWhitney",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dMannWhitneyParameters = typing.TypedDict('V3dMannWhitneyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dMannWhitney"]],
    "dset1_x": list[str],
    "dset2_y": list[str],
    "output_prefix": str,
    "workmem": typing.NotRequired[int | None],
    "voxel_num": typing.NotRequired[int | None],
})
V3dMannWhitneyParametersTagged = typing.TypedDict('V3dMannWhitneyParametersTagged', {
    "@type": typing.Literal["afni/3dMannWhitney"],
    "dset1_x": list[str],
    "dset2_y": list[str],
    "output_prefix": str,
    "workmem": typing.NotRequired[int | None],
    "voxel_num": typing.NotRequired[int | None],
})


class V3dMannWhitneyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dMannWhitneyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_mann_whitney_params(
    dset1_x: list[str],
    dset2_y: list[str],
    output_prefix: str,
    workmem: int | None = None,
    voxel_num: int | None = None,
) -> V3dMannWhitneyParametersTagged:
    """
    Build parameters.
    
    Args:
        dset1_x: Data set for X observations. Must specify 1 and only 1\
            sub-brick.
        dset2_y: Data set for Y observations. Must specify 1 and only 1\
            sub-brick.
        output_prefix: Estimated population delta and Wilcoxon-Mann-Whitney\
            statistics written to file.
        workmem: Number of megabytes of RAM to use for statistical workspace.
        voxel_num: Screen output for voxel # num.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dMannWhitney",
        "dset1_x": dset1_x,
        "dset2_y": dset2_y,
        "output_prefix": output_prefix,
    }
    if workmem is not None:
        params["workmem"] = workmem
    if voxel_num is not None:
        params["voxel_num"] = voxel_num
    return params


def v_3d_mann_whitney_cargs(
    params: V3dMannWhitneyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dMannWhitney")
    cargs.extend([
        "-dset 1",
        *params.get("dset1_x", None)
    ])
    cargs.extend([
        "-dset 2",
        *params.get("dset2_y", None)
    ])
    cargs.extend([
        "-out",
        params.get("output_prefix", None)
    ])
    if params.get("workmem", None) is not None:
        cargs.extend([
            "-workmem",
            str(params.get("workmem", None))
        ])
    if params.get("voxel_num", None) is not None:
        cargs.extend([
            "-voxel",
            str(params.get("voxel_num", None))
        ])
    return cargs


def v_3d_mann_whitney_outputs(
    params: V3dMannWhitneyParameters,
    execution: Execution,
) -> V3dMannWhitneyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dMannWhitneyOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_mann_whitney_execute(
    params: V3dMannWhitneyParameters,
    runner: Runner | None = None,
) -> V3dMannWhitneyOutputs:
    """
    3dMannWhitney
    
    Performs nonparametric Mann-Whitney two-sample test.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMannWhitneyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_MANN_WHITNEY_METADATA)
    params = execution.params(params)
    cargs = v_3d_mann_whitney_cargs(params, execution)
    ret = v_3d_mann_whitney_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_mann_whitney(
    dset1_x: list[str],
    dset2_y: list[str],
    output_prefix: str,
    workmem: int | None = None,
    voxel_num: int | None = None,
    runner: Runner | None = None,
) -> V3dMannWhitneyOutputs:
    """
    3dMannWhitney
    
    Performs nonparametric Mann-Whitney two-sample test.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dset1_x: Data set for X observations. Must specify 1 and only 1\
            sub-brick.
        dset2_y: Data set for Y observations. Must specify 1 and only 1\
            sub-brick.
        output_prefix: Estimated population delta and Wilcoxon-Mann-Whitney\
            statistics written to file.
        workmem: Number of megabytes of RAM to use for statistical workspace.
        voxel_num: Screen output for voxel # num.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMannWhitneyOutputs`).
    """
    params = v_3d_mann_whitney_params(
        dset1_x=dset1_x,
        dset2_y=dset2_y,
        output_prefix=output_prefix,
        workmem=workmem,
        voxel_num=voxel_num,
    )
    return v_3d_mann_whitney_execute(params, runner)


__all__ = [
    "V3dMannWhitneyOutputs",
    "V_3D_MANN_WHITNEY_METADATA",
    "v_3d_mann_whitney",
    "v_3d_mann_whitney_execute",
    "v_3d_mann_whitney_params",
]
