# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_MEAN_METADATA = Metadata(
    id="c3ac13b34415144da277586edf4aa7b38c139609.boutiques",
    name="3dMean",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dMeanParameters = typing.TypedDict('V3dMeanParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dMean"]],
    "input_files": list[InputPathType],
    "verbose": bool,
    "prefix": typing.NotRequired[str | None],
    "datum": typing.NotRequired[str | None],
    "fscale": bool,
    "gscale": bool,
    "nscale": bool,
    "non_zero": bool,
    "stdev": bool,
    "sqr": bool,
    "sum": bool,
    "count": bool,
    "max": bool,
    "min": bool,
    "absmax": bool,
    "signed_absmax": bool,
    "mask_inter": bool,
    "mask_union": bool,
    "weightset": typing.NotRequired[InputPathType | None],
})
V3dMeanParametersTagged = typing.TypedDict('V3dMeanParametersTagged', {
    "@type": typing.Literal["afni/3dMean"],
    "input_files": list[InputPathType],
    "verbose": bool,
    "prefix": typing.NotRequired[str | None],
    "datum": typing.NotRequired[str | None],
    "fscale": bool,
    "gscale": bool,
    "nscale": bool,
    "non_zero": bool,
    "stdev": bool,
    "sqr": bool,
    "sum": bool,
    "count": bool,
    "max": bool,
    "min": bool,
    "absmax": bool,
    "signed_absmax": bool,
    "mask_inter": bool,
    "mask_union": bool,
    "weightset": typing.NotRequired[InputPathType | None],
})


class V3dMeanOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dMeanParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType | None
    """Output dataset"""


def v_3d_mean_params(
    input_files: list[InputPathType],
    verbose: bool = False,
    prefix: str | None = None,
    datum: str | None = None,
    fscale: bool = False,
    gscale: bool = False,
    nscale: bool = False,
    non_zero: bool = False,
    stdev: bool = False,
    sqr: bool = False,
    sum_: bool = False,
    count: bool = False,
    max_: bool = False,
    min_: bool = False,
    absmax: bool = False,
    signed_absmax: bool = False,
    mask_inter: bool = False,
    mask_union: bool = False,
    weightset: InputPathType | None = None,
) -> V3dMeanParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: Input datasets.
        verbose: Print out some information along the way.
        prefix: Sets the prefix of the output dataset.
        datum: Sets the datum of the output dataset.
        fscale: Force scaling of the output to the maximum integer range.
        gscale: Force scaling of the output to the maximum integer range, with\
            uniform scaling factor for each sub-brick.
        nscale: Don't do any scaling on output to byte or short datasets. Only\
            use if you want the output dataset to be integer-valued.
        non_zero: Use only non-zero values for calculation of mean, min, max,\
            sum, squares.
        stdev: Calculate the standard deviation, sqrt(variance), instead of the\
            mean (cannot be used with -sqr, -sum or -non_zero).
        sqr: Average the squares, instead of the values.
        sum_: Just take the sum (don't divide by number of datasets).
        count: Compute only the count of non-zero voxels.
        max_: Find the maximum at each voxel.
        min_: Find the minimum at each voxel.
        absmax: Find maximum absolute value at each voxel.
        signed_absmax: Find extremes with maximum absolute value but preserve\
            sign.
        mask_inter: Create a simple intersection mask.
        mask_union: Create a simple union mask.
        weightset: Sum of N dsets will be weighted by N volume WSET. This\
            weight dataset must be of type float.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dMean",
        "input_files": input_files,
        "verbose": verbose,
        "fscale": fscale,
        "gscale": gscale,
        "nscale": nscale,
        "non_zero": non_zero,
        "stdev": stdev,
        "sqr": sqr,
        "sum": sum_,
        "count": count,
        "max": max_,
        "min": min_,
        "absmax": absmax,
        "signed_absmax": signed_absmax,
        "mask_inter": mask_inter,
        "mask_union": mask_union,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if datum is not None:
        params["datum"] = datum
    if weightset is not None:
        params["weightset"] = weightset
    return params


def v_3d_mean_cargs(
    params: V3dMeanParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dMean")
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    if params.get("verbose", False):
        cargs.append("-verbose")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("datum", None) is not None:
        cargs.extend([
            "-datum",
            params.get("datum", None)
        ])
    if params.get("fscale", False):
        cargs.append("-fscale")
    if params.get("gscale", False):
        cargs.append("-gscale")
    if params.get("nscale", False):
        cargs.append("-nscale")
    if params.get("non_zero", False):
        cargs.append("-non_zero")
    if params.get("stdev", False):
        cargs.append("-sd")
    if params.get("sqr", False):
        cargs.append("-sqr")
    if params.get("sum", False):
        cargs.append("-sum")
    if params.get("count", False):
        cargs.append("-count")
    if params.get("max", False):
        cargs.append("-max")
    if params.get("min", False):
        cargs.append("-min")
    if params.get("absmax", False):
        cargs.append("-absmax")
    if params.get("signed_absmax", False):
        cargs.append("-signed_absmax")
    if params.get("mask_inter", False):
        cargs.append("-mask_inter")
    if params.get("mask_union", False):
        cargs.append("-mask_union")
    if params.get("weightset", None) is not None:
        cargs.extend([
            "-weightset",
            execution.input_file(params.get("weightset", None))
        ])
    return cargs


def v_3d_mean_outputs(
    params: V3dMeanParameters,
    execution: Execution,
) -> V3dMeanOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dMeanOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix", None)) if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_mean_execute(
    params: V3dMeanParameters,
    runner: Runner | None = None,
) -> V3dMeanOutputs:
    """
    3dMean
    
    Takes the voxel-by-voxel mean of all input datasets; designed to be faster
    than 3dcalc.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMeanOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_MEAN_METADATA)
    params = execution.params(params)
    cargs = v_3d_mean_cargs(params, execution)
    ret = v_3d_mean_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_mean(
    input_files: list[InputPathType],
    verbose: bool = False,
    prefix: str | None = None,
    datum: str | None = None,
    fscale: bool = False,
    gscale: bool = False,
    nscale: bool = False,
    non_zero: bool = False,
    stdev: bool = False,
    sqr: bool = False,
    sum_: bool = False,
    count: bool = False,
    max_: bool = False,
    min_: bool = False,
    absmax: bool = False,
    signed_absmax: bool = False,
    mask_inter: bool = False,
    mask_union: bool = False,
    weightset: InputPathType | None = None,
    runner: Runner | None = None,
) -> V3dMeanOutputs:
    """
    3dMean
    
    Takes the voxel-by-voxel mean of all input datasets; designed to be faster
    than 3dcalc.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input datasets.
        verbose: Print out some information along the way.
        prefix: Sets the prefix of the output dataset.
        datum: Sets the datum of the output dataset.
        fscale: Force scaling of the output to the maximum integer range.
        gscale: Force scaling of the output to the maximum integer range, with\
            uniform scaling factor for each sub-brick.
        nscale: Don't do any scaling on output to byte or short datasets. Only\
            use if you want the output dataset to be integer-valued.
        non_zero: Use only non-zero values for calculation of mean, min, max,\
            sum, squares.
        stdev: Calculate the standard deviation, sqrt(variance), instead of the\
            mean (cannot be used with -sqr, -sum or -non_zero).
        sqr: Average the squares, instead of the values.
        sum_: Just take the sum (don't divide by number of datasets).
        count: Compute only the count of non-zero voxels.
        max_: Find the maximum at each voxel.
        min_: Find the minimum at each voxel.
        absmax: Find maximum absolute value at each voxel.
        signed_absmax: Find extremes with maximum absolute value but preserve\
            sign.
        mask_inter: Create a simple intersection mask.
        mask_union: Create a simple union mask.
        weightset: Sum of N dsets will be weighted by N volume WSET. This\
            weight dataset must be of type float.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMeanOutputs`).
    """
    params = v_3d_mean_params(
        input_files=input_files,
        verbose=verbose,
        prefix=prefix,
        datum=datum,
        fscale=fscale,
        gscale=gscale,
        nscale=nscale,
        non_zero=non_zero,
        stdev=stdev,
        sqr=sqr,
        sum_=sum_,
        count=count,
        max_=max_,
        min_=min_,
        absmax=absmax,
        signed_absmax=signed_absmax,
        mask_inter=mask_inter,
        mask_union=mask_union,
        weightset=weightset,
    )
    return v_3d_mean_execute(params, runner)


__all__ = [
    "V3dMeanOutputs",
    "V_3D_MEAN_METADATA",
    "v_3d_mean",
    "v_3d_mean_execute",
    "v_3d_mean_params",
]
