# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_MEDIAN_FILTER_METADATA = Metadata(
    id="617c14931eec5b5191d306af9970a225bbd22fa6.boutiques",
    name="3dMedianFilter",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dMedianFilterParameters = typing.TypedDict('V3dMedianFilterParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dMedianFilter"]],
    "irad": typing.NotRequired[float | None],
    "iter": typing.NotRequired[float | None],
    "verbose": bool,
    "prefix": typing.NotRequired[str | None],
    "automask": bool,
    "dataset": InputPathType,
})
V3dMedianFilterParametersTagged = typing.TypedDict('V3dMedianFilterParametersTagged', {
    "@type": typing.Literal["afni/3dMedianFilter"],
    "irad": typing.NotRequired[float | None],
    "iter": typing.NotRequired[float | None],
    "verbose": bool,
    "prefix": typing.NotRequired[str | None],
    "automask": bool,
    "dataset": InputPathType,
})


class V3dMedianFilterOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dMedianFilterParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_brik: OutputPathType | None
    """Output dataset is stored in float format."""
    output_head: OutputPathType | None
    """Output dataset header file."""


def v_3d_median_filter_params(
    dataset: InputPathType,
    irad: float | None = None,
    iter_: float | None = None,
    verbose: bool = False,
    prefix: str | None = None,
    automask: bool = False,
) -> V3dMedianFilterParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset.
        irad: Radius in voxels of spherical regions.
        iter_: Iterate 'n' times [default=1].
        verbose: Be verbose during run.
        prefix: Use 'pp' for prefix of output dataset.
        automask: Create a mask (a la 3dAutomask).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dMedianFilter",
        "verbose": verbose,
        "automask": automask,
        "dataset": dataset,
    }
    if irad is not None:
        params["irad"] = irad
    if iter_ is not None:
        params["iter"] = iter_
    if prefix is not None:
        params["prefix"] = prefix
    return params


def v_3d_median_filter_cargs(
    params: V3dMedianFilterParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dMedianFilter")
    if params.get("irad", None) is not None:
        cargs.extend([
            "-irad",
            str(params.get("irad", None))
        ])
    if params.get("iter", None) is not None:
        cargs.extend([
            "-iter",
            str(params.get("iter", None))
        ])
    if params.get("verbose", False):
        cargs.append("-verb")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("automask", False):
        cargs.append("-automask")
    cargs.append(execution.input_file(params.get("dataset", None)))
    return cargs


def v_3d_median_filter_outputs(
    params: V3dMedianFilterParameters,
    execution: Execution,
) -> V3dMedianFilterOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dMedianFilterOutputs(
        root=execution.output_file("."),
        output_brik=execution.output_file(params.get("prefix", None) + "+tlrc.BRIK") if (params.get("prefix") is not None) else None,
        output_head=execution.output_file(params.get("prefix", None) + "+tlrc.HEAD") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_median_filter_execute(
    params: V3dMedianFilterParameters,
    runner: Runner | None = None,
) -> V3dMedianFilterOutputs:
    """
    3dMedianFilter
    
    Computes the median in a spherical neighborhood around each point in the
    input to produce the output.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMedianFilterOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_MEDIAN_FILTER_METADATA)
    params = execution.params(params)
    cargs = v_3d_median_filter_cargs(params, execution)
    ret = v_3d_median_filter_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_median_filter(
    dataset: InputPathType,
    irad: float | None = None,
    iter_: float | None = None,
    verbose: bool = False,
    prefix: str | None = None,
    automask: bool = False,
    runner: Runner | None = None,
) -> V3dMedianFilterOutputs:
    """
    3dMedianFilter
    
    Computes the median in a spherical neighborhood around each point in the
    input to produce the output.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset.
        irad: Radius in voxels of spherical regions.
        iter_: Iterate 'n' times [default=1].
        verbose: Be verbose during run.
        prefix: Use 'pp' for prefix of output dataset.
        automask: Create a mask (a la 3dAutomask).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMedianFilterOutputs`).
    """
    params = v_3d_median_filter_params(
        irad=irad,
        iter_=iter_,
        verbose=verbose,
        prefix=prefix,
        automask=automask,
        dataset=dataset,
    )
    return v_3d_median_filter_execute(params, runner)


__all__ = [
    "V3dMedianFilterOutputs",
    "V_3D_MEDIAN_FILTER_METADATA",
    "v_3d_median_filter",
    "v_3d_median_filter_execute",
    "v_3d_median_filter_params",
]
