# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_MEMA_METADATA = Metadata(
    id="f041c65105cb28ba9e2c96580eb2aeada384b9ed.boutiques",
    name="3dMEMA",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dMemaParameters = typing.TypedDict('V3dMemaParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dMEMA"]],
    "prefix": str,
    "jobs": typing.NotRequired[float | None],
    "set": list[str],
    "covariates": typing.NotRequired[InputPathType | None],
    "covariates_center": typing.NotRequired[str | None],
    "covariates_model": typing.NotRequired[str | None],
    "covariates_name": typing.NotRequired[list[str] | None],
    "groups": typing.NotRequired[list[str] | None],
    "cio": bool,
    "HKtest": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "max_zeros": typing.NotRequired[float | None],
    "missing_data": typing.NotRequired[list[str] | None],
    "model_outliers": bool,
    "n_nonzero": typing.NotRequired[float | None],
    "no_HKtest": bool,
    "no_model_outliers": bool,
    "no_residual_Z": bool,
    "residual_Z": bool,
    "Rio": bool,
    "equal_variance": bool,
    "unequal_variance": bool,
    "verb": typing.NotRequired[float | None],
    "dbgArgs": bool,
    "help": bool,
    "conditions": typing.NotRequired[list[str] | None],
    "no_tstat": bool,
})
V3dMemaParametersTagged = typing.TypedDict('V3dMemaParametersTagged', {
    "@type": typing.Literal["afni/3dMEMA"],
    "prefix": str,
    "jobs": typing.NotRequired[float | None],
    "set": list[str],
    "covariates": typing.NotRequired[InputPathType | None],
    "covariates_center": typing.NotRequired[str | None],
    "covariates_model": typing.NotRequired[str | None],
    "covariates_name": typing.NotRequired[list[str] | None],
    "groups": typing.NotRequired[list[str] | None],
    "cio": bool,
    "HKtest": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "max_zeros": typing.NotRequired[float | None],
    "missing_data": typing.NotRequired[list[str] | None],
    "model_outliers": bool,
    "n_nonzero": typing.NotRequired[float | None],
    "no_HKtest": bool,
    "no_model_outliers": bool,
    "no_residual_Z": bool,
    "residual_Z": bool,
    "Rio": bool,
    "equal_variance": bool,
    "unequal_variance": bool,
    "verb": typing.NotRequired[float | None],
    "dbgArgs": bool,
    "help": bool,
    "conditions": typing.NotRequired[list[str] | None],
    "no_tstat": bool,
})


class V3dMemaOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dMemaParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Output file from the analysis"""


def v_3d_mema_params(
    prefix: str,
    set_: list[str],
    jobs: float | None = None,
    covariates: InputPathType | None = None,
    covariates_center: str | None = None,
    covariates_model: str | None = None,
    covariates_name: list[str] | None = None,
    groups: list[str] | None = None,
    cio: bool = False,
    hktest: bool = False,
    mask: InputPathType | None = None,
    max_zeros: float | None = None,
    missing_data: list[str] | None = None,
    model_outliers: bool = False,
    n_nonzero: float | None = None,
    no_hktest: bool = False,
    no_model_outliers: bool = False,
    no_residual_z: bool = False,
    residual_z: bool = False,
    rio: bool = False,
    equal_variance: bool = False,
    unequal_variance: bool = False,
    verb: float | None = None,
    dbg_args: bool = False,
    help_: bool = False,
    conditions: list[str] | None = None,
    no_tstat: bool = False,
) -> V3dMemaParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Output prefix (just prefix, no view+suffix needed).
        set_: Set data for one of the test variables.
        jobs: Number of jobs for parallel computing.
        covariates: Specify the name of a text file containing a table for the\
            covariate(s).
        covariates_center: Specify the center values for covariates.
        covariates_model: Specify how covariates should be modeled.
        covariates_name: Specify the name of each covariate.
        groups: Label of groups, used for output naming.
        cio: Use AFNI's C io functions.
        hktest: Perform Hartung-Knapp adjustment for the output t-statistic.
        mask: Only process voxels inside the specified mask.
        max_zeros: Specify how many beta/t-statistics can be zero.
        missing_data: Specify missing data handling.
        model_outliers: Model outliers with a Laplace distribution.
        n_nonzero: Number of non-zero beta values required.
        no_hktest: Specify not to use Hartung-Knapp adjustment.
        no_model_outliers: Specify not to model outliers.
        no_residual_z: Do not output residuals and their Z values.
        residual_z: Output residuals and their Z values.
        rio: Use R's io functions.
        equal_variance: Assume same cross-subjects variability between groups.
        unequal_variance: Model cross-subject variability difference between\
            groups.
        verb: Specify verbosity level.
        dbg_args: Output missing data debug file.
        help_: Show help message.
        conditions: Name of 1 or 2 conditions, tasks, or GLTs.
        no_tstat: Do not compute t-statistics.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dMEMA",
        "prefix": prefix,
        "set": set_,
        "cio": cio,
        "HKtest": hktest,
        "model_outliers": model_outliers,
        "no_HKtest": no_hktest,
        "no_model_outliers": no_model_outliers,
        "no_residual_Z": no_residual_z,
        "residual_Z": residual_z,
        "Rio": rio,
        "equal_variance": equal_variance,
        "unequal_variance": unequal_variance,
        "dbgArgs": dbg_args,
        "help": help_,
        "no_tstat": no_tstat,
    }
    if jobs is not None:
        params["jobs"] = jobs
    if covariates is not None:
        params["covariates"] = covariates
    if covariates_center is not None:
        params["covariates_center"] = covariates_center
    if covariates_model is not None:
        params["covariates_model"] = covariates_model
    if covariates_name is not None:
        params["covariates_name"] = covariates_name
    if groups is not None:
        params["groups"] = groups
    if mask is not None:
        params["mask"] = mask
    if max_zeros is not None:
        params["max_zeros"] = max_zeros
    if missing_data is not None:
        params["missing_data"] = missing_data
    if n_nonzero is not None:
        params["n_nonzero"] = n_nonzero
    if verb is not None:
        params["verb"] = verb
    if conditions is not None:
        params["conditions"] = conditions
    return params


def v_3d_mema_cargs(
    params: V3dMemaParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dMEMA")
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("jobs", None) is not None:
        cargs.extend([
            "-jobs",
            str(params.get("jobs", None))
        ])
    cargs.extend([
        "-set",
        *params.get("set", None)
    ])
    if params.get("covariates", None) is not None:
        cargs.extend([
            "-covariates",
            execution.input_file(params.get("covariates", None))
        ])
    if params.get("covariates_center", None) is not None:
        cargs.extend([
            "-covariates_center",
            params.get("covariates_center", None)
        ])
    if params.get("covariates_model", None) is not None:
        cargs.extend([
            "-covariates_model",
            params.get("covariates_model", None)
        ])
    if params.get("covariates_name", None) is not None:
        cargs.extend([
            "-covariates_name",
            *params.get("covariates_name", None)
        ])
    if params.get("groups", None) is not None:
        cargs.extend([
            "-groups",
            *params.get("groups", None)
        ])
    if params.get("cio", False):
        cargs.append("-cio")
    if params.get("HKtest", False):
        cargs.append("-HKtest")
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("max_zeros", None) is not None:
        cargs.extend([
            "-max_zeros",
            str(params.get("max_zeros", None))
        ])
    if params.get("missing_data", None) is not None:
        cargs.extend([
            "-missing_data",
            *params.get("missing_data", None)
        ])
    if params.get("model_outliers", False):
        cargs.append("-model_outliers")
    if params.get("n_nonzero", None) is not None:
        cargs.extend([
            "-n_nonzero",
            str(params.get("n_nonzero", None))
        ])
    if params.get("no_HKtest", False):
        cargs.append("-no_HKtest")
    if params.get("no_model_outliers", False):
        cargs.append("-no_model_outliers")
    if params.get("no_residual_Z", False):
        cargs.append("-no_residual_Z")
    if params.get("residual_Z", False):
        cargs.append("-residual_Z")
    if params.get("Rio", False):
        cargs.append("-Rio")
    if params.get("equal_variance", False):
        cargs.append("-equal_variance")
    if params.get("unequal_variance", False):
        cargs.append("-unequal_variance")
    if params.get("verb", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verb", None))
        ])
    if params.get("dbgArgs", False):
        cargs.append("-dbgArgs")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("conditions", None) is not None:
        cargs.extend([
            "-conditions",
            *params.get("conditions", None)
        ])
    if params.get("no_tstat", False):
        cargs.append("-no_tstat")
    return cargs


def v_3d_mema_outputs(
    params: V3dMemaParameters,
    execution: Execution,
) -> V3dMemaOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dMemaOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix", None) + ".nii.gz"),
    )
    return ret


def v_3d_mema_execute(
    params: V3dMemaParameters,
    runner: Runner | None = None,
) -> V3dMemaOutputs:
    """
    3dMEMA
    
    3dMEMA is a program for performing Mixed Effects Meta Analysis at group
    level that models both within- and across-subjects variability.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMemaOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_MEMA_METADATA)
    params = execution.params(params)
    cargs = v_3d_mema_cargs(params, execution)
    ret = v_3d_mema_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_mema(
    prefix: str,
    set_: list[str],
    jobs: float | None = None,
    covariates: InputPathType | None = None,
    covariates_center: str | None = None,
    covariates_model: str | None = None,
    covariates_name: list[str] | None = None,
    groups: list[str] | None = None,
    cio: bool = False,
    hktest: bool = False,
    mask: InputPathType | None = None,
    max_zeros: float | None = None,
    missing_data: list[str] | None = None,
    model_outliers: bool = False,
    n_nonzero: float | None = None,
    no_hktest: bool = False,
    no_model_outliers: bool = False,
    no_residual_z: bool = False,
    residual_z: bool = False,
    rio: bool = False,
    equal_variance: bool = False,
    unequal_variance: bool = False,
    verb: float | None = None,
    dbg_args: bool = False,
    help_: bool = False,
    conditions: list[str] | None = None,
    no_tstat: bool = False,
    runner: Runner | None = None,
) -> V3dMemaOutputs:
    """
    3dMEMA
    
    3dMEMA is a program for performing Mixed Effects Meta Analysis at group
    level that models both within- and across-subjects variability.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Output prefix (just prefix, no view+suffix needed).
        set_: Set data for one of the test variables.
        jobs: Number of jobs for parallel computing.
        covariates: Specify the name of a text file containing a table for the\
            covariate(s).
        covariates_center: Specify the center values for covariates.
        covariates_model: Specify how covariates should be modeled.
        covariates_name: Specify the name of each covariate.
        groups: Label of groups, used for output naming.
        cio: Use AFNI's C io functions.
        hktest: Perform Hartung-Knapp adjustment for the output t-statistic.
        mask: Only process voxels inside the specified mask.
        max_zeros: Specify how many beta/t-statistics can be zero.
        missing_data: Specify missing data handling.
        model_outliers: Model outliers with a Laplace distribution.
        n_nonzero: Number of non-zero beta values required.
        no_hktest: Specify not to use Hartung-Knapp adjustment.
        no_model_outliers: Specify not to model outliers.
        no_residual_z: Do not output residuals and their Z values.
        residual_z: Output residuals and their Z values.
        rio: Use R's io functions.
        equal_variance: Assume same cross-subjects variability between groups.
        unequal_variance: Model cross-subject variability difference between\
            groups.
        verb: Specify verbosity level.
        dbg_args: Output missing data debug file.
        help_: Show help message.
        conditions: Name of 1 or 2 conditions, tasks, or GLTs.
        no_tstat: Do not compute t-statistics.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMemaOutputs`).
    """
    params = v_3d_mema_params(
        prefix=prefix,
        jobs=jobs,
        set_=set_,
        covariates=covariates,
        covariates_center=covariates_center,
        covariates_model=covariates_model,
        covariates_name=covariates_name,
        groups=groups,
        cio=cio,
        hktest=hktest,
        mask=mask,
        max_zeros=max_zeros,
        missing_data=missing_data,
        model_outliers=model_outliers,
        n_nonzero=n_nonzero,
        no_hktest=no_hktest,
        no_model_outliers=no_model_outliers,
        no_residual_z=no_residual_z,
        residual_z=residual_z,
        rio=rio,
        equal_variance=equal_variance,
        unequal_variance=unequal_variance,
        verb=verb,
        dbg_args=dbg_args,
        help_=help_,
        conditions=conditions,
        no_tstat=no_tstat,
    )
    return v_3d_mema_execute(params, runner)


__all__ = [
    "V3dMemaOutputs",
    "V_3D_MEMA_METADATA",
    "v_3d_mema",
    "v_3d_mema_execute",
    "v_3d_mema_params",
]
