# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_MULTI_THRESH_METADATA = Metadata(
    id="f72f5d78b27fbaeb74d57fefdb1f807e2d3688b6.boutiques",
    name="3dMultiThresh",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dMultiThreshParameters = typing.TypedDict('V3dMultiThreshParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dMultiThresh"]],
    "mthresh_file": InputPathType,
    "input_file": InputPathType,
    "index": typing.NotRequired[float | None],
    "signed_flag": typing.NotRequired[str | None],
    "positive_sign_flag": bool,
    "negative_sign_flag": bool,
    "prefix": typing.NotRequired[str | None],
    "mask_only_flag": bool,
    "all_mask": typing.NotRequired[str | None],
    "no_zero_flag": bool,
    "quiet_flag": bool,
})
V3dMultiThreshParametersTagged = typing.TypedDict('V3dMultiThreshParametersTagged', {
    "@type": typing.Literal["afni/3dMultiThresh"],
    "mthresh_file": InputPathType,
    "input_file": InputPathType,
    "index": typing.NotRequired[float | None],
    "signed_flag": typing.NotRequired[str | None],
    "positive_sign_flag": bool,
    "negative_sign_flag": bool,
    "prefix": typing.NotRequired[str | None],
    "mask_only_flag": bool,
    "all_mask": typing.NotRequired[str | None],
    "no_zero_flag": bool,
    "quiet_flag": bool,
})


class V3dMultiThreshOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dMultiThreshParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType | None
    """Thresholded version of the input dataset."""
    mask_output: OutputPathType | None
    """0/1 mask dataset of voxels that survive the process."""
    all_mask_output: OutputPathType | None
    """Multi-volume dataset where each volume is the binary mask of voxels that
    pass ONE of the tests."""


def v_3d_multi_thresh_params(
    mthresh_file: InputPathType,
    input_file: InputPathType,
    index: float | None = None,
    signed_flag: str | None = None,
    positive_sign_flag: bool = False,
    negative_sign_flag: bool = False,
    prefix: str | None = None,
    mask_only_flag: bool = False,
    all_mask: str | None = None,
    no_zero_flag: bool = False,
    quiet_flag: bool = False,
) -> V3dMultiThreshParametersTagged:
    """
    Build parameters.
    
    Args:
        mthresh_file: Multi-threshold dataset from 3dXClustSim, usually via\
            running '3dttest++ -ETAC'.
        input_file: Dataset to threshold.
        index: Index (sub-brick) on which to threshold.
        signed_flag: Indicates if the .mthresh.nii file from 3dXClustSim was\
            created using 1-sided thresholding. Choose sign + or -.
        positive_sign_flag: Same as '-signed +'.
        negative_sign_flag: Same as '-signed -'.
        prefix: Prefix for output dataset. Can be 'NULL' to get no output\
            dataset.
        mask_only_flag: Instead of outputting a thresholded version of the\
            input dataset, just output a 0/1 mask dataset of voxels that survive\
            the process.
        all_mask: Write out a multi-volume dataset with prefix 'qqq' where each\
            volume is the binary mask of voxels that pass ONE of the tests.
        no_zero_flag: Prevents the output of a dataset if it would be all zero.
        quiet_flag: Turn off progress report messages.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dMultiThresh",
        "mthresh_file": mthresh_file,
        "input_file": input_file,
        "positive_sign_flag": positive_sign_flag,
        "negative_sign_flag": negative_sign_flag,
        "mask_only_flag": mask_only_flag,
        "no_zero_flag": no_zero_flag,
        "quiet_flag": quiet_flag,
    }
    if index is not None:
        params["index"] = index
    if signed_flag is not None:
        params["signed_flag"] = signed_flag
    if prefix is not None:
        params["prefix"] = prefix
    if all_mask is not None:
        params["all_mask"] = all_mask
    return params


def v_3d_multi_thresh_cargs(
    params: V3dMultiThreshParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dMultiThresh")
    cargs.extend([
        "-mthresh",
        execution.input_file(params.get("mthresh_file", None))
    ])
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file", None))
    ])
    if params.get("index", None) is not None:
        cargs.extend([
            "-1tindex",
            str(params.get("index", None))
        ])
    if params.get("signed_flag", None) is not None:
        cargs.extend([
            "-signed",
            params.get("signed_flag", None)
        ])
    if params.get("positive_sign_flag", False):
        cargs.append("-pos")
    if params.get("negative_sign_flag", False):
        cargs.append("-neg")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("mask_only_flag", False):
        cargs.append("-maskonly")
    if params.get("all_mask", None) is not None:
        cargs.extend([
            "-allmask",
            params.get("all_mask", None)
        ])
    if params.get("no_zero_flag", False):
        cargs.append("-nozero")
    if params.get("quiet_flag", False):
        cargs.append("-quiet")
    return cargs


def v_3d_multi_thresh_outputs(
    params: V3dMultiThreshParameters,
    execution: Execution,
) -> V3dMultiThreshOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dMultiThreshOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix", None) + ".nii.gz") if (params.get("prefix") is not None) else None,
        mask_output=execution.output_file(params.get("prefix", None) + "_mask.nii.gz") if (params.get("prefix") is not None) else None,
        all_mask_output=execution.output_file(params.get("all_mask", None) + ".nii.gz") if (params.get("all_mask") is not None) else None,
    )
    return ret


def v_3d_multi_thresh_execute(
    params: V3dMultiThreshParameters,
    runner: Runner | None = None,
) -> V3dMultiThreshOutputs:
    """
    3dMultiThresh
    
    Program to apply a multi-threshold (mthresh) dataset to an input dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMultiThreshOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_MULTI_THRESH_METADATA)
    params = execution.params(params)
    cargs = v_3d_multi_thresh_cargs(params, execution)
    ret = v_3d_multi_thresh_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_multi_thresh(
    mthresh_file: InputPathType,
    input_file: InputPathType,
    index: float | None = None,
    signed_flag: str | None = None,
    positive_sign_flag: bool = False,
    negative_sign_flag: bool = False,
    prefix: str | None = None,
    mask_only_flag: bool = False,
    all_mask: str | None = None,
    no_zero_flag: bool = False,
    quiet_flag: bool = False,
    runner: Runner | None = None,
) -> V3dMultiThreshOutputs:
    """
    3dMultiThresh
    
    Program to apply a multi-threshold (mthresh) dataset to an input dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        mthresh_file: Multi-threshold dataset from 3dXClustSim, usually via\
            running '3dttest++ -ETAC'.
        input_file: Dataset to threshold.
        index: Index (sub-brick) on which to threshold.
        signed_flag: Indicates if the .mthresh.nii file from 3dXClustSim was\
            created using 1-sided thresholding. Choose sign + or -.
        positive_sign_flag: Same as '-signed +'.
        negative_sign_flag: Same as '-signed -'.
        prefix: Prefix for output dataset. Can be 'NULL' to get no output\
            dataset.
        mask_only_flag: Instead of outputting a thresholded version of the\
            input dataset, just output a 0/1 mask dataset of voxels that survive\
            the process.
        all_mask: Write out a multi-volume dataset with prefix 'qqq' where each\
            volume is the binary mask of voxels that pass ONE of the tests.
        no_zero_flag: Prevents the output of a dataset if it would be all zero.
        quiet_flag: Turn off progress report messages.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMultiThreshOutputs`).
    """
    params = v_3d_multi_thresh_params(
        mthresh_file=mthresh_file,
        input_file=input_file,
        index=index,
        signed_flag=signed_flag,
        positive_sign_flag=positive_sign_flag,
        negative_sign_flag=negative_sign_flag,
        prefix=prefix,
        mask_only_flag=mask_only_flag,
        all_mask=all_mask,
        no_zero_flag=no_zero_flag,
        quiet_flag=quiet_flag,
    )
    return v_3d_multi_thresh_execute(params, runner)


__all__ = [
    "V3dMultiThreshOutputs",
    "V_3D_MULTI_THRESH_METADATA",
    "v_3d_multi_thresh",
    "v_3d_multi_thresh_execute",
    "v_3d_multi_thresh_params",
]
