# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_MVM_VALIDATOR_METADATA = Metadata(
    id="a3d780f06ce379cf9ef7ff9d1932a56c6f599810.boutiques",
    name="3dMVM_validator",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dMvmValidatorParameters = typing.TypedDict('V3dMvmValidatorParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dMVM_validator"]],
    "datatable": InputPathType,
    "shinyfolder": typing.NotRequired[str | None],
})
V3dMvmValidatorParametersTagged = typing.TypedDict('V3dMvmValidatorParametersTagged', {
    "@type": typing.Literal["afni/3dMVM_validator"],
    "datatable": InputPathType,
    "shinyfolder": typing.NotRequired[str | None],
})


class V3dMvmValidatorOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dMvmValidatorParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_mvm_validator_params(
    datatable: InputPathType,
    shinyfolder: str | None = None,
) -> V3dMvmValidatorParametersTagged:
    """
    Build parameters.
    
    Args:
        datatable: A file containing a data table formatted like the 3dMVM\
            "-dataTable".
        shinyfolder: Use a custom shiny folder (for testing purposes).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dMVM_validator",
        "datatable": datatable,
    }
    if shinyfolder is not None:
        params["shinyfolder"] = shinyfolder
    return params


def v_3d_mvm_validator_cargs(
    params: V3dMvmValidatorParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dMVM_validator")
    cargs.append(execution.input_file(params.get("datatable", None)))
    if params.get("shinyfolder", None) is not None:
        cargs.extend([
            "-ShinyFolder",
            params.get("shinyfolder", None)
        ])
    return cargs


def v_3d_mvm_validator_outputs(
    params: V3dMvmValidatorParameters,
    execution: Execution,
) -> V3dMvmValidatorOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dMvmValidatorOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_mvm_validator_execute(
    params: V3dMvmValidatorParameters,
    runner: Runner | None = None,
) -> V3dMvmValidatorOutputs:
    """
    3dMVM_validator
    
    Launch the 3dMVM model validation shiny app in a web browser.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMvmValidatorOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_MVM_VALIDATOR_METADATA)
    params = execution.params(params)
    cargs = v_3d_mvm_validator_cargs(params, execution)
    ret = v_3d_mvm_validator_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_mvm_validator(
    datatable: InputPathType,
    shinyfolder: str | None = None,
    runner: Runner | None = None,
) -> V3dMvmValidatorOutputs:
    """
    3dMVM_validator
    
    Launch the 3dMVM model validation shiny app in a web browser.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        datatable: A file containing a data table formatted like the 3dMVM\
            "-dataTable".
        shinyfolder: Use a custom shiny folder (for testing purposes).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dMvmValidatorOutputs`).
    """
    params = v_3d_mvm_validator_params(
        datatable=datatable,
        shinyfolder=shinyfolder,
    )
    return v_3d_mvm_validator_execute(params, runner)


__all__ = [
    "V3dMvmValidatorOutputs",
    "V_3D_MVM_VALIDATOR_METADATA",
    "v_3d_mvm_validator",
    "v_3d_mvm_validator_execute",
    "v_3d_mvm_validator_params",
]
