# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_NLFIM_METADATA = Metadata(
    id="0ec203e2d86e663bdc7138c21fa209799055bd66.boutiques",
    name="3dNLfim",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dNlfimParameters = typing.TypedDict('V3dNlfimParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dNLfim"]],
    "input_file": InputPathType,
    "signal_model": str,
    "noise_model": str,
    "mask": typing.NotRequired[InputPathType | None],
    "ignore": typing.NotRequired[int | None],
    "intr": typing.NotRequired[int | None],
    "tr": typing.NotRequired[int | None],
    "time_file": typing.NotRequired[InputPathType | None],
    "sconstr": typing.NotRequired[str | None],
    "nconstr": typing.NotRequired[str | None],
    "nabs": bool,
    "nrand": typing.NotRequired[int | None],
    "nbest": typing.NotRequired[int | None],
    "rmsmin": typing.NotRequired[float | None],
    "fdisp": typing.NotRequired[float | None],
    "progress": typing.NotRequired[int | None],
    "voxel_count": bool,
    "simplex": bool,
    "powell": bool,
    "both": bool,
    "freg": typing.NotRequired[str | None],
    "frsqr": typing.NotRequired[str | None],
    "fsmax": typing.NotRequired[str | None],
    "ftmax": typing.NotRequired[str | None],
    "fpsmax": typing.NotRequired[str | None],
    "farea": typing.NotRequired[str | None],
    "fparea": typing.NotRequired[str | None],
    "fscoef": typing.NotRequired[str | None],
    "fncoef": typing.NotRequired[str | None],
    "tscoef": typing.NotRequired[str | None],
    "tncoef": typing.NotRequired[str | None],
    "bucket": typing.NotRequired[str | None],
    "brick": typing.NotRequired[str | None],
    "nofdr": bool,
    "sfit": typing.NotRequired[str | None],
    "snfit": typing.NotRequired[str | None],
    "jobs": typing.NotRequired[int | None],
})
V3dNlfimParametersTagged = typing.TypedDict('V3dNlfimParametersTagged', {
    "@type": typing.Literal["afni/3dNLfim"],
    "input_file": InputPathType,
    "signal_model": str,
    "noise_model": str,
    "mask": typing.NotRequired[InputPathType | None],
    "ignore": typing.NotRequired[int | None],
    "intr": typing.NotRequired[int | None],
    "tr": typing.NotRequired[int | None],
    "time_file": typing.NotRequired[InputPathType | None],
    "sconstr": typing.NotRequired[str | None],
    "nconstr": typing.NotRequired[str | None],
    "nabs": bool,
    "nrand": typing.NotRequired[int | None],
    "nbest": typing.NotRequired[int | None],
    "rmsmin": typing.NotRequired[float | None],
    "fdisp": typing.NotRequired[float | None],
    "progress": typing.NotRequired[int | None],
    "voxel_count": bool,
    "simplex": bool,
    "powell": bool,
    "both": bool,
    "freg": typing.NotRequired[str | None],
    "frsqr": typing.NotRequired[str | None],
    "fsmax": typing.NotRequired[str | None],
    "ftmax": typing.NotRequired[str | None],
    "fpsmax": typing.NotRequired[str | None],
    "farea": typing.NotRequired[str | None],
    "fparea": typing.NotRequired[str | None],
    "fscoef": typing.NotRequired[str | None],
    "fncoef": typing.NotRequired[str | None],
    "tscoef": typing.NotRequired[str | None],
    "tncoef": typing.NotRequired[str | None],
    "bucket": typing.NotRequired[str | None],
    "brick": typing.NotRequired[str | None],
    "nofdr": bool,
    "sfit": typing.NotRequired[str | None],
    "snfit": typing.NotRequired[str | None],
    "jobs": typing.NotRequired[int | None],
})


class V3dNlfimOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dNlfimParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    freg_outfile: OutputPathType | None
    """F-test for significance of the regression"""
    frsqr_outfile: OutputPathType | None
    """R^2 calculation for regression"""
    fsmax_outfile: OutputPathType | None
    """Signed maximum signal estimate"""
    ftmax_outfile: OutputPathType | None
    """Time of signed maximum estimate"""
    fpsmax_outfile: OutputPathType | None
    """Maximum percentage change estimate"""
    farea_outfile: OutputPathType | None
    """Area between signal and baseline"""
    fparea_outfile: OutputPathType | None
    """Percentage area of signal estimate"""
    fscoef_outfile: OutputPathType | None
    """Signal parameter estimate"""
    fncoef_outfile: OutputPathType | None
    """Noise parameter estimate"""
    tscoef_outfile: OutputPathType | None
    """T-test for significance of signal parameter"""
    tncoef_outfile: OutputPathType | None
    """T-test for significance of noise parameter"""
    bucket_outfile: OutputPathType | None
    """AFNI 'bucket' dataset"""
    sfit_outfile: OutputPathType | None
    """Output 3d+time signal model fit"""
    snfit_outfile: OutputPathType | None
    """Output 3d+time signal+noise fit"""


def v_3d_nlfim_params(
    input_file: InputPathType,
    signal_model: str,
    noise_model: str,
    mask: InputPathType | None = None,
    ignore: int | None = None,
    intr: int | None = None,
    tr: int | None = None,
    time_file: InputPathType | None = None,
    sconstr: str | None = None,
    nconstr: str | None = None,
    nabs: bool = False,
    nrand: int | None = None,
    nbest: int | None = None,
    rmsmin: float | None = None,
    fdisp: float | None = None,
    progress: int | None = None,
    voxel_count: bool = False,
    simplex: bool = False,
    powell: bool = False,
    both: bool = False,
    freg: str | None = None,
    frsqr: str | None = None,
    fsmax: str | None = None,
    ftmax: str | None = None,
    fpsmax: str | None = None,
    farea: str | None = None,
    fparea: str | None = None,
    fscoef: str | None = None,
    fncoef: str | None = None,
    tscoef: str | None = None,
    tncoef: str | None = None,
    bucket: str | None = None,
    brick: str | None = None,
    nofdr: bool = False,
    sfit: str | None = None,
    snfit: str | None = None,
    jobs: int | None = None,
) -> V3dNlfimParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Filename of 3d+time data file for input.
        signal_model: Name of the nonlinear signal model.
        noise_model: Name of the linear noise model.
        mask: Use the 0 sub-brick of dataset 'mset' as a mask to indicate which\
            voxels to analyze.
        ignore: Skip this number of initial images in the time series for\
            regression analysis; default = 0.
        intr: Set the TR of the input 3d+time dataset.
        tr: Directly set the TR of the time series model.
        time_file: ASCII file containing each time point in the time series.
        sconstr: Constraints for signal parameters; c <= gs[k] <= d.
        nconstr: Constraints for noise parameters; c+b[k] <= gn[k] <= d+b[k].
        nabs: Use absolute constraints for noise parameters; c <= gn[k] <= d.
        nrand: Number of random test points; default=19999.
        nbest: Use b best test points to start; default=9.
        rmsmin: Minimum RMS error to reject reduced model.
        fdisp: Display results for those voxels whose F-statistic is greater\
            than fval; default=999.0.
        progress: Display results every ival number of voxels.
        voxel_count: Display the current voxel index.
        simplex: Use Nelder-Mead simplex method for least-square minimization\
            (default).
        powell: Use Powell's NEWUOA method instead of Nelder-Mead simplex\
            method.
        both: Use both Powell's and Nelder-Mead method.
        freg: Perform F-test for significance of the regression; output 'fift'\
            is written to prefix filename fname.
        frsqr: Calculate R^2 (coef. of multiple determination); store along\
            with F-test for regression; output 'fift' is written to prefix filename\
            fname.
        fsmax: Estimate signed maximum of signal; store along with F-test for\
            regression; output 'fift' is written to prefix filename fname.
        ftmax: Estimate time of signed maximum; store along with F-test for\
            regression; output 'fift' is written to prefix filename fname.
        fpsmax: Calculate (signed) maximum percentage change of signal from\
            baseline; output 'fift' is written to prefix filename fname.
        farea: Calculate area between signal and baseline; store with F-test\
            for regression; output 'fift' is written to prefix filename fname.
        fparea: Percentage area of signal relative to baseline; store with\
            F-test for regression; output 'fift' is written to prefix filename\
            fname.
        fscoef: Estimate kth signal parameter gs[k]; store along with F-test\
            for regression; output 'fift' is written to prefix filename fname.
        fncoef: Estimate kth noise parameter gn[k]; store along with F-test for\
            regression; output 'fift' is written to prefix filename fname.
        tscoef: Perform t-test for significance of kth signal parameter gs[k];\
            output 'fitt' is written to prefix filename fname.
        tncoef: Perform t-test for significance of kth noise parameter gn[k];\
            output 'fitt' is written to prefix filename fname.
        bucket: Create one AFNI 'bucket' dataset containing n sub-bricks; n=0\
            creates default output; output 'bucket' is written to prefixname.
        brick: Specify sub-brick contents for 'bucket' dataset.
        nofdr: Don't write the FDR (q vs. threshold) curves into the output\
            dataset.
        sfit: Prefix for output 3d+time signal model fit.
        snfit: Prefix for output 3d+time signal+noise fit.
        jobs: Run the program with 'J' jobs (sub-processes). 1 to 32.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dNLfim",
        "input_file": input_file,
        "signal_model": signal_model,
        "noise_model": noise_model,
        "nabs": nabs,
        "voxel_count": voxel_count,
        "simplex": simplex,
        "powell": powell,
        "both": both,
        "nofdr": nofdr,
    }
    if mask is not None:
        params["mask"] = mask
    if ignore is not None:
        params["ignore"] = ignore
    if intr is not None:
        params["intr"] = intr
    if tr is not None:
        params["tr"] = tr
    if time_file is not None:
        params["time_file"] = time_file
    if sconstr is not None:
        params["sconstr"] = sconstr
    if nconstr is not None:
        params["nconstr"] = nconstr
    if nrand is not None:
        params["nrand"] = nrand
    if nbest is not None:
        params["nbest"] = nbest
    if rmsmin is not None:
        params["rmsmin"] = rmsmin
    if fdisp is not None:
        params["fdisp"] = fdisp
    if progress is not None:
        params["progress"] = progress
    if freg is not None:
        params["freg"] = freg
    if frsqr is not None:
        params["frsqr"] = frsqr
    if fsmax is not None:
        params["fsmax"] = fsmax
    if ftmax is not None:
        params["ftmax"] = ftmax
    if fpsmax is not None:
        params["fpsmax"] = fpsmax
    if farea is not None:
        params["farea"] = farea
    if fparea is not None:
        params["fparea"] = fparea
    if fscoef is not None:
        params["fscoef"] = fscoef
    if fncoef is not None:
        params["fncoef"] = fncoef
    if tscoef is not None:
        params["tscoef"] = tscoef
    if tncoef is not None:
        params["tncoef"] = tncoef
    if bucket is not None:
        params["bucket"] = bucket
    if brick is not None:
        params["brick"] = brick
    if sfit is not None:
        params["sfit"] = sfit
    if snfit is not None:
        params["snfit"] = snfit
    if jobs is not None:
        params["jobs"] = jobs
    return params


def v_3d_nlfim_cargs(
    params: V3dNlfimParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dNLfim")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file", None))
    ])
    cargs.extend([
        "-signal",
        params.get("signal_model", None)
    ])
    cargs.extend([
        "-noise",
        params.get("noise_model", None)
    ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("ignore", None) is not None:
        cargs.extend([
            "-ignore",
            str(params.get("ignore", None))
        ])
    if params.get("intr", None) is not None:
        cargs.extend([
            "-inTR",
            str(params.get("intr", None))
        ])
    if params.get("tr", None) is not None:
        cargs.extend([
            "-TR",
            str(params.get("tr", None))
        ])
    if params.get("time_file", None) is not None:
        cargs.extend([
            "-time",
            execution.input_file(params.get("time_file", None))
        ])
    if params.get("sconstr", None) is not None:
        cargs.extend([
            "-sconstr",
            params.get("sconstr", None)
        ])
    if params.get("nconstr", None) is not None:
        cargs.extend([
            "-nconstr",
            params.get("nconstr", None)
        ])
    if params.get("nabs", False):
        cargs.append("-nabs")
    if params.get("nrand", None) is not None:
        cargs.extend([
            "-nrand",
            str(params.get("nrand", None))
        ])
    if params.get("nbest", None) is not None:
        cargs.extend([
            "-nbest",
            str(params.get("nbest", None))
        ])
    if params.get("rmsmin", None) is not None:
        cargs.extend([
            "-rmsmin",
            str(params.get("rmsmin", None))
        ])
    if params.get("fdisp", None) is not None:
        cargs.extend([
            "-fdisp",
            str(params.get("fdisp", None))
        ])
    if params.get("progress", None) is not None:
        cargs.extend([
            "-progress",
            str(params.get("progress", None))
        ])
    if params.get("voxel_count", False):
        cargs.append("-voxel_count")
    if params.get("simplex", False):
        cargs.append("-SIMPLEX")
    if params.get("powell", False):
        cargs.append("-POWELL")
    if params.get("both", False):
        cargs.append("-BOTH")
    if params.get("freg", None) is not None:
        cargs.extend([
            "-freg",
            params.get("freg", None)
        ])
    if params.get("frsqr", None) is not None:
        cargs.extend([
            "-frsqr",
            params.get("frsqr", None)
        ])
    if params.get("fsmax", None) is not None:
        cargs.extend([
            "-fsmax",
            params.get("fsmax", None)
        ])
    if params.get("ftmax", None) is not None:
        cargs.extend([
            "-ftmax",
            params.get("ftmax", None)
        ])
    if params.get("fpsmax", None) is not None:
        cargs.extend([
            "-fpsmax",
            params.get("fpsmax", None)
        ])
    if params.get("farea", None) is not None:
        cargs.extend([
            "-farea",
            params.get("farea", None)
        ])
    if params.get("fparea", None) is not None:
        cargs.extend([
            "-fparea",
            params.get("fparea", None)
        ])
    if params.get("fscoef", None) is not None:
        cargs.extend([
            "-fscoef",
            params.get("fscoef", None)
        ])
    if params.get("fncoef", None) is not None:
        cargs.extend([
            "-fncoef",
            params.get("fncoef", None)
        ])
    if params.get("tscoef", None) is not None:
        cargs.extend([
            "-tscoef",
            params.get("tscoef", None)
        ])
    if params.get("tncoef", None) is not None:
        cargs.extend([
            "-tncoef",
            params.get("tncoef", None)
        ])
    if params.get("bucket", None) is not None:
        cargs.extend([
            "-bucket",
            params.get("bucket", None)
        ])
    if params.get("brick", None) is not None:
        cargs.extend([
            "-brick",
            params.get("brick", None)
        ])
    if params.get("nofdr", False):
        cargs.append("-noFDR")
    if params.get("sfit", None) is not None:
        cargs.extend([
            "-sfit",
            params.get("sfit", None)
        ])
    if params.get("snfit", None) is not None:
        cargs.extend([
            "-snfit",
            params.get("snfit", None)
        ])
    if params.get("jobs", None) is not None:
        cargs.extend([
            "-jobs",
            str(params.get("jobs", None))
        ])
    return cargs


def v_3d_nlfim_outputs(
    params: V3dNlfimParameters,
    execution: Execution,
) -> V3dNlfimOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dNlfimOutputs(
        root=execution.output_file("."),
        freg_outfile=execution.output_file(params.get("freg", None) + ".fift") if (params.get("freg") is not None) else None,
        frsqr_outfile=execution.output_file(params.get("frsqr", None) + ".fift") if (params.get("frsqr") is not None) else None,
        fsmax_outfile=execution.output_file(params.get("fsmax", None) + ".fift") if (params.get("fsmax") is not None) else None,
        ftmax_outfile=execution.output_file(params.get("ftmax", None) + ".fift") if (params.get("ftmax") is not None) else None,
        fpsmax_outfile=execution.output_file(params.get("fpsmax", None) + ".fift") if (params.get("fpsmax") is not None) else None,
        farea_outfile=execution.output_file(params.get("farea", None) + ".fift") if (params.get("farea") is not None) else None,
        fparea_outfile=execution.output_file(params.get("fparea", None) + ".fift") if (params.get("fparea") is not None) else None,
        fscoef_outfile=execution.output_file(params.get("fscoef", None) + ".fift") if (params.get("fscoef") is not None) else None,
        fncoef_outfile=execution.output_file(params.get("fncoef", None) + ".fift") if (params.get("fncoef") is not None) else None,
        tscoef_outfile=execution.output_file(params.get("tscoef", None) + ".fitt") if (params.get("tscoef") is not None) else None,
        tncoef_outfile=execution.output_file(params.get("tncoef", None) + ".fitt") if (params.get("tncoef") is not None) else None,
        bucket_outfile=execution.output_file(params.get("bucket", None) + ".bucket") if (params.get("bucket") is not None) else None,
        sfit_outfile=execution.output_file(params.get("sfit", None) + ".sfit") if (params.get("sfit") is not None) else None,
        snfit_outfile=execution.output_file(params.get("snfit", None) + ".snfit") if (params.get("snfit") is not None) else None,
    )
    return ret


def v_3d_nlfim_execute(
    params: V3dNlfimParameters,
    runner: Runner | None = None,
) -> V3dNlfimOutputs:
    """
    3dNLfim
    
    Nonlinear regression for each voxel of the input AFNI 3d+time data set.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNlfimOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_NLFIM_METADATA)
    params = execution.params(params)
    cargs = v_3d_nlfim_cargs(params, execution)
    ret = v_3d_nlfim_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_nlfim(
    input_file: InputPathType,
    signal_model: str,
    noise_model: str,
    mask: InputPathType | None = None,
    ignore: int | None = None,
    intr: int | None = None,
    tr: int | None = None,
    time_file: InputPathType | None = None,
    sconstr: str | None = None,
    nconstr: str | None = None,
    nabs: bool = False,
    nrand: int | None = None,
    nbest: int | None = None,
    rmsmin: float | None = None,
    fdisp: float | None = None,
    progress: int | None = None,
    voxel_count: bool = False,
    simplex: bool = False,
    powell: bool = False,
    both: bool = False,
    freg: str | None = None,
    frsqr: str | None = None,
    fsmax: str | None = None,
    ftmax: str | None = None,
    fpsmax: str | None = None,
    farea: str | None = None,
    fparea: str | None = None,
    fscoef: str | None = None,
    fncoef: str | None = None,
    tscoef: str | None = None,
    tncoef: str | None = None,
    bucket: str | None = None,
    brick: str | None = None,
    nofdr: bool = False,
    sfit: str | None = None,
    snfit: str | None = None,
    jobs: int | None = None,
    runner: Runner | None = None,
) -> V3dNlfimOutputs:
    """
    3dNLfim
    
    Nonlinear regression for each voxel of the input AFNI 3d+time data set.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Filename of 3d+time data file for input.
        signal_model: Name of the nonlinear signal model.
        noise_model: Name of the linear noise model.
        mask: Use the 0 sub-brick of dataset 'mset' as a mask to indicate which\
            voxels to analyze.
        ignore: Skip this number of initial images in the time series for\
            regression analysis; default = 0.
        intr: Set the TR of the input 3d+time dataset.
        tr: Directly set the TR of the time series model.
        time_file: ASCII file containing each time point in the time series.
        sconstr: Constraints for signal parameters; c <= gs[k] <= d.
        nconstr: Constraints for noise parameters; c+b[k] <= gn[k] <= d+b[k].
        nabs: Use absolute constraints for noise parameters; c <= gn[k] <= d.
        nrand: Number of random test points; default=19999.
        nbest: Use b best test points to start; default=9.
        rmsmin: Minimum RMS error to reject reduced model.
        fdisp: Display results for those voxels whose F-statistic is greater\
            than fval; default=999.0.
        progress: Display results every ival number of voxels.
        voxel_count: Display the current voxel index.
        simplex: Use Nelder-Mead simplex method for least-square minimization\
            (default).
        powell: Use Powell's NEWUOA method instead of Nelder-Mead simplex\
            method.
        both: Use both Powell's and Nelder-Mead method.
        freg: Perform F-test for significance of the regression; output 'fift'\
            is written to prefix filename fname.
        frsqr: Calculate R^2 (coef. of multiple determination); store along\
            with F-test for regression; output 'fift' is written to prefix filename\
            fname.
        fsmax: Estimate signed maximum of signal; store along with F-test for\
            regression; output 'fift' is written to prefix filename fname.
        ftmax: Estimate time of signed maximum; store along with F-test for\
            regression; output 'fift' is written to prefix filename fname.
        fpsmax: Calculate (signed) maximum percentage change of signal from\
            baseline; output 'fift' is written to prefix filename fname.
        farea: Calculate area between signal and baseline; store with F-test\
            for regression; output 'fift' is written to prefix filename fname.
        fparea: Percentage area of signal relative to baseline; store with\
            F-test for regression; output 'fift' is written to prefix filename\
            fname.
        fscoef: Estimate kth signal parameter gs[k]; store along with F-test\
            for regression; output 'fift' is written to prefix filename fname.
        fncoef: Estimate kth noise parameter gn[k]; store along with F-test for\
            regression; output 'fift' is written to prefix filename fname.
        tscoef: Perform t-test for significance of kth signal parameter gs[k];\
            output 'fitt' is written to prefix filename fname.
        tncoef: Perform t-test for significance of kth noise parameter gn[k];\
            output 'fitt' is written to prefix filename fname.
        bucket: Create one AFNI 'bucket' dataset containing n sub-bricks; n=0\
            creates default output; output 'bucket' is written to prefixname.
        brick: Specify sub-brick contents for 'bucket' dataset.
        nofdr: Don't write the FDR (q vs. threshold) curves into the output\
            dataset.
        sfit: Prefix for output 3d+time signal model fit.
        snfit: Prefix for output 3d+time signal+noise fit.
        jobs: Run the program with 'J' jobs (sub-processes). 1 to 32.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNlfimOutputs`).
    """
    params = v_3d_nlfim_params(
        input_file=input_file,
        signal_model=signal_model,
        noise_model=noise_model,
        mask=mask,
        ignore=ignore,
        intr=intr,
        tr=tr,
        time_file=time_file,
        sconstr=sconstr,
        nconstr=nconstr,
        nabs=nabs,
        nrand=nrand,
        nbest=nbest,
        rmsmin=rmsmin,
        fdisp=fdisp,
        progress=progress,
        voxel_count=voxel_count,
        simplex=simplex,
        powell=powell,
        both=both,
        freg=freg,
        frsqr=frsqr,
        fsmax=fsmax,
        ftmax=ftmax,
        fpsmax=fpsmax,
        farea=farea,
        fparea=fparea,
        fscoef=fscoef,
        fncoef=fncoef,
        tscoef=tscoef,
        tncoef=tncoef,
        bucket=bucket,
        brick=brick,
        nofdr=nofdr,
        sfit=sfit,
        snfit=snfit,
        jobs=jobs,
    )
    return v_3d_nlfim_execute(params, runner)


__all__ = [
    "V3dNlfimOutputs",
    "V_3D_NLFIM_METADATA",
    "v_3d_nlfim",
    "v_3d_nlfim_execute",
    "v_3d_nlfim_params",
]
