# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_NORMALITY_TEST_METADATA = Metadata(
    id="f4e493074cf1abbf672c4d1c6107ad9f408737a2.boutiques",
    name="3dNormalityTest",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dNormalityTestParameters = typing.TypedDict('V3dNormalityTestParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dNormalityTest"]],
    "input": InputPathType,
    "prefix": str,
    "noexp": bool,
    "pval": bool,
})
V3dNormalityTestParametersTagged = typing.TypedDict('V3dNormalityTestParametersTagged', {
    "@type": typing.Literal["afni/3dNormalityTest"],
    "input": InputPathType,
    "prefix": str,
    "noexp": bool,
    "pval": bool,
})


class V3dNormalityTestOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dNormalityTestParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType
    """Output dataset with results"""


def v_3d_normality_test_params(
    input_: InputPathType,
    prefix: str,
    noexp: bool = False,
    pval: bool = False,
) -> V3dNormalityTestParametersTagged:
    """
    Build parameters.
    
    Args:
        input_: Specifies the input dataset.
        prefix: Specifies the name for the output dataset.
        noexp: Do not convert the A-D statistic to an exponentially distributed\
            value.
        pval: Output the results as a pure (estimated) p-value.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dNormalityTest",
        "input": input_,
        "prefix": prefix,
        "noexp": noexp,
        "pval": pval,
    }
    return params


def v_3d_normality_test_cargs(
    params: V3dNormalityTestParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dNormalityTest")
    cargs.append(execution.input_file(params.get("input", None)))
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("noexp", False):
        cargs.append("-noexp")
    if params.get("pval", False):
        cargs.append("-pval")
    return cargs


def v_3d_normality_test_outputs(
    params: V3dNormalityTestParameters,
    execution: Execution,
) -> V3dNormalityTestOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dNormalityTestOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file(params.get("prefix", None) + "+orig"),
    )
    return ret


def v_3d_normality_test_execute(
    params: V3dNormalityTestParameters,
    runner: Runner | None = None,
) -> V3dNormalityTestOutputs:
    """
    3dNormalityTest
    
    This program tests the input values at each voxel for normality using the
    Anderson-Darling method.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNormalityTestOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_NORMALITY_TEST_METADATA)
    params = execution.params(params)
    cargs = v_3d_normality_test_cargs(params, execution)
    ret = v_3d_normality_test_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_normality_test(
    input_: InputPathType,
    prefix: str,
    noexp: bool = False,
    pval: bool = False,
    runner: Runner | None = None,
) -> V3dNormalityTestOutputs:
    """
    3dNormalityTest
    
    This program tests the input values at each voxel for normality using the
    Anderson-Darling method.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_: Specifies the input dataset.
        prefix: Specifies the name for the output dataset.
        noexp: Do not convert the A-D statistic to an exponentially distributed\
            value.
        pval: Output the results as a pure (estimated) p-value.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNormalityTestOutputs`).
    """
    params = v_3d_normality_test_params(
        input_=input_,
        prefix=prefix,
        noexp=noexp,
        pval=pval,
    )
    return v_3d_normality_test_execute(params, runner)


__all__ = [
    "V3dNormalityTestOutputs",
    "V_3D_NORMALITY_TEST_METADATA",
    "v_3d_normality_test",
    "v_3d_normality_test_execute",
    "v_3d_normality_test_params",
]
