# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_NOTES_METADATA = Metadata(
    id="1756987bc517c02b04ed29f17cd59746f7a1e6a8.boutiques",
    name="3dNotes",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dNotesParameters = typing.TypedDict('V3dNotesParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dNotes"]],
    "add_note": typing.NotRequired[str | None],
    "append_history": typing.NotRequired[str | None],
    "replace_history": typing.NotRequired[str | None],
    "delete_note": typing.NotRequired[float | None],
    "print_notes": bool,
    "help": bool,
    "dataset": InputPathType,
})
V3dNotesParametersTagged = typing.TypedDict('V3dNotesParametersTagged', {
    "@type": typing.Literal["afni/3dNotes"],
    "add_note": typing.NotRequired[str | None],
    "append_history": typing.NotRequired[str | None],
    "replace_history": typing.NotRequired[str | None],
    "delete_note": typing.NotRequired[float | None],
    "print_notes": bool,
    "help": bool,
    "dataset": InputPathType,
})


class V3dNotesOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dNotesParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_notes_params(
    dataset: InputPathType,
    add_note: str | None = None,
    append_history: str | None = None,
    replace_history: str | None = None,
    delete_note: float | None = None,
    print_notes: bool = False,
    help_: bool = False,
) -> V3dNotesParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: AFNI compatible dataset [required].
        add_note: Add the string 'str' to the list of notes.
        append_history: Append the string 'str' to the dataset's history. This\
            can only appear once on the command line.
        replace_history: Replace any existing history note with 'str'. This\
            option cannot be used with '-h'.
        delete_note: Deletes note number num.
        print_notes: Print to stdout the expanded notes.
        help_: Displays this help screen.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dNotes",
        "print_notes": print_notes,
        "help": help_,
        "dataset": dataset,
    }
    if add_note is not None:
        params["add_note"] = add_note
    if append_history is not None:
        params["append_history"] = append_history
    if replace_history is not None:
        params["replace_history"] = replace_history
    if delete_note is not None:
        params["delete_note"] = delete_note
    return params


def v_3d_notes_cargs(
    params: V3dNotesParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dNotes")
    if params.get("add_note", None) is not None:
        cargs.extend([
            "-a",
            params.get("add_note", None)
        ])
    if params.get("append_history", None) is not None:
        cargs.extend([
            "-h",
            params.get("append_history", None)
        ])
    if params.get("replace_history", None) is not None:
        cargs.extend([
            "-HH",
            params.get("replace_history", None)
        ])
    if params.get("delete_note", None) is not None:
        cargs.extend([
            "-d",
            str(params.get("delete_note", None))
        ])
    if params.get("print_notes", False):
        cargs.append("-ses")
    if params.get("help", False):
        cargs.append("-help")
    cargs.append(execution.input_file(params.get("dataset", None)))
    return cargs


def v_3d_notes_outputs(
    params: V3dNotesParameters,
    execution: Execution,
) -> V3dNotesOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dNotesOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_notes_execute(
    params: V3dNotesParameters,
    runner: Runner | None = None,
) -> V3dNotesOutputs:
    """
    3dNotes
    
    A program to add, delete and show notes for AFNI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNotesOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_NOTES_METADATA)
    params = execution.params(params)
    cargs = v_3d_notes_cargs(params, execution)
    ret = v_3d_notes_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_notes(
    dataset: InputPathType,
    add_note: str | None = None,
    append_history: str | None = None,
    replace_history: str | None = None,
    delete_note: float | None = None,
    print_notes: bool = False,
    help_: bool = False,
    runner: Runner | None = None,
) -> V3dNotesOutputs:
    """
    3dNotes
    
    A program to add, delete and show notes for AFNI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: AFNI compatible dataset [required].
        add_note: Add the string 'str' to the list of notes.
        append_history: Append the string 'str' to the dataset's history. This\
            can only appear once on the command line.
        replace_history: Replace any existing history note with 'str'. This\
            option cannot be used with '-h'.
        delete_note: Deletes note number num.
        print_notes: Print to stdout the expanded notes.
        help_: Displays this help screen.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNotesOutputs`).
    """
    params = v_3d_notes_params(
        add_note=add_note,
        append_history=append_history,
        replace_history=replace_history,
        delete_note=delete_note,
        print_notes=print_notes,
        help_=help_,
        dataset=dataset,
    )
    return v_3d_notes_execute(params, runner)


__all__ = [
    "V3dNotesOutputs",
    "V_3D_NOTES_METADATA",
    "v_3d_notes",
    "v_3d_notes_execute",
    "v_3d_notes_params",
]
