# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_NWARP_APPLY_METADATA = Metadata(
    id="b697b26d251dbe1445c036c2a8bcc84105820fb1.boutiques",
    name="3dNwarpApply",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dNwarpApplyParameters = typing.TypedDict('V3dNwarpApplyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dNwarpApply"]],
    "nwarp": str,
    "iwarp": bool,
    "source": str,
    "master": typing.NotRequired[str | None],
    "newgrid": typing.NotRequired[str | None],
    "dxyz": typing.NotRequired[str | None],
    "interp": typing.NotRequired[str | None],
    "ainterp": typing.NotRequired[str | None],
    "prefix": typing.NotRequired[str | None],
    "suffix": typing.NotRequired[str | None],
    "short": bool,
    "wprefix": typing.NotRequired[str | None],
    "quiet": bool,
    "verb": bool,
})
V3dNwarpApplyParametersTagged = typing.TypedDict('V3dNwarpApplyParametersTagged', {
    "@type": typing.Literal["afni/3dNwarpApply"],
    "nwarp": str,
    "iwarp": bool,
    "source": str,
    "master": typing.NotRequired[str | None],
    "newgrid": typing.NotRequired[str | None],
    "dxyz": typing.NotRequired[str | None],
    "interp": typing.NotRequired[str | None],
    "ainterp": typing.NotRequired[str | None],
    "prefix": typing.NotRequired[str | None],
    "suffix": typing.NotRequired[str | None],
    "short": bool,
    "wprefix": typing.NotRequired[str | None],
    "quiet": bool,
    "verb": bool,
})


class V3dNwarpApplyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dNwarpApplyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    warped_output: OutputPathType | None
    """Warped output dataset"""


def v_3d_nwarp_apply_params(
    nwarp: str,
    source: str,
    iwarp: bool = False,
    master: str | None = None,
    newgrid: str | None = None,
    dxyz: str | None = None,
    interp: str | None = None,
    ainterp: str | None = None,
    prefix: str | None = None,
    suffix: str | None = None,
    short: bool = False,
    wprefix: str | None = None,
    quiet: bool = False,
    verb: bool = False,
) -> V3dNwarpApplyParametersTagged:
    """
    Build parameters.
    
    Args:
        nwarp: The name of the 3D warp dataset. Multiple warps can be\
            catenated.
        source: The name of the source dataset to be warped. Multiple datasets\
            can be supplied.
        iwarp: Invert the warp specified in '-nwarp'.
        master: The name of the master dataset which defines the output grid.
        newgrid: The new grid spacing (cubical voxels, in mm).
        dxyz: Specify a different grid spacing (cubical voxels, in mm).
        interp: The interpolation mode ('NN', 'linear', 'cubic', 'quintic',\
            'wsinc5').
        ainterp: Specify a different interpolation mode for the data than the\
            warp.
        prefix: The name of the new output dataset. Multiple names can be\
            supplied if more than one source dataset is input.
        suffix: Change the default suffix '_Nwarp' to a user-defined suffix.
        short: Write output dataset using 16-bit short integers rather than the\
            usual 32-bit floats.
        wprefix: Save every warp generated in the process to a separate\
            dataset.
        quiet: Don't be verbose.
        verb: Be extra verbose.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dNwarpApply",
        "nwarp": nwarp,
        "iwarp": iwarp,
        "source": source,
        "short": short,
        "quiet": quiet,
        "verb": verb,
    }
    if master is not None:
        params["master"] = master
    if newgrid is not None:
        params["newgrid"] = newgrid
    if dxyz is not None:
        params["dxyz"] = dxyz
    if interp is not None:
        params["interp"] = interp
    if ainterp is not None:
        params["ainterp"] = ainterp
    if prefix is not None:
        params["prefix"] = prefix
    if suffix is not None:
        params["suffix"] = suffix
    if wprefix is not None:
        params["wprefix"] = wprefix
    return params


def v_3d_nwarp_apply_cargs(
    params: V3dNwarpApplyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dNwarpApply")
    cargs.extend([
        "-nwarp",
        params.get("nwarp", None)
    ])
    if params.get("iwarp", False):
        cargs.append("-iwarp")
    cargs.extend([
        "-source",
        params.get("source", None)
    ])
    if params.get("master", None) is not None:
        cargs.extend([
            "-master",
            params.get("master", None)
        ])
    if params.get("newgrid", None) is not None:
        cargs.extend([
            "-newgrid",
            params.get("newgrid", None)
        ])
    if params.get("dxyz", None) is not None:
        cargs.extend([
            "-dxyz",
            params.get("dxyz", None)
        ])
    if params.get("interp", None) is not None:
        cargs.extend([
            "-interp",
            params.get("interp", None)
        ])
    if params.get("ainterp", None) is not None:
        cargs.extend([
            "-ainterp",
            params.get("ainterp", None)
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("suffix", None) is not None:
        cargs.extend([
            "-suffix",
            params.get("suffix", None)
        ])
    if params.get("short", False):
        cargs.append("-short")
    if params.get("wprefix", None) is not None:
        cargs.extend([
            "-wprefix",
            params.get("wprefix", None)
        ])
    if params.get("quiet", False):
        cargs.append("-quiet")
    if params.get("verb", False):
        cargs.append("-verb")
    return cargs


def v_3d_nwarp_apply_outputs(
    params: V3dNwarpApplyParameters,
    execution: Execution,
) -> V3dNwarpApplyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dNwarpApplyOutputs(
        root=execution.output_file("."),
        warped_output=execution.output_file(params.get("prefix", None) + "_" + params.get("source", None) + "_warped.nii.gz") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_nwarp_apply_execute(
    params: V3dNwarpApplyParameters,
    runner: Runner | None = None,
) -> V3dNwarpApplyOutputs:
    """
    3dNwarpApply
    
    Program to apply a nonlinear 3D warp saved from 3dQwarp (or 3dNwarpCat,
    etc.) to a 3D dataset, to produce a warped version of the source dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNwarpApplyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_NWARP_APPLY_METADATA)
    params = execution.params(params)
    cargs = v_3d_nwarp_apply_cargs(params, execution)
    ret = v_3d_nwarp_apply_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_nwarp_apply(
    nwarp: str,
    source: str,
    iwarp: bool = False,
    master: str | None = None,
    newgrid: str | None = None,
    dxyz: str | None = None,
    interp: str | None = None,
    ainterp: str | None = None,
    prefix: str | None = None,
    suffix: str | None = None,
    short: bool = False,
    wprefix: str | None = None,
    quiet: bool = False,
    verb: bool = False,
    runner: Runner | None = None,
) -> V3dNwarpApplyOutputs:
    """
    3dNwarpApply
    
    Program to apply a nonlinear 3D warp saved from 3dQwarp (or 3dNwarpCat,
    etc.) to a 3D dataset, to produce a warped version of the source dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        nwarp: The name of the 3D warp dataset. Multiple warps can be\
            catenated.
        source: The name of the source dataset to be warped. Multiple datasets\
            can be supplied.
        iwarp: Invert the warp specified in '-nwarp'.
        master: The name of the master dataset which defines the output grid.
        newgrid: The new grid spacing (cubical voxels, in mm).
        dxyz: Specify a different grid spacing (cubical voxels, in mm).
        interp: The interpolation mode ('NN', 'linear', 'cubic', 'quintic',\
            'wsinc5').
        ainterp: Specify a different interpolation mode for the data than the\
            warp.
        prefix: The name of the new output dataset. Multiple names can be\
            supplied if more than one source dataset is input.
        suffix: Change the default suffix '_Nwarp' to a user-defined suffix.
        short: Write output dataset using 16-bit short integers rather than the\
            usual 32-bit floats.
        wprefix: Save every warp generated in the process to a separate\
            dataset.
        quiet: Don't be verbose.
        verb: Be extra verbose.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNwarpApplyOutputs`).
    """
    params = v_3d_nwarp_apply_params(
        nwarp=nwarp,
        iwarp=iwarp,
        source=source,
        master=master,
        newgrid=newgrid,
        dxyz=dxyz,
        interp=interp,
        ainterp=ainterp,
        prefix=prefix,
        suffix=suffix,
        short=short,
        wprefix=wprefix,
        quiet=quiet,
        verb=verb,
    )
    return v_3d_nwarp_apply_execute(params, runner)


__all__ = [
    "V3dNwarpApplyOutputs",
    "V_3D_NWARP_APPLY_METADATA",
    "v_3d_nwarp_apply",
    "v_3d_nwarp_apply_execute",
    "v_3d_nwarp_apply_params",
]
