# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_NWARP_CAT_METADATA = Metadata(
    id="62adbc513d6c3a93a1b123ab55b3308c6a6d676e.boutiques",
    name="3dNwarpCat",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dNwarpCatParameters = typing.TypedDict('V3dNwarpCatParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dNwarpCat"]],
    "interpolation": typing.NotRequired[str | None],
    "verbosity": bool,
    "output_prefix": str,
    "space_marker": typing.NotRequired[str | None],
    "warp1": InputPathType,
    "warp2": InputPathType,
    "additional_warps": typing.NotRequired[list[InputPathType] | None],
    "invert_final_warp": bool,
    "extra_padding": typing.NotRequired[float | None],
})
V3dNwarpCatParametersTagged = typing.TypedDict('V3dNwarpCatParametersTagged', {
    "@type": typing.Literal["afni/3dNwarpCat"],
    "interpolation": typing.NotRequired[str | None],
    "verbosity": bool,
    "output_prefix": str,
    "space_marker": typing.NotRequired[str | None],
    "warp1": InputPathType,
    "warp2": InputPathType,
    "additional_warps": typing.NotRequired[list[InputPathType] | None],
    "invert_final_warp": bool,
    "extra_padding": typing.NotRequired[float | None],
})


class V3dNwarpCatOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dNwarpCatParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_matrix: OutputPathType
    """Output matrix file when only matrix warps are provided."""
    output_dataset: OutputPathType
    """Output dataset when warp files are provided."""


def v_3d_nwarp_cat_params(
    output_prefix: str,
    warp1: InputPathType,
    warp2: InputPathType,
    interpolation: str | None = None,
    verbosity: bool = False,
    space_marker: str | None = None,
    additional_warps: list[InputPathType] | None = None,
    invert_final_warp: bool = False,
    extra_padding: float | None = None,
) -> V3dNwarpCatParametersTagged:
    """
    Build parameters.
    
    Args:
        output_prefix: Prefix name for the output dataset that holds the warp.
        warp1: Specify the first warp.
        warp2: Specify the second warp.
        interpolation: Interpolation mode: linear, quintic, or wsinc5\
            (default).
        verbosity: Print various fun messages during execution.
        space_marker: Attach string 'sss' to the output dataset as its atlas\
            space marker.
        additional_warps: Additional warp files.
        invert_final_warp: Invert the final warp before output.
        extra_padding: Pad the nonlinear warps by 'PP' voxels in all\
            directions.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dNwarpCat",
        "verbosity": verbosity,
        "output_prefix": output_prefix,
        "warp1": warp1,
        "warp2": warp2,
        "invert_final_warp": invert_final_warp,
    }
    if interpolation is not None:
        params["interpolation"] = interpolation
    if space_marker is not None:
        params["space_marker"] = space_marker
    if additional_warps is not None:
        params["additional_warps"] = additional_warps
    if extra_padding is not None:
        params["extra_padding"] = extra_padding
    return params


def v_3d_nwarp_cat_cargs(
    params: V3dNwarpCatParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dNwarpCat")
    if params.get("interpolation", None) is not None:
        cargs.extend([
            "-interp",
            params.get("interpolation", None)
        ])
    if params.get("verbosity", False):
        cargs.append("-verb")
    cargs.extend([
        "-prefix",
        params.get("output_prefix", None)
    ])
    if params.get("space_marker", None) is not None:
        cargs.extend([
            "-space",
            params.get("space_marker", None)
        ])
    cargs.extend([
        "-warp1",
        execution.input_file(params.get("warp1", None))
    ])
    cargs.extend([
        "-warp2",
        execution.input_file(params.get("warp2", None))
    ])
    if params.get("additional_warps", None) is not None:
        cargs.extend([execution.input_file(f) for f in params.get("additional_warps", None)])
    if params.get("invert_final_warp", False):
        cargs.append("-iwarp")
    if params.get("extra_padding", None) is not None:
        cargs.extend([
            "-expad",
            str(params.get("extra_padding", None))
        ])
    return cargs


def v_3d_nwarp_cat_outputs(
    params: V3dNwarpCatParameters,
    execution: Execution,
) -> V3dNwarpCatOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dNwarpCatOutputs(
        root=execution.output_file("."),
        output_matrix=execution.output_file(params.get("output_prefix", None) + ".aff12.1D"),
        output_dataset=execution.output_file(params.get("output_prefix", None) + "+tlrc.HEAD"),
    )
    return ret


def v_3d_nwarp_cat_execute(
    params: V3dNwarpCatParameters,
    runner: Runner | None = None,
) -> V3dNwarpCatOutputs:
    """
    3dNwarpCat
    
    Catenates (composes) 3D warps defined on a grid or via a matrix.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNwarpCatOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_NWARP_CAT_METADATA)
    params = execution.params(params)
    cargs = v_3d_nwarp_cat_cargs(params, execution)
    ret = v_3d_nwarp_cat_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_nwarp_cat(
    output_prefix: str,
    warp1: InputPathType,
    warp2: InputPathType,
    interpolation: str | None = None,
    verbosity: bool = False,
    space_marker: str | None = None,
    additional_warps: list[InputPathType] | None = None,
    invert_final_warp: bool = False,
    extra_padding: float | None = None,
    runner: Runner | None = None,
) -> V3dNwarpCatOutputs:
    """
    3dNwarpCat
    
    Catenates (composes) 3D warps defined on a grid or via a matrix.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        output_prefix: Prefix name for the output dataset that holds the warp.
        warp1: Specify the first warp.
        warp2: Specify the second warp.
        interpolation: Interpolation mode: linear, quintic, or wsinc5\
            (default).
        verbosity: Print various fun messages during execution.
        space_marker: Attach string 'sss' to the output dataset as its atlas\
            space marker.
        additional_warps: Additional warp files.
        invert_final_warp: Invert the final warp before output.
        extra_padding: Pad the nonlinear warps by 'PP' voxels in all\
            directions.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNwarpCatOutputs`).
    """
    params = v_3d_nwarp_cat_params(
        interpolation=interpolation,
        verbosity=verbosity,
        output_prefix=output_prefix,
        space_marker=space_marker,
        warp1=warp1,
        warp2=warp2,
        additional_warps=additional_warps,
        invert_final_warp=invert_final_warp,
        extra_padding=extra_padding,
    )
    return v_3d_nwarp_cat_execute(params, runner)


__all__ = [
    "V3dNwarpCatOutputs",
    "V_3D_NWARP_CAT_METADATA",
    "v_3d_nwarp_cat",
    "v_3d_nwarp_cat_execute",
    "v_3d_nwarp_cat_params",
]
