# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_NWARP_FUNCS_METADATA = Metadata(
    id="35ae1d7095534556f19806b182ded46e4021aa28.boutiques",
    name="3dNwarpFuncs",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dNwarpFuncsParameters = typing.TypedDict('V3dNwarpFuncsParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dNwarpFuncs"]],
    "input_warp": InputPathType,
    "output_prefix": str,
    "bulk_flag": bool,
    "shear_flag": bool,
    "vorticity_flag": bool,
    "all_flag": bool,
})
V3dNwarpFuncsParametersTagged = typing.TypedDict('V3dNwarpFuncsParametersTagged', {
    "@type": typing.Literal["afni/3dNwarpFuncs"],
    "input_warp": InputPathType,
    "output_prefix": str,
    "bulk_flag": bool,
    "shear_flag": bool,
    "vorticity_flag": bool,
    "all_flag": bool,
})


class V3dNwarpFuncsOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dNwarpFuncsParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """The output dataset with the computed functions."""


def v_3d_nwarp_funcs_params(
    input_warp: InputPathType,
    output_prefix: str,
    bulk_flag: bool = False,
    shear_flag: bool = False,
    vorticity_flag: bool = False,
    all_flag: bool = False,
) -> V3dNwarpFuncsParametersTagged:
    """
    Build parameters.
    
    Args:
        input_warp: 'www' is the name of the 3D warp dataset (mandatory\
            option).
        output_prefix: 'ppp' is the name of the new output dataset.
        bulk_flag: Compute the (fractional) bulk volume change (Jacobian\
            determinant minus 1).
        shear_flag: Compute the shear energy.
        vorticity_flag: Compute the vorticity energy.
        all_flag: Compute all 3 functions: bulk, shear, and vorticity.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dNwarpFuncs",
        "input_warp": input_warp,
        "output_prefix": output_prefix,
        "bulk_flag": bulk_flag,
        "shear_flag": shear_flag,
        "vorticity_flag": vorticity_flag,
        "all_flag": all_flag,
    }
    return params


def v_3d_nwarp_funcs_cargs(
    params: V3dNwarpFuncsParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dNwarpFuncs")
    cargs.extend([
        "-nwarp",
        execution.input_file(params.get("input_warp", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("output_prefix", None)
    ])
    if params.get("bulk_flag", False):
        cargs.append("-bulk")
    if params.get("shear_flag", False):
        cargs.append("-shear")
    if params.get("vorticity_flag", False):
        cargs.append("-vorticity")
    if params.get("all_flag", False):
        cargs.append("-all")
    return cargs


def v_3d_nwarp_funcs_outputs(
    params: V3dNwarpFuncsParameters,
    execution: Execution,
) -> V3dNwarpFuncsOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dNwarpFuncsOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output_prefix", None) + "_output.nii.gz"),
    )
    return ret


def v_3d_nwarp_funcs_execute(
    params: V3dNwarpFuncsParameters,
    runner: Runner | None = None,
) -> V3dNwarpFuncsOutputs:
    """
    3dNwarpFuncs
    
    Compute functions of 3D warp displacements, such as bulk volume change,
    shear energy, and vorticity energy.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNwarpFuncsOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_NWARP_FUNCS_METADATA)
    params = execution.params(params)
    cargs = v_3d_nwarp_funcs_cargs(params, execution)
    ret = v_3d_nwarp_funcs_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_nwarp_funcs(
    input_warp: InputPathType,
    output_prefix: str,
    bulk_flag: bool = False,
    shear_flag: bool = False,
    vorticity_flag: bool = False,
    all_flag: bool = False,
    runner: Runner | None = None,
) -> V3dNwarpFuncsOutputs:
    """
    3dNwarpFuncs
    
    Compute functions of 3D warp displacements, such as bulk volume change,
    shear energy, and vorticity energy.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_warp: 'www' is the name of the 3D warp dataset (mandatory\
            option).
        output_prefix: 'ppp' is the name of the new output dataset.
        bulk_flag: Compute the (fractional) bulk volume change (Jacobian\
            determinant minus 1).
        shear_flag: Compute the shear energy.
        vorticity_flag: Compute the vorticity energy.
        all_flag: Compute all 3 functions: bulk, shear, and vorticity.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNwarpFuncsOutputs`).
    """
    params = v_3d_nwarp_funcs_params(
        input_warp=input_warp,
        output_prefix=output_prefix,
        bulk_flag=bulk_flag,
        shear_flag=shear_flag,
        vorticity_flag=vorticity_flag,
        all_flag=all_flag,
    )
    return v_3d_nwarp_funcs_execute(params, runner)


__all__ = [
    "V3dNwarpFuncsOutputs",
    "V_3D_NWARP_FUNCS_METADATA",
    "v_3d_nwarp_funcs",
    "v_3d_nwarp_funcs_execute",
    "v_3d_nwarp_funcs_params",
]
