# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_NWARP_XYZ_METADATA = Metadata(
    id="b3e50bef18db95c8d2cd2dc41d63b8a7d7da7351.boutiques",
    name="3dNwarpXYZ",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dNwarpXyzParameters = typing.TypedDict('V3dNwarpXyzParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dNwarpXYZ"]],
    "xyzfile": InputPathType,
    "warp_spec": str,
    "iwarp": bool,
    "output_file": str,
})
V3dNwarpXyzParametersTagged = typing.TypedDict('V3dNwarpXyzParametersTagged', {
    "@type": typing.Literal["afni/3dNwarpXYZ"],
    "xyzfile": InputPathType,
    "warp_spec": str,
    "iwarp": bool,
    "output_file": str,
})


class V3dNwarpXyzOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dNwarpXyzParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Warped XYZ coordinates output file"""


def v_3d_nwarp_xyz_params(
    xyzfile: InputPathType,
    warp_spec: str,
    output_file: str,
    iwarp: bool = False,
) -> V3dNwarpXyzParametersTagged:
    """
    Build parameters.
    
    Args:
        xyzfile: XYZ coordinate file containing 3 columns.
        warp_spec: Warp specification as in 3dNwarpApply.
        output_file: Warped XYZ coordinates output file.
        iwarp: Compute the inverse warp for each input (x,y,z) triple.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dNwarpXYZ",
        "xyzfile": xyzfile,
        "warp_spec": warp_spec,
        "iwarp": iwarp,
        "output_file": output_file,
    }
    return params


def v_3d_nwarp_xyz_cargs(
    params: V3dNwarpXyzParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dNwarpXYZ")
    cargs.append(execution.input_file(params.get("xyzfile", None)))
    cargs.extend([
        "-nwarp",
        params.get("warp_spec", None)
    ])
    if params.get("iwarp", False):
        cargs.append("-iwarp")
    cargs.append("> " + params.get("output_file", None))
    return cargs


def v_3d_nwarp_xyz_outputs(
    params: V3dNwarpXyzParameters,
    execution: Execution,
) -> V3dNwarpXyzOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dNwarpXyzOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output_file", None)),
    )
    return ret


def v_3d_nwarp_xyz_execute(
    params: V3dNwarpXyzParameters,
    runner: Runner | None = None,
) -> V3dNwarpXyzOutputs:
    """
    3dNwarpXYZ
    
    Transforms the DICOM xyz coordinates in the input XYZfile.1D based on
    specified warp.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNwarpXyzOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_NWARP_XYZ_METADATA)
    params = execution.params(params)
    cargs = v_3d_nwarp_xyz_cargs(params, execution)
    ret = v_3d_nwarp_xyz_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_nwarp_xyz(
    xyzfile: InputPathType,
    warp_spec: str,
    output_file: str,
    iwarp: bool = False,
    runner: Runner | None = None,
) -> V3dNwarpXyzOutputs:
    """
    3dNwarpXYZ
    
    Transforms the DICOM xyz coordinates in the input XYZfile.1D based on
    specified warp.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        xyzfile: XYZ coordinate file containing 3 columns.
        warp_spec: Warp specification as in 3dNwarpApply.
        output_file: Warped XYZ coordinates output file.
        iwarp: Compute the inverse warp for each input (x,y,z) triple.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dNwarpXyzOutputs`).
    """
    params = v_3d_nwarp_xyz_params(
        xyzfile=xyzfile,
        warp_spec=warp_spec,
        iwarp=iwarp,
        output_file=output_file,
    )
    return v_3d_nwarp_xyz_execute(params, runner)


__all__ = [
    "V3dNwarpXyzOutputs",
    "V_3D_NWARP_XYZ_METADATA",
    "v_3d_nwarp_xyz",
    "v_3d_nwarp_xyz_execute",
    "v_3d_nwarp_xyz_params",
]
