# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_OVERLAP_METADATA = Metadata(
    id="ad1c98bd4c72aa7f30bc88ed21611a0807942438.boutiques",
    name="3dOverlap",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dOverlapParameters = typing.TypedDict('V3dOverlapParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dOverlap"]],
    "dataset1": InputPathType,
    "dataset2": list[InputPathType],
    "save_prefix": typing.NotRequired[str | None],
})
V3dOverlapParametersTagged = typing.TypedDict('V3dOverlapParametersTagged', {
    "@type": typing.Literal["afni/3dOverlap"],
    "dataset1": InputPathType,
    "dataset2": list[InputPathType],
    "save_prefix": typing.NotRequired[str | None],
})


class V3dOverlapOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dOverlapParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_brik: OutputPathType | None
    """BRIK file with count of overlaps at each voxel (if -save is used)"""
    output_head: OutputPathType | None
    """HEAD file with count of overlaps at each voxel (if -save is used)"""


def v_3d_overlap_params(
    dataset1: InputPathType,
    dataset2: list[InputPathType],
    save_prefix: str | None = None,
) -> V3dOverlapParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset1: First input dataset (e.g. dset1+orig).
        dataset2: Second input dataset (e.g. dset2+orig).
        save_prefix: Save the count of overlaps at each voxel into a dataset\
            with the given prefix.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dOverlap",
        "dataset1": dataset1,
        "dataset2": dataset2,
    }
    if save_prefix is not None:
        params["save_prefix"] = save_prefix
    return params


def v_3d_overlap_cargs(
    params: V3dOverlapParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dOverlap")
    cargs.append(execution.input_file(params.get("dataset1", None)))
    cargs.extend([execution.input_file(f) for f in params.get("dataset2", None)])
    if params.get("save_prefix", None) is not None:
        cargs.extend([
            "-save",
            params.get("save_prefix", None)
        ])
    return cargs


def v_3d_overlap_outputs(
    params: V3dOverlapParameters,
    execution: Execution,
) -> V3dOverlapOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dOverlapOutputs(
        root=execution.output_file("."),
        output_brik=execution.output_file(params.get("save_prefix", None) + "+orig.BRIK") if (params.get("save_prefix") is not None) else None,
        output_head=execution.output_file(params.get("save_prefix", None) + "+orig.HEAD") if (params.get("save_prefix") is not None) else None,
    )
    return ret


def v_3d_overlap_execute(
    params: V3dOverlapParameters,
    runner: Runner | None = None,
) -> V3dOverlapOutputs:
    """
    3dOverlap
    
    Counts the number of voxels that are nonzero in all input datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dOverlapOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_OVERLAP_METADATA)
    params = execution.params(params)
    cargs = v_3d_overlap_cargs(params, execution)
    ret = v_3d_overlap_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_overlap(
    dataset1: InputPathType,
    dataset2: list[InputPathType],
    save_prefix: str | None = None,
    runner: Runner | None = None,
) -> V3dOverlapOutputs:
    """
    3dOverlap
    
    Counts the number of voxels that are nonzero in all input datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset1: First input dataset (e.g. dset1+orig).
        dataset2: Second input dataset (e.g. dset2+orig).
        save_prefix: Save the count of overlaps at each voxel into a dataset\
            with the given prefix.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dOverlapOutputs`).
    """
    params = v_3d_overlap_params(
        dataset1=dataset1,
        dataset2=dataset2,
        save_prefix=save_prefix,
    )
    return v_3d_overlap_execute(params, runner)


__all__ = [
    "V3dOverlapOutputs",
    "V_3D_OVERLAP_METADATA",
    "v_3d_overlap",
    "v_3d_overlap_execute",
    "v_3d_overlap_params",
]
