# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_PAR2_AFNI_PL_METADATA = Metadata(
    id="c8cf3333bffe3eef06c654ed6247416c719f0d74.boutiques",
    name="3dPAR2AFNI.pl",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dPar2AfniPlParameters = typing.TypedDict('V3dPar2AfniPlParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dPAR2AFNI.pl"]],
    "input_file": InputPathType,
    "skip_outliers_test": bool,
    "output_nifti": bool,
    "output_analyze": bool,
    "output_dir": typing.NotRequired[str | None],
    "verbose_flag": bool,
    "gzip_files": bool,
    "byte_swap_2": bool,
    "byte_swap_4": bool,
    "help_flag": bool,
})
V3dPar2AfniPlParametersTagged = typing.TypedDict('V3dPar2AfniPlParametersTagged', {
    "@type": typing.Literal["afni/3dPAR2AFNI.pl"],
    "input_file": InputPathType,
    "skip_outliers_test": bool,
    "output_nifti": bool,
    "output_analyze": bool,
    "output_dir": typing.NotRequired[str | None],
    "verbose_flag": bool,
    "gzip_files": bool,
    "byte_swap_2": bool,
    "byte_swap_4": bool,
    "help_flag": bool,
})


class V3dPar2AfniPlOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dPar2AfniPlParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_files: OutputPathType
    """Converted output files"""


def v_3d_par2_afni_pl_params(
    input_file: InputPathType,
    skip_outliers_test: bool = False,
    output_nifti: bool = False,
    output_analyze: bool = False,
    output_dir: str | None = None,
    verbose_flag: bool = False,
    gzip_files: bool = False,
    byte_swap_2: bool = False,
    byte_swap_4: bool = False,
    help_flag: bool = False,
) -> V3dPar2AfniPlParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Input PAR file (e.g., subject1.PAR).
        skip_outliers_test: Skip the outliers test when converting 4D files.\
            The default is to perform the outliers test.
        output_nifti: Output NIfTI files instead of HEAD/BRIK. The default is\
            to create HEAD/BRIK files.
        output_analyze: Output ANALYZE files instead of HEAD/BRIK.
        output_dir: The name of the directory where the created files should be\
            placed. If this directory does not exist, the program exits without\
            performing any conversion.
        verbose_flag: Be verbose in operation.
        gzip_files: Gzip the files created. The default is not to gzip the\
            files.
        byte_swap_2: 2-Byte-swap the files created. The default is not to 2\
            byte-swap.
        byte_swap_4: 4-Byte-swap the files created. The default is not to 4\
            byte-swap.
        help_flag: Display help message.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dPAR2AFNI.pl",
        "input_file": input_file,
        "skip_outliers_test": skip_outliers_test,
        "output_nifti": output_nifti,
        "output_analyze": output_analyze,
        "verbose_flag": verbose_flag,
        "gzip_files": gzip_files,
        "byte_swap_2": byte_swap_2,
        "byte_swap_4": byte_swap_4,
        "help_flag": help_flag,
    }
    if output_dir is not None:
        params["output_dir"] = output_dir
    return params


def v_3d_par2_afni_pl_cargs(
    params: V3dPar2AfniPlParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dPAR2AFNI.pl")
    cargs.append(execution.input_file(params.get("input_file", None)))
    if params.get("skip_outliers_test", False):
        cargs.append("-s")
    if params.get("output_nifti", False):
        cargs.append("-n")
    if params.get("output_analyze", False):
        cargs.append("-a")
    if params.get("output_dir", None) is not None:
        cargs.extend([
            "-o",
            params.get("output_dir", None)
        ])
    if params.get("verbose_flag", False):
        cargs.append("-v")
    if params.get("gzip_files", False):
        cargs.append("-g")
    if params.get("byte_swap_2", False):
        cargs.append("-2")
    if params.get("byte_swap_4", False):
        cargs.append("-4")
    if params.get("help_flag", False):
        cargs.append("-h")
    return cargs


def v_3d_par2_afni_pl_outputs(
    params: V3dPar2AfniPlParameters,
    execution: Execution,
) -> V3dPar2AfniPlOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dPar2AfniPlOutputs(
        root=execution.output_file("."),
        output_files=execution.output_file(pathlib.Path(params.get("input_file", None)).name + "_converted"),
    )
    return ret


def v_3d_par2_afni_pl_execute(
    params: V3dPar2AfniPlParameters,
    runner: Runner | None = None,
) -> V3dPar2AfniPlOutputs:
    """
    3dPAR2AFNI.pl
    
    Convert Philips PAR/REC files to AFNI's BRIK/HEAD, NIfTI, or ANALYZE format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dPar2AfniPlOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_PAR2_AFNI_PL_METADATA)
    params = execution.params(params)
    cargs = v_3d_par2_afni_pl_cargs(params, execution)
    ret = v_3d_par2_afni_pl_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_par2_afni_pl(
    input_file: InputPathType,
    skip_outliers_test: bool = False,
    output_nifti: bool = False,
    output_analyze: bool = False,
    output_dir: str | None = None,
    verbose_flag: bool = False,
    gzip_files: bool = False,
    byte_swap_2: bool = False,
    byte_swap_4: bool = False,
    help_flag: bool = False,
    runner: Runner | None = None,
) -> V3dPar2AfniPlOutputs:
    """
    3dPAR2AFNI.pl
    
    Convert Philips PAR/REC files to AFNI's BRIK/HEAD, NIfTI, or ANALYZE format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Input PAR file (e.g., subject1.PAR).
        skip_outliers_test: Skip the outliers test when converting 4D files.\
            The default is to perform the outliers test.
        output_nifti: Output NIfTI files instead of HEAD/BRIK. The default is\
            to create HEAD/BRIK files.
        output_analyze: Output ANALYZE files instead of HEAD/BRIK.
        output_dir: The name of the directory where the created files should be\
            placed. If this directory does not exist, the program exits without\
            performing any conversion.
        verbose_flag: Be verbose in operation.
        gzip_files: Gzip the files created. The default is not to gzip the\
            files.
        byte_swap_2: 2-Byte-swap the files created. The default is not to 2\
            byte-swap.
        byte_swap_4: 4-Byte-swap the files created. The default is not to 4\
            byte-swap.
        help_flag: Display help message.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dPar2AfniPlOutputs`).
    """
    params = v_3d_par2_afni_pl_params(
        input_file=input_file,
        skip_outliers_test=skip_outliers_test,
        output_nifti=output_nifti,
        output_analyze=output_analyze,
        output_dir=output_dir,
        verbose_flag=verbose_flag,
        gzip_files=gzip_files,
        byte_swap_2=byte_swap_2,
        byte_swap_4=byte_swap_4,
        help_flag=help_flag,
    )
    return v_3d_par2_afni_pl_execute(params, runner)


__all__ = [
    "V3dPar2AfniPlOutputs",
    "V_3D_PAR2_AFNI_PL_METADATA",
    "v_3d_par2_afni_pl",
    "v_3d_par2_afni_pl_execute",
    "v_3d_par2_afni_pl_params",
]
