# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_PERIODOGRAM_METADATA = Metadata(
    id="93dde3ca0345979135760163670cbc2ca38a4193.boutiques",
    name="3dPeriodogram",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dPeriodogramParameters = typing.TypedDict('V3dPeriodogramParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dPeriodogram"]],
    "prefix": typing.NotRequired[str | None],
    "taper": typing.NotRequired[float | None],
    "nfft": typing.NotRequired[float | None],
    "dataset": InputPathType,
})
V3dPeriodogramParametersTagged = typing.TypedDict('V3dPeriodogramParametersTagged', {
    "@type": typing.Literal["afni/3dPeriodogram"],
    "prefix": typing.NotRequired[str | None],
    "taper": typing.NotRequired[float | None],
    "nfft": typing.NotRequired[float | None],
    "dataset": InputPathType,
})


class V3dPeriodogramOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dPeriodogramParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_header: OutputPathType | None
    """Output dataset header file"""
    output_brick: OutputPathType | None
    """Output dataset brick file"""


def v_3d_periodogram_params(
    dataset: InputPathType,
    prefix: str | None = None,
    taper: float | None = None,
    nfft: float | None = None,
) -> V3dPeriodogramParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset.
        prefix: Prefix for the output dataset.
        taper: Fraction of data to taper.
        nfft: Set FFT length to a specific number of points.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dPeriodogram",
        "dataset": dataset,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if taper is not None:
        params["taper"] = taper
    if nfft is not None:
        params["nfft"] = nfft
    return params


def v_3d_periodogram_cargs(
    params: V3dPeriodogramParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dPeriodogram")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("taper", None) is not None:
        cargs.extend([
            "-taper",
            str(params.get("taper", None))
        ])
    if params.get("nfft", None) is not None:
        cargs.extend([
            "-nfft",
            str(params.get("nfft", None))
        ])
    cargs.append(execution.input_file(params.get("dataset", None)))
    return cargs


def v_3d_periodogram_outputs(
    params: V3dPeriodogramParameters,
    execution: Execution,
) -> V3dPeriodogramOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dPeriodogramOutputs(
        root=execution.output_file("."),
        output_header=execution.output_file(params.get("prefix", None) + ".HEAD") if (params.get("prefix") is not None) else None,
        output_brick=execution.output_file(params.get("prefix", None) + ".BRIK") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_periodogram_execute(
    params: V3dPeriodogramParameters,
    runner: Runner | None = None,
) -> V3dPeriodogramOutputs:
    """
    3dPeriodogram
    
    Computes the periodogram of each voxel time series. The periodogram is a
    crude estimate of the power spectrum.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dPeriodogramOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_PERIODOGRAM_METADATA)
    params = execution.params(params)
    cargs = v_3d_periodogram_cargs(params, execution)
    ret = v_3d_periodogram_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_periodogram(
    dataset: InputPathType,
    prefix: str | None = None,
    taper: float | None = None,
    nfft: float | None = None,
    runner: Runner | None = None,
) -> V3dPeriodogramOutputs:
    """
    3dPeriodogram
    
    Computes the periodogram of each voxel time series. The periodogram is a
    crude estimate of the power spectrum.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset.
        prefix: Prefix for the output dataset.
        taper: Fraction of data to taper.
        nfft: Set FFT length to a specific number of points.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dPeriodogramOutputs`).
    """
    params = v_3d_periodogram_params(
        prefix=prefix,
        taper=taper,
        nfft=nfft,
        dataset=dataset,
    )
    return v_3d_periodogram_execute(params, runner)


__all__ = [
    "V3dPeriodogramOutputs",
    "V_3D_PERIODOGRAM_METADATA",
    "v_3d_periodogram",
    "v_3d_periodogram_execute",
    "v_3d_periodogram_params",
]
