# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_PFM_METADATA = Metadata(
    id="b71b9519322ff10a9267702a56f4f728f16c0bac.boutiques",
    name="3dPFM",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dPfmParameters = typing.TypedDict('V3dPfmParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dPFM"]],
    "input": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "algorithm": typing.NotRequired[str | None],
    "criteria": typing.NotRequired[str | None],
    "nonzeros": typing.NotRequired[float | None],
    "maxiter": typing.NotRequired[float | None],
    "maxiterfactor": typing.NotRequired[float | None],
    "tr": typing.NotRequired[float | None],
    "hrf": typing.NotRequired[str | None],
    "hrf_vol": typing.NotRequired[InputPathType | None],
    "idx_hrf": typing.NotRequired[InputPathType | None],
    "LHS": typing.NotRequired[list[InputPathType] | None],
    "jobs": typing.NotRequired[float | None],
    "nSeg": typing.NotRequired[float | None],
    "verb": typing.NotRequired[float | None],
})
V3dPfmParametersTagged = typing.TypedDict('V3dPfmParametersTagged', {
    "@type": typing.Literal["afni/3dPFM"],
    "input": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "algorithm": typing.NotRequired[str | None],
    "criteria": typing.NotRequired[str | None],
    "nonzeros": typing.NotRequired[float | None],
    "maxiter": typing.NotRequired[float | None],
    "maxiterfactor": typing.NotRequired[float | None],
    "tr": typing.NotRequired[float | None],
    "hrf": typing.NotRequired[str | None],
    "hrf_vol": typing.NotRequired[InputPathType | None],
    "idx_hrf": typing.NotRequired[InputPathType | None],
    "LHS": typing.NotRequired[list[InputPathType] | None],
    "jobs": typing.NotRequired[float | None],
    "nSeg": typing.NotRequired[float | None],
    "verb": typing.NotRequired[float | None],
})


class V3dPfmOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dPfmParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    beta: OutputPathType
    """Prefix for the neuronal-related (i.e. deconvolved) time series."""
    betafitts: OutputPathType
    """Prefix of the convolved neuronal-related time series."""
    fitts: OutputPathType
    """Prefix for the fitted time series."""
    resid: OutputPathType
    """Prefix for the residuals of the fit to the data."""
    mean: OutputPathType
    """Prefix for the intercept of the model."""
    lhsest: OutputPathType
    """Prefix for the estimates of the LHS parameters."""
    lhsfitts: OutputPathType
    """Prefix for the fitted time series of the LHS parameters."""
    lambda_: OutputPathType
    """Prefix for output volume with the regularization parameter of the
    deconvolution of each voxel."""
    costs: OutputPathType
    """Prefix for output volume of the cost function used to select the
    regularization parameter according to the selected criteria."""
    tstats_beta: OutputPathType
    """Prefix for the T-statistics of beta at each time point."""
    tdf_beta: OutputPathType
    """Prefix for degrees of freedom of the T-statistics of beta."""
    z_tstats_beta: OutputPathType
    """Prefix for (normalized) z-scores of the T-statistics of beta."""
    fstats_beta: OutputPathType
    """Prefix for the F-statistics of the deconvolved component."""
    fdf_beta: OutputPathType
    """Prefix for degrees of freedom of Fstats_beta."""
    z_fstats_beta: OutputPathType
    """Prefix for (normalized) z-scores of the Fstats_beta."""
    tstats_lhs: OutputPathType
    """Prefix for T-statistics of LHS regressors at each time point."""
    tdf_lhs: OutputPathType
    """Prefix for degrees of freedom of the Tstats_LHS."""
    z_tstats_lhs: OutputPathType
    """Prefix for (normalized) z-scores of the Tstats_LHS."""
    fstats_lhs: OutputPathType
    """Prefix for the F-statistics of the LHS regressors."""
    fdf_lhs: OutputPathType
    """Prefix for degrees of freedom of Fstats_LHS."""
    z_fstats_lhs: OutputPathType
    """Prefix for (normalized) z-scores of Fstats_LHS."""
    fstats_full: OutputPathType
    """Prefix for the F-statistics of the full model."""
    fdf_full: OutputPathType
    """Prefix for degrees of freedom of Fstats_full."""
    z_fstats_full: OutputPathType
    """Prefix for (normalized) z-scores of Fstats_full."""
    r2_full: OutputPathType
    """Prefix for R² (coefficient of determination) of the full model."""
    r2adj_full: OutputPathType
    """Prefix for Adjusted R² coefficient for the full model."""


def v_3d_pfm_params(
    input_: InputPathType,
    mask: InputPathType | None = None,
    algorithm: str | None = None,
    criteria: str | None = None,
    nonzeros: float | None = None,
    maxiter: float | None = None,
    maxiterfactor: float | None = None,
    tr: float | None = None,
    hrf: str | None = None,
    hrf_vol: InputPathType | None = None,
    idx_hrf: InputPathType | None = None,
    lhs: list[InputPathType] | None = None,
    jobs: float | None = None,
    n_seg: float | None = None,
    verb: float | None = None,
) -> V3dPfmParametersTagged:
    """
    Build parameters.
    
    Args:
        input_: Specify the dataset to analyze (e.g., epi.nii).
        mask: Process voxels inside this mask only. Default is no masking.
        algorithm: Regularization function used for HRF deconvolution (dantzig\
            or lasso).
        criteria: Model selection criterion for HRF deconvolution (BIC or AIC).
        nonzeros: Choose estimate with a fixed number of nonzero coefficients.
        maxiter: Maximum number of iterations in the homotopy procedure\
            (absolute value).
        maxiterfactor: Maximum number of iterations relative to the number of\
            volumes.
        tr: Repetition time or sampling period of the input data.
        hrf: Haemodynamic response function used for deconvolution.
        hrf_vol: 3D+time dataset with voxel/nodes/vertex -dependent HRFs.
        idx_hrf: 3D dataset with voxel-dependent indexes for HRF.
        lhs: Additional regressors to be fitted to the dataset.
        jobs: Number of parallel jobs to use in processing.
        n_seg: Divide into segments to report progress.
        verb: Verbosity level (0 for quiet, 1 for talkative).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dPFM",
        "input": input_,
    }
    if mask is not None:
        params["mask"] = mask
    if algorithm is not None:
        params["algorithm"] = algorithm
    if criteria is not None:
        params["criteria"] = criteria
    if nonzeros is not None:
        params["nonzeros"] = nonzeros
    if maxiter is not None:
        params["maxiter"] = maxiter
    if maxiterfactor is not None:
        params["maxiterfactor"] = maxiterfactor
    if tr is not None:
        params["tr"] = tr
    if hrf is not None:
        params["hrf"] = hrf
    if hrf_vol is not None:
        params["hrf_vol"] = hrf_vol
    if idx_hrf is not None:
        params["idx_hrf"] = idx_hrf
    if lhs is not None:
        params["LHS"] = lhs
    if jobs is not None:
        params["jobs"] = jobs
    if n_seg is not None:
        params["nSeg"] = n_seg
    if verb is not None:
        params["verb"] = verb
    return params


def v_3d_pfm_cargs(
    params: V3dPfmParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dPFM")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input", None))
    ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("algorithm", None) is not None:
        cargs.extend([
            "-algorithm",
            params.get("algorithm", None)
        ])
    if params.get("criteria", None) is not None:
        cargs.extend([
            "-criteria",
            params.get("criteria", None)
        ])
    if params.get("nonzeros", None) is not None:
        cargs.extend([
            "-nonzeros",
            str(params.get("nonzeros", None))
        ])
    if params.get("maxiter", None) is not None:
        cargs.extend([
            "-maxiter",
            str(params.get("maxiter", None))
        ])
    if params.get("maxiterfactor", None) is not None:
        cargs.extend([
            "-maxiterfactor",
            str(params.get("maxiterfactor", None))
        ])
    if params.get("tr", None) is not None:
        cargs.extend([
            "-TR",
            str(params.get("tr", None))
        ])
    if params.get("hrf", None) is not None:
        cargs.extend([
            "-hrf",
            params.get("hrf", None)
        ])
    if params.get("hrf_vol", None) is not None:
        cargs.extend([
            "-hrf_vol",
            execution.input_file(params.get("hrf_vol", None))
        ])
    if params.get("idx_hrf", None) is not None:
        cargs.extend([
            "-idx_hrf",
            execution.input_file(params.get("idx_hrf", None))
        ])
    if params.get("LHS", None) is not None:
        cargs.extend([
            "-LHS",
            *[execution.input_file(f) for f in params.get("LHS", None)]
        ])
    if params.get("jobs", None) is not None:
        cargs.extend([
            "-jobs",
            str(params.get("jobs", None))
        ])
    if params.get("nSeg", None) is not None:
        cargs.extend([
            "-nSeg",
            str(params.get("nSeg", None))
        ])
    if params.get("verb", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verb", None))
        ])
    return cargs


def v_3d_pfm_outputs(
    params: V3dPfmParameters,
    execution: Execution,
) -> V3dPfmOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dPfmOutputs(
        root=execution.output_file("."),
        beta=execution.output_file("[BETA]"),
        betafitts=execution.output_file("[BETAFITTS]"),
        fitts=execution.output_file("[FITTS]"),
        resid=execution.output_file("[RESID]"),
        mean=execution.output_file("[MEAN]"),
        lhsest=execution.output_file("[LHSEST]"),
        lhsfitts=execution.output_file("[LHSFITTS]"),
        lambda_=execution.output_file("[LAMBDA]"),
        costs=execution.output_file("[COSTS]"),
        tstats_beta=execution.output_file("[TSTATS_BETA]"),
        tdf_beta=execution.output_file("[TDF_BETA]"),
        z_tstats_beta=execution.output_file("[Z_TSTATS_BETA]"),
        fstats_beta=execution.output_file("[FSTATS_BETA]"),
        fdf_beta=execution.output_file("[FDF_BETA]"),
        z_fstats_beta=execution.output_file("[Z_FSTATS_BETA]"),
        tstats_lhs=execution.output_file("[TSTATS_LHS]"),
        tdf_lhs=execution.output_file("[TDF_LHS]"),
        z_tstats_lhs=execution.output_file("[Z_TSTATS_LHS]"),
        fstats_lhs=execution.output_file("[FSTATS_LHS]"),
        fdf_lhs=execution.output_file("[FDF_LHS]"),
        z_fstats_lhs=execution.output_file("[Z_FSTATS_LHS]"),
        fstats_full=execution.output_file("[FSTATS_FULL]"),
        fdf_full=execution.output_file("[FDF_FULL]"),
        z_fstats_full=execution.output_file("[Z_FSTATS_FULL]"),
        r2_full=execution.output_file("[R2_FULL]"),
        r2adj_full=execution.output_file("[R2ADJ_FULL]"),
    )
    return ret


def v_3d_pfm_execute(
    params: V3dPfmParameters,
    runner: Runner | None = None,
) -> V3dPfmOutputs:
    """
    3dPFM
    
    Program for identifying brief BOLD events in fMRI time series using Paradigm
    Free Mapping.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dPfmOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_PFM_METADATA)
    params = execution.params(params)
    cargs = v_3d_pfm_cargs(params, execution)
    ret = v_3d_pfm_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_pfm(
    input_: InputPathType,
    mask: InputPathType | None = None,
    algorithm: str | None = None,
    criteria: str | None = None,
    nonzeros: float | None = None,
    maxiter: float | None = None,
    maxiterfactor: float | None = None,
    tr: float | None = None,
    hrf: str | None = None,
    hrf_vol: InputPathType | None = None,
    idx_hrf: InputPathType | None = None,
    lhs: list[InputPathType] | None = None,
    jobs: float | None = None,
    n_seg: float | None = None,
    verb: float | None = None,
    runner: Runner | None = None,
) -> V3dPfmOutputs:
    """
    3dPFM
    
    Program for identifying brief BOLD events in fMRI time series using Paradigm
    Free Mapping.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_: Specify the dataset to analyze (e.g., epi.nii).
        mask: Process voxels inside this mask only. Default is no masking.
        algorithm: Regularization function used for HRF deconvolution (dantzig\
            or lasso).
        criteria: Model selection criterion for HRF deconvolution (BIC or AIC).
        nonzeros: Choose estimate with a fixed number of nonzero coefficients.
        maxiter: Maximum number of iterations in the homotopy procedure\
            (absolute value).
        maxiterfactor: Maximum number of iterations relative to the number of\
            volumes.
        tr: Repetition time or sampling period of the input data.
        hrf: Haemodynamic response function used for deconvolution.
        hrf_vol: 3D+time dataset with voxel/nodes/vertex -dependent HRFs.
        idx_hrf: 3D dataset with voxel-dependent indexes for HRF.
        lhs: Additional regressors to be fitted to the dataset.
        jobs: Number of parallel jobs to use in processing.
        n_seg: Divide into segments to report progress.
        verb: Verbosity level (0 for quiet, 1 for talkative).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dPfmOutputs`).
    """
    params = v_3d_pfm_params(
        input_=input_,
        mask=mask,
        algorithm=algorithm,
        criteria=criteria,
        nonzeros=nonzeros,
        maxiter=maxiter,
        maxiterfactor=maxiterfactor,
        tr=tr,
        hrf=hrf,
        hrf_vol=hrf_vol,
        idx_hrf=idx_hrf,
        lhs=lhs,
        jobs=jobs,
        n_seg=n_seg,
        verb=verb,
    )
    return v_3d_pfm_execute(params, runner)


__all__ = [
    "V3dPfmOutputs",
    "V_3D_PFM_METADATA",
    "v_3d_pfm",
    "v_3d_pfm_execute",
    "v_3d_pfm_params",
]
