# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_PVAL_METADATA = Metadata(
    id="9479f35d3dad112060e6205271ed4c0ae7fe30e3.boutiques",
    name="3dPval",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dPvalParameters = typing.TypedDict('V3dPvalParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dPval"]],
    "input_dataset": InputPathType,
    "zscore": bool,
    "log2": bool,
    "log10": bool,
    "qval": bool,
    "prefix": typing.NotRequired[str | None],
})
V3dPvalParametersTagged = typing.TypedDict('V3dPvalParametersTagged', {
    "@type": typing.Literal["afni/3dPval"],
    "input_dataset": InputPathType,
    "zscore": bool,
    "log2": bool,
    "log10": bool,
    "qval": bool,
    "prefix": typing.NotRequired[str | None],
})


class V3dPvalOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dPvalParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType | None
    """Output dataset with converted statistical values. Default output filename
    is 'Pval.nii.gz'."""


def v_3d_pval_params(
    input_dataset: InputPathType,
    zscore: bool = False,
    log2: bool = False,
    log10: bool = False,
    qval: bool = False,
    prefix: str | None = None,
) -> V3dPvalParametersTagged:
    """
    Build parameters.
    
    Args:
        input_dataset: Input dataset (e.g., InputDataset.nii).
        zscore: Convert statistic to a z-score instead, an N(0,1) deviate that\
            represents the same p-value.
        log2: Convert statistic to -log2(p).
        log10: Convert statistic to -log10(p).
        qval: Convert statistic to a q-value (FDR) instead. This option only\
            works with datasets that have FDR curves inserted in their headers.
        prefix: Prefix name for output file (default name is 'Pval').
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dPval",
        "input_dataset": input_dataset,
        "zscore": zscore,
        "log2": log2,
        "log10": log10,
        "qval": qval,
    }
    if prefix is not None:
        params["prefix"] = prefix
    return params


def v_3d_pval_cargs(
    params: V3dPvalParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dPval")
    cargs.append(execution.input_file(params.get("input_dataset", None)))
    if params.get("zscore", False):
        cargs.append("-zscore")
    if params.get("log2", False):
        cargs.append("-log2")
    if params.get("log10", False):
        cargs.append("-log10")
    if params.get("qval", False):
        cargs.append("-qval")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    return cargs


def v_3d_pval_outputs(
    params: V3dPvalParameters,
    execution: Execution,
) -> V3dPvalOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dPvalOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix", None) + ".nii.gz") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_pval_execute(
    params: V3dPvalParameters,
    runner: Runner | None = None,
) -> V3dPvalOutputs:
    """
    3dPval
    
    Convert a dataset's statistical sub-bricks to p-values or other statistical
    representations.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dPvalOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_PVAL_METADATA)
    params = execution.params(params)
    cargs = v_3d_pval_cargs(params, execution)
    ret = v_3d_pval_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_pval(
    input_dataset: InputPathType,
    zscore: bool = False,
    log2: bool = False,
    log10: bool = False,
    qval: bool = False,
    prefix: str | None = None,
    runner: Runner | None = None,
) -> V3dPvalOutputs:
    """
    3dPval
    
    Convert a dataset's statistical sub-bricks to p-values or other statistical
    representations.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Input dataset (e.g., InputDataset.nii).
        zscore: Convert statistic to a z-score instead, an N(0,1) deviate that\
            represents the same p-value.
        log2: Convert statistic to -log2(p).
        log10: Convert statistic to -log10(p).
        qval: Convert statistic to a q-value (FDR) instead. This option only\
            works with datasets that have FDR curves inserted in their headers.
        prefix: Prefix name for output file (default name is 'Pval').
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dPvalOutputs`).
    """
    params = v_3d_pval_params(
        input_dataset=input_dataset,
        zscore=zscore,
        log2=log2,
        log10=log10,
        qval=qval,
        prefix=prefix,
    )
    return v_3d_pval_execute(params, runner)


__all__ = [
    "V3dPvalOutputs",
    "V_3D_PVAL_METADATA",
    "v_3d_pval",
    "v_3d_pval_execute",
    "v_3d_pval_params",
]
