# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_PVMAP_METADATA = Metadata(
    id="f988d7429cad2c301278f66bcd355958109df768.boutiques",
    name="3dPVmap",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dPvmapParameters = typing.TypedDict('V3dPvmapParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dPVmap"]],
    "prefix": typing.NotRequired[str | None],
    "mask": typing.NotRequired[InputPathType | None],
    "automask": bool,
    "inputdataset": InputPathType,
})
V3dPvmapParametersTagged = typing.TypedDict('V3dPvmapParametersTagged', {
    "@type": typing.Literal["afni/3dPVmap"],
    "prefix": typing.NotRequired[str | None],
    "mask": typing.NotRequired[InputPathType | None],
    "automask": bool,
    "inputdataset": InputPathType,
})


class V3dPvmapOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dPvmapParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outbrik: OutputPathType | None
    """Output PVmap file"""
    outhead: OutputPathType | None
    """Output PVmap header file"""
    pc_vectors: OutputPathType | None
    """Principal component time series vectors"""


def v_3d_pvmap_params(
    inputdataset: InputPathType,
    prefix: str | None = None,
    mask: InputPathType | None = None,
    automask: bool = False,
) -> V3dPvmapParametersTagged:
    """
    Build parameters.
    
    Args:
        inputdataset: Input dataset (e.g., fred.nii).
        prefix: Output prefix for generated files.
        mask: Mask dataset (e.g., brainmask.nii).
        automask: Automatically generate a mask from the input dataset.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dPVmap",
        "automask": automask,
        "inputdataset": inputdataset,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if mask is not None:
        params["mask"] = mask
    return params


def v_3d_pvmap_cargs(
    params: V3dPvmapParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dPVmap")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("automask", False):
        cargs.append("-automask")
    cargs.append(execution.input_file(params.get("inputdataset", None)))
    return cargs


def v_3d_pvmap_outputs(
    params: V3dPvmapParameters,
    execution: Execution,
) -> V3dPvmapOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dPvmapOutputs(
        root=execution.output_file("."),
        outbrik=execution.output_file(params.get("prefix", None) + "+orig.BRIK") if (params.get("prefix") is not None) else None,
        outhead=execution.output_file(params.get("prefix", None) + "+orig.HEAD") if (params.get("prefix") is not None) else None,
        pc_vectors=execution.output_file(params.get("prefix", None) + ".1D") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_pvmap_execute(
    params: V3dPvmapParameters,
    runner: Runner | None = None,
) -> V3dPvmapOutputs:
    """
    3dPVmap
    
    Computes the first two principal component vectors of a time series dataset,
    then outputs the R-squared coefficient of each voxel time series with these
    first two components.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dPvmapOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_PVMAP_METADATA)
    params = execution.params(params)
    cargs = v_3d_pvmap_cargs(params, execution)
    ret = v_3d_pvmap_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_pvmap(
    inputdataset: InputPathType,
    prefix: str | None = None,
    mask: InputPathType | None = None,
    automask: bool = False,
    runner: Runner | None = None,
) -> V3dPvmapOutputs:
    """
    3dPVmap
    
    Computes the first two principal component vectors of a time series dataset,
    then outputs the R-squared coefficient of each voxel time series with these
    first two components.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        inputdataset: Input dataset (e.g., fred.nii).
        prefix: Output prefix for generated files.
        mask: Mask dataset (e.g., brainmask.nii).
        automask: Automatically generate a mask from the input dataset.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dPvmapOutputs`).
    """
    params = v_3d_pvmap_params(
        prefix=prefix,
        mask=mask,
        automask=automask,
        inputdataset=inputdataset,
    )
    return v_3d_pvmap_execute(params, runner)


__all__ = [
    "V3dPvmapOutputs",
    "V_3D_PVMAP_METADATA",
    "v_3d_pvmap",
    "v_3d_pvmap_execute",
    "v_3d_pvmap_params",
]
