# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_RANKIZER_METADATA = Metadata(
    id="d17c4c35340ecaaf4825b74baad438e208b71e64.boutiques",
    name="3dRankizer",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dRankizerParameters = typing.TypedDict('V3dRankizerParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dRankizer"]],
    "dataset": InputPathType,
    "base_rank": typing.NotRequired[float | None],
    "mask": typing.NotRequired[InputPathType | None],
    "prefix": str,
    "percentize": bool,
    "percentize_mask": bool,
})
V3dRankizerParametersTagged = typing.TypedDict('V3dRankizerParametersTagged', {
    "@type": typing.Literal["afni/3dRankizer"],
    "dataset": InputPathType,
    "base_rank": typing.NotRequired[float | None],
    "mask": typing.NotRequired[InputPathType | None],
    "prefix": str,
    "percentize": bool,
    "percentize_mask": bool,
})


class V3dRankizerOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dRankizerParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType
    """Output float-format dataset containing ranked voxel values"""


def v_3d_rankizer_params(
    dataset: InputPathType,
    prefix: str,
    base_rank: float | None = None,
    mask: InputPathType | None = None,
    percentize: bool = False,
    percentize_mask: bool = False,
) -> V3dRankizerParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: Input MRI dataset.
        prefix: Write results into float-format output dataset.
        base_rank: Set the 'base' rank instead of 1.
        mask: Use the specified dataset as a mask. Only voxels with nonzero\
            values in this mask will be used from the input dataset. Voxels outside\
            the mask will get rank 0.
        percentize: Divide rank by the number of voxels in the dataset and\
            multiply by 100.0.
        percentize_mask: Divide rank by the number of voxels in the mask and\
            multiply by 100.0.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dRankizer",
        "dataset": dataset,
        "prefix": prefix,
        "percentize": percentize,
        "percentize_mask": percentize_mask,
    }
    if base_rank is not None:
        params["base_rank"] = base_rank
    if mask is not None:
        params["mask"] = mask
    return params


def v_3d_rankizer_cargs(
    params: V3dRankizerParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dRankizer")
    cargs.append(execution.input_file(params.get("dataset", None)))
    if params.get("base_rank", None) is not None:
        cargs.extend([
            "-brank",
            str(params.get("base_rank", None))
        ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("percentize", False):
        cargs.append("-percentize")
    if params.get("percentize_mask", False):
        cargs.append("-percentize_mask")
    return cargs


def v_3d_rankizer_outputs(
    params: V3dRankizerParameters,
    execution: Execution,
) -> V3dRankizerOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dRankizerOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file(params.get("prefix", None) + "+tlrc.HEAD"),
    )
    return ret


def v_3d_rankizer_execute(
    params: V3dRankizerParameters,
    runner: Runner | None = None,
) -> V3dRankizerOutputs:
    """
    3dRankizer
    
    Tool to rank each voxel as sorted into increasing value. Ties get the
    average rank.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dRankizerOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_RANKIZER_METADATA)
    params = execution.params(params)
    cargs = v_3d_rankizer_cargs(params, execution)
    ret = v_3d_rankizer_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_rankizer(
    dataset: InputPathType,
    prefix: str,
    base_rank: float | None = None,
    mask: InputPathType | None = None,
    percentize: bool = False,
    percentize_mask: bool = False,
    runner: Runner | None = None,
) -> V3dRankizerOutputs:
    """
    3dRankizer
    
    Tool to rank each voxel as sorted into increasing value. Ties get the
    average rank.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input MRI dataset.
        prefix: Write results into float-format output dataset.
        base_rank: Set the 'base' rank instead of 1.
        mask: Use the specified dataset as a mask. Only voxels with nonzero\
            values in this mask will be used from the input dataset. Voxels outside\
            the mask will get rank 0.
        percentize: Divide rank by the number of voxels in the dataset and\
            multiply by 100.0.
        percentize_mask: Divide rank by the number of voxels in the mask and\
            multiply by 100.0.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dRankizerOutputs`).
    """
    params = v_3d_rankizer_params(
        dataset=dataset,
        base_rank=base_rank,
        mask=mask,
        prefix=prefix,
        percentize=percentize,
        percentize_mask=percentize_mask,
    )
    return v_3d_rankizer_execute(params, runner)


__all__ = [
    "V3dRankizerOutputs",
    "V_3D_RANKIZER_METADATA",
    "v_3d_rankizer",
    "v_3d_rankizer_execute",
    "v_3d_rankizer_params",
]
