# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_REMLFIT_METADATA = Metadata(
    id="036315e0f46a70dcc3f52e76a3cbd09391a7e811.boutiques",
    name="3dREMLfit",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dRemlfitParameters = typing.TypedDict('V3dRemlfitParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dREMLfit"]],
    "input_file": InputPathType,
    "regression_matrix": InputPathType,
    "baseline_files": typing.NotRequired[list[str] | None],
    "sort_nods": bool,
    "temp_storage": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "output_prefix": typing.NotRequired[str | None],
    "no_fdr_curve": bool,
    "go_for_it": bool,
    "max_a_param": typing.NotRequired[float | None],
    "max_b_param": typing.NotRequired[float | None],
    "grid_param": typing.NotRequired[float | None],
    "negative_corr": bool,
    "quiet": bool,
    "verbose": bool,
})
V3dRemlfitParametersTagged = typing.TypedDict('V3dRemlfitParametersTagged', {
    "@type": typing.Literal["afni/3dREMLfit"],
    "input_file": InputPathType,
    "regression_matrix": InputPathType,
    "baseline_files": typing.NotRequired[list[str] | None],
    "sort_nods": bool,
    "temp_storage": bool,
    "mask": typing.NotRequired[InputPathType | None],
    "output_prefix": typing.NotRequired[str | None],
    "no_fdr_curve": bool,
    "go_for_it": bool,
    "max_a_param": typing.NotRequired[float | None],
    "max_b_param": typing.NotRequired[float | None],
    "grid_param": typing.NotRequired[float | None],
    "negative_corr": bool,
    "quiet": bool,
    "verbose": bool,
})


class V3dRemlfitOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dRemlfitParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile: OutputPathType | None
    """Main default output of 3dREMLfit"""
    rvar_file: OutputPathType | None
    """REML variance parameters"""
    rbeta_file: OutputPathType | None
    """REML beta weights"""
    rbuck_file: OutputPathType | None
    """REML estimates and statistics"""
    rfitts_file: OutputPathType | None
    """REML fitted model"""
    rerrts_file: OutputPathType | None
    """REML residuals"""


def v_3d_remlfit_params(
    input_file: InputPathType,
    regression_matrix: InputPathType,
    baseline_files: list[str] | None = None,
    sort_nods: bool = False,
    temp_storage: bool = False,
    mask: InputPathType | None = None,
    output_prefix: str | None = None,
    no_fdr_curve: bool = False,
    go_for_it: bool = False,
    max_a_param: float | None = None,
    max_b_param: float | None = None,
    grid_param: float | None = None,
    negative_corr: bool = False,
    quiet: bool = False,
    verbose: bool = False,
) -> V3dRemlfitParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Read time series dataset.
        regression_matrix: Read the regression matrix, which should have been\
            output from 3dDeconvolve via the '-x1D' option.
        baseline_files: Add baseline model columns to the matrix. Each column\
            in the specified .1D file will be appended to the matrix.
        sort_nods: If '-dsort' is used, the output datasets reflect the impact\
            of the voxel-wise regressor(s). If you want to compare those results to\
            the case where you did NOT give the '-dsort' option, then also use\
            '-dsort_nods'.
        temp_storage: Write intermediate output to disk, to economize on RAM.
        mask: Read dataset as a mask for the input; voxels outside the mask\
            will not be fit by the regression model.
        output_prefix: Dataset prefix for saving REML variance parameters.
        no_fdr_curve: Do not add FDR curve data to bucket datasets.
        go_for_it: Force the program to continue past a failed collinearity\
            check.
        max_a_param: Set max allowed AR a parameter.
        max_b_param: Set max allowed MA b parameter.
        grid_param: Set the number of grid divisions in the (a,b) grid.
        negative_corr: Allows negative correlations to be used.
        quiet: Turn off most progress messages.
        verbose: Turn on more progress messages.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dREMLfit",
        "input_file": input_file,
        "regression_matrix": regression_matrix,
        "sort_nods": sort_nods,
        "temp_storage": temp_storage,
        "no_fdr_curve": no_fdr_curve,
        "go_for_it": go_for_it,
        "negative_corr": negative_corr,
        "quiet": quiet,
        "verbose": verbose,
    }
    if baseline_files is not None:
        params["baseline_files"] = baseline_files
    if mask is not None:
        params["mask"] = mask
    if output_prefix is not None:
        params["output_prefix"] = output_prefix
    if max_a_param is not None:
        params["max_a_param"] = max_a_param
    if max_b_param is not None:
        params["max_b_param"] = max_b_param
    if grid_param is not None:
        params["grid_param"] = grid_param
    return params


def v_3d_remlfit_cargs(
    params: V3dRemlfitParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dREMLfit")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file", None))
    ])
    cargs.extend([
        "-matrix",
        execution.input_file(params.get("regression_matrix", None))
    ])
    if params.get("baseline_files", None) is not None:
        cargs.extend([
            "-addbase",
            *params.get("baseline_files", None)
        ])
    if params.get("sort_nods", False):
        cargs.append("-dsort_nods")
    if params.get("temp_storage", False):
        cargs.append("-usetemp")
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("output_prefix", None) is not None:
        cargs.extend([
            "-Rvar",
            params.get("output_prefix", None)
        ])
    if params.get("no_fdr_curve", False):
        cargs.append("-noFDR")
    if params.get("go_for_it", False):
        cargs.append("-GOFORIT")
    if params.get("max_a_param", None) is not None:
        cargs.extend([
            "-MAXa",
            str(params.get("max_a_param", None))
        ])
    if params.get("max_b_param", None) is not None:
        cargs.extend([
            "-MAXb",
            str(params.get("max_b_param", None))
        ])
    if params.get("grid_param", None) is not None:
        cargs.extend([
            "-Grid",
            str(params.get("grid_param", None))
        ])
    if params.get("negative_corr", False):
        cargs.append("-NEGcor")
    if params.get("quiet", False):
        cargs.append("quiet")
    if params.get("verbose", False):
        cargs.append("-verb")
    return cargs


def v_3d_remlfit_outputs(
    params: V3dRemlfitParameters,
    execution: Execution,
) -> V3dRemlfitOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dRemlfitOutputs(
        root=execution.output_file("."),
        outfile=execution.output_file(params.get("output_prefix", None) + ".nii.gz") if (params.get("output_prefix") is not None) else None,
        rvar_file=execution.output_file(params.get("output_prefix", None) + "_Rvar.nii.gz") if (params.get("output_prefix") is not None) else None,
        rbeta_file=execution.output_file(params.get("output_prefix", None) + "_Rbeta.nii.gz") if (params.get("output_prefix") is not None) else None,
        rbuck_file=execution.output_file(params.get("output_prefix", None) + "_Rbuck.nii.gz") if (params.get("output_prefix") is not None) else None,
        rfitts_file=execution.output_file(params.get("output_prefix", None) + "_Rfitts.nii.gz") if (params.get("output_prefix") is not None) else None,
        rerrts_file=execution.output_file(params.get("output_prefix", None) + "_Rerrts.nii.gz") if (params.get("output_prefix") is not None) else None,
    )
    return ret


def v_3d_remlfit_execute(
    params: V3dRemlfitParameters,
    runner: Runner | None = None,
) -> V3dRemlfitOutputs:
    """
    3dREMLfit
    
    Generalized least squares time series fit, with REML estimation of the
    temporal auto-correlation structure.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dRemlfitOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_REMLFIT_METADATA)
    params = execution.params(params)
    cargs = v_3d_remlfit_cargs(params, execution)
    ret = v_3d_remlfit_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_remlfit(
    input_file: InputPathType,
    regression_matrix: InputPathType,
    baseline_files: list[str] | None = None,
    sort_nods: bool = False,
    temp_storage: bool = False,
    mask: InputPathType | None = None,
    output_prefix: str | None = None,
    no_fdr_curve: bool = False,
    go_for_it: bool = False,
    max_a_param: float | None = None,
    max_b_param: float | None = None,
    grid_param: float | None = None,
    negative_corr: bool = False,
    quiet: bool = False,
    verbose: bool = False,
    runner: Runner | None = None,
) -> V3dRemlfitOutputs:
    """
    3dREMLfit
    
    Generalized least squares time series fit, with REML estimation of the
    temporal auto-correlation structure.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Read time series dataset.
        regression_matrix: Read the regression matrix, which should have been\
            output from 3dDeconvolve via the '-x1D' option.
        baseline_files: Add baseline model columns to the matrix. Each column\
            in the specified .1D file will be appended to the matrix.
        sort_nods: If '-dsort' is used, the output datasets reflect the impact\
            of the voxel-wise regressor(s). If you want to compare those results to\
            the case where you did NOT give the '-dsort' option, then also use\
            '-dsort_nods'.
        temp_storage: Write intermediate output to disk, to economize on RAM.
        mask: Read dataset as a mask for the input; voxels outside the mask\
            will not be fit by the regression model.
        output_prefix: Dataset prefix for saving REML variance parameters.
        no_fdr_curve: Do not add FDR curve data to bucket datasets.
        go_for_it: Force the program to continue past a failed collinearity\
            check.
        max_a_param: Set max allowed AR a parameter.
        max_b_param: Set max allowed MA b parameter.
        grid_param: Set the number of grid divisions in the (a,b) grid.
        negative_corr: Allows negative correlations to be used.
        quiet: Turn off most progress messages.
        verbose: Turn on more progress messages.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dRemlfitOutputs`).
    """
    params = v_3d_remlfit_params(
        input_file=input_file,
        regression_matrix=regression_matrix,
        baseline_files=baseline_files,
        sort_nods=sort_nods,
        temp_storage=temp_storage,
        mask=mask,
        output_prefix=output_prefix,
        no_fdr_curve=no_fdr_curve,
        go_for_it=go_for_it,
        max_a_param=max_a_param,
        max_b_param=max_b_param,
        grid_param=grid_param,
        negative_corr=negative_corr,
        quiet=quiet,
        verbose=verbose,
    )
    return v_3d_remlfit_execute(params, runner)


__all__ = [
    "V3dRemlfitOutputs",
    "V_3D_REMLFIT_METADATA",
    "v_3d_remlfit",
    "v_3d_remlfit_execute",
    "v_3d_remlfit_params",
]
