# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_ROIMAKER_METADATA = Metadata(
    id="69620c1a87f0694cec0d446d98ee3d79ce4d24a9.boutiques",
    name="3dROIMaker",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dRoimakerParameters = typing.TypedDict('V3dRoimakerParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dROIMaker"]],
    "inset": InputPathType,
    "thresh": float,
    "prefix": str,
    "refset": typing.NotRequired[InputPathType | None],
    "volthr": typing.NotRequired[float | None],
    "only_some_top": typing.NotRequired[float | None],
    "only_conn_top": typing.NotRequired[float | None],
    "inflate": typing.NotRequired[float | None],
    "trim_off_wm": bool,
    "wm_skel": typing.NotRequired[InputPathType | None],
    "skel_thr": typing.NotRequired[float | None],
    "skel_stop": bool,
    "skel_stop_strict": bool,
    "csf_skel": typing.NotRequired[InputPathType | None],
    "mask": typing.NotRequired[InputPathType | None],
    "neigh_upto_vert": bool,
    "nifti": bool,
    "preinfl_inset": typing.NotRequired[InputPathType | None],
    "preinfl_inflate": typing.NotRequired[float | None],
    "dump_no_labtab": bool,
})
V3dRoimakerParametersTagged = typing.TypedDict('V3dRoimakerParametersTagged', {
    "@type": typing.Literal["afni/3dROIMaker"],
    "inset": InputPathType,
    "thresh": float,
    "prefix": str,
    "refset": typing.NotRequired[InputPathType | None],
    "volthr": typing.NotRequired[float | None],
    "only_some_top": typing.NotRequired[float | None],
    "only_conn_top": typing.NotRequired[float | None],
    "inflate": typing.NotRequired[float | None],
    "trim_off_wm": bool,
    "wm_skel": typing.NotRequired[InputPathType | None],
    "skel_thr": typing.NotRequired[float | None],
    "skel_stop": bool,
    "skel_stop_strict": bool,
    "csf_skel": typing.NotRequired[InputPathType | None],
    "mask": typing.NotRequired[InputPathType | None],
    "neigh_upto_vert": bool,
    "nifti": bool,
    "preinfl_inset": typing.NotRequired[InputPathType | None],
    "preinfl_inflate": typing.NotRequired[float | None],
    "dump_no_labtab": bool,
})


class V3dRoimakerOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dRoimakerParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    gm_map: OutputPathType
    """GM map of ROIs based on value- and volume-thresholding, corresponding to
    gray matter regions of activation."""
    gmi_map: OutputPathType
    """Map of inflated GM ROIs based on GM map, with ROIs inflated either by
    user-design or WM skeleton."""


def v_3d_roimaker_params(
    inset: InputPathType,
    thresh: float,
    prefix: str,
    refset: InputPathType | None = None,
    volthr: float | None = None,
    only_some_top: float | None = None,
    only_conn_top: float | None = None,
    inflate: float | None = None,
    trim_off_wm: bool = False,
    wm_skel: InputPathType | None = None,
    skel_thr: float | None = None,
    skel_stop: bool = False,
    skel_stop_strict: bool = False,
    csf_skel: InputPathType | None = None,
    mask: InputPathType | None = None,
    neigh_upto_vert: bool = False,
    nifti: bool = False,
    preinfl_inset: InputPathType | None = None,
    preinfl_inflate: float | None = None,
    dump_no_labtab: bool = False,
) -> V3dRoimakerParametersTagged:
    """
    Build parameters.
    
    Args:
        inset: 3D volume(s) of values, especially functionally-derived\
            quantities like correlation values or ICA Z-scores.
        thresh: Threshold for values in INSET, used to create ROI islands from\
            the 3D volume's sea of values.
        prefix: Prefix of output name, with output files being: PREFIX_GM* and\
            PREFIX_GMI*.
        refset: 3D (or multi-subbrick) volume containing integer values with\
            which to label specific GM ROIs after thresholding.
        volthr: Minimum size a cluster of voxels must have in order to remain a\
            GM ROI after thresholding. Can reduce 'noisy' clusters.
        only_some_top: Restrict each found region to keep only N voxels with\
            the highest inset values.
        only_conn_top: Select N max contiguous voxels in a region starting from\
            peak voxel and expanding.
        inflate: Number of voxels to pad each found ROI in order to turn GM\
            ROIs into inflated (GMI) ROIs.
        trim_off_wm: Trim the INSET to exclude voxels in WM by excluding those\
            which overlap an input WM skeleton.
        wm_skel: 3D volume containing info of WM, as might be defined from an\
            FA map or anatomical segmentation.
        skel_thr: Threshold value for WM skeleton if it is not a mask.
        skel_stop: Stop inflation at locations which are already on WM\
            skeleton.
        skel_stop_strict: Do not allow any inflation into the skel-region.
        csf_skel: 3D volume containing info of CSF. Info must be a binary mask\
            already.
        mask: Mask within which to apply threshold. Useful if the MINTHR is a\
            negative value.
        neigh_upto_vert: Define neighbors loosely so that voxels can be grouped\
            into the same ROI if they share at least one vertex.
        nifti: Switch to output *.nii.gz GM and GMI files.
        preinfl_inset: Start with a WM ROI, inflate it to find the nearest GM,\
            then expand that GM and subtract away the WM+CSF parts.
        preinfl_inflate: Number of voxels for initial inflation of PSET.
        dump_no_labtab: Switch for turning off labeltable attachment to the\
            output GM and GMI files.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dROIMaker",
        "inset": inset,
        "thresh": thresh,
        "prefix": prefix,
        "trim_off_wm": trim_off_wm,
        "skel_stop": skel_stop,
        "skel_stop_strict": skel_stop_strict,
        "neigh_upto_vert": neigh_upto_vert,
        "nifti": nifti,
        "dump_no_labtab": dump_no_labtab,
    }
    if refset is not None:
        params["refset"] = refset
    if volthr is not None:
        params["volthr"] = volthr
    if only_some_top is not None:
        params["only_some_top"] = only_some_top
    if only_conn_top is not None:
        params["only_conn_top"] = only_conn_top
    if inflate is not None:
        params["inflate"] = inflate
    if wm_skel is not None:
        params["wm_skel"] = wm_skel
    if skel_thr is not None:
        params["skel_thr"] = skel_thr
    if csf_skel is not None:
        params["csf_skel"] = csf_skel
    if mask is not None:
        params["mask"] = mask
    if preinfl_inset is not None:
        params["preinfl_inset"] = preinfl_inset
    if preinfl_inflate is not None:
        params["preinfl_inflate"] = preinfl_inflate
    return params


def v_3d_roimaker_cargs(
    params: V3dRoimakerParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dROIMaker")
    cargs.append(execution.input_file(params.get("inset", None)))
    cargs.extend([
        "-thresh",
        str(params.get("thresh", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("refset", None) is not None:
        cargs.extend([
            "-refset",
            execution.input_file(params.get("refset", None))
        ])
    if params.get("volthr", None) is not None:
        cargs.extend([
            "-volthr",
            str(params.get("volthr", None))
        ])
    if params.get("only_some_top", None) is not None:
        cargs.extend([
            "-only_some_top",
            str(params.get("only_some_top", None))
        ])
    if params.get("only_conn_top", None) is not None:
        cargs.extend([
            "-only_conn_top",
            str(params.get("only_conn_top", None))
        ])
    if params.get("inflate", None) is not None:
        cargs.extend([
            "-inflate",
            str(params.get("inflate", None))
        ])
    if params.get("trim_off_wm", False):
        cargs.append("-trim_off_wm")
    if params.get("wm_skel", None) is not None:
        cargs.extend([
            "-wm_skel",
            execution.input_file(params.get("wm_skel", None))
        ])
    if params.get("skel_thr", None) is not None:
        cargs.extend([
            "-skel_thr",
            str(params.get("skel_thr", None))
        ])
    if params.get("skel_stop", False):
        cargs.append("-skel_stop")
    if params.get("skel_stop_strict", False):
        cargs.append("-skel_stop_strict")
    if params.get("csf_skel", None) is not None:
        cargs.extend([
            "-csf_skel",
            execution.input_file(params.get("csf_skel", None))
        ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("neigh_upto_vert", False):
        cargs.append("-neigh_upto_vert")
    if params.get("nifti", False):
        cargs.append("-nifti")
    if params.get("preinfl_inset", None) is not None:
        cargs.extend([
            "-preinfl_inset",
            execution.input_file(params.get("preinfl_inset", None))
        ])
    if params.get("preinfl_inflate", None) is not None:
        cargs.extend([
            "-preinfl_inflate",
            str(params.get("preinfl_inflate", None))
        ])
    if params.get("dump_no_labtab", False):
        cargs.append("-dump_no_labtab")
    return cargs


def v_3d_roimaker_outputs(
    params: V3dRoimakerParameters,
    execution: Execution,
) -> V3dRoimakerOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dRoimakerOutputs(
        root=execution.output_file("."),
        gm_map=execution.output_file(params.get("prefix", None) + "_GM+orig.HEAD"),
        gmi_map=execution.output_file(params.get("prefix", None) + "_GMI+orig.HEAD"),
    )
    return ret


def v_3d_roimaker_execute(
    params: V3dRoimakerParameters,
    runner: Runner | None = None,
) -> V3dRoimakerOutputs:
    """
    3dROIMaker
    
    Create a labelled set of ROIs from input data, useful in combining
    functional and tractographic/structural data.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dRoimakerOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_ROIMAKER_METADATA)
    params = execution.params(params)
    cargs = v_3d_roimaker_cargs(params, execution)
    ret = v_3d_roimaker_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_roimaker(
    inset: InputPathType,
    thresh: float,
    prefix: str,
    refset: InputPathType | None = None,
    volthr: float | None = None,
    only_some_top: float | None = None,
    only_conn_top: float | None = None,
    inflate: float | None = None,
    trim_off_wm: bool = False,
    wm_skel: InputPathType | None = None,
    skel_thr: float | None = None,
    skel_stop: bool = False,
    skel_stop_strict: bool = False,
    csf_skel: InputPathType | None = None,
    mask: InputPathType | None = None,
    neigh_upto_vert: bool = False,
    nifti: bool = False,
    preinfl_inset: InputPathType | None = None,
    preinfl_inflate: float | None = None,
    dump_no_labtab: bool = False,
    runner: Runner | None = None,
) -> V3dRoimakerOutputs:
    """
    3dROIMaker
    
    Create a labelled set of ROIs from input data, useful in combining
    functional and tractographic/structural data.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        inset: 3D volume(s) of values, especially functionally-derived\
            quantities like correlation values or ICA Z-scores.
        thresh: Threshold for values in INSET, used to create ROI islands from\
            the 3D volume's sea of values.
        prefix: Prefix of output name, with output files being: PREFIX_GM* and\
            PREFIX_GMI*.
        refset: 3D (or multi-subbrick) volume containing integer values with\
            which to label specific GM ROIs after thresholding.
        volthr: Minimum size a cluster of voxels must have in order to remain a\
            GM ROI after thresholding. Can reduce 'noisy' clusters.
        only_some_top: Restrict each found region to keep only N voxels with\
            the highest inset values.
        only_conn_top: Select N max contiguous voxels in a region starting from\
            peak voxel and expanding.
        inflate: Number of voxels to pad each found ROI in order to turn GM\
            ROIs into inflated (GMI) ROIs.
        trim_off_wm: Trim the INSET to exclude voxels in WM by excluding those\
            which overlap an input WM skeleton.
        wm_skel: 3D volume containing info of WM, as might be defined from an\
            FA map or anatomical segmentation.
        skel_thr: Threshold value for WM skeleton if it is not a mask.
        skel_stop: Stop inflation at locations which are already on WM\
            skeleton.
        skel_stop_strict: Do not allow any inflation into the skel-region.
        csf_skel: 3D volume containing info of CSF. Info must be a binary mask\
            already.
        mask: Mask within which to apply threshold. Useful if the MINTHR is a\
            negative value.
        neigh_upto_vert: Define neighbors loosely so that voxels can be grouped\
            into the same ROI if they share at least one vertex.
        nifti: Switch to output *.nii.gz GM and GMI files.
        preinfl_inset: Start with a WM ROI, inflate it to find the nearest GM,\
            then expand that GM and subtract away the WM+CSF parts.
        preinfl_inflate: Number of voxels for initial inflation of PSET.
        dump_no_labtab: Switch for turning off labeltable attachment to the\
            output GM and GMI files.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dRoimakerOutputs`).
    """
    params = v_3d_roimaker_params(
        inset=inset,
        thresh=thresh,
        prefix=prefix,
        refset=refset,
        volthr=volthr,
        only_some_top=only_some_top,
        only_conn_top=only_conn_top,
        inflate=inflate,
        trim_off_wm=trim_off_wm,
        wm_skel=wm_skel,
        skel_thr=skel_thr,
        skel_stop=skel_stop,
        skel_stop_strict=skel_stop_strict,
        csf_skel=csf_skel,
        mask=mask,
        neigh_upto_vert=neigh_upto_vert,
        nifti=nifti,
        preinfl_inset=preinfl_inset,
        preinfl_inflate=preinfl_inflate,
        dump_no_labtab=dump_no_labtab,
    )
    return v_3d_roimaker_execute(params, runner)


__all__ = [
    "V3dRoimakerOutputs",
    "V_3D_ROIMAKER_METADATA",
    "v_3d_roimaker",
    "v_3d_roimaker_execute",
    "v_3d_roimaker_params",
]
