# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_RPROG_DEMO_METADATA = Metadata(
    id="ec4899bd50fc86fb3f445d32de40142f3e9600ce.boutiques",
    name="3dRprogDemo",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dRprogDemoParameters = typing.TypedDict('V3dRprogDemoParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dRprogDemo"]],
    "input_dsets": list[InputPathType],
    "mask": typing.NotRequired[InputPathType | None],
    "scale": float,
    "prefix": str,
    "help_aspx": bool,
    "help_raw": bool,
    "help_spx": bool,
    "help_txt": bool,
    "help": bool,
    "show_allowed_options": bool,
    "verbosity_level": typing.NotRequired[float | None],
})
V3dRprogDemoParametersTagged = typing.TypedDict('V3dRprogDemoParametersTagged', {
    "@type": typing.Literal["afni/3dRprogDemo"],
    "input_dsets": list[InputPathType],
    "mask": typing.NotRequired[InputPathType | None],
    "scale": float,
    "prefix": str,
    "help_aspx": bool,
    "help_raw": bool,
    "help_spx": bool,
    "help_txt": bool,
    "help": bool,
    "show_allowed_options": bool,
    "verbosity_level": typing.NotRequired[float | None],
})


class V3dRprogDemoOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dRprogDemoParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Output file with the specified prefix."""


def v_3d_rprog_demo_params(
    input_dsets: list[InputPathType],
    scale: float,
    prefix: str,
    mask: InputPathType | None = None,
    help_aspx: bool = False,
    help_raw: bool = False,
    help_spx: bool = False,
    help_txt: bool = False,
    help_: bool = False,
    show_allowed_options: bool = False,
    verbosity_level: float | None = None,
) -> V3dRprogDemoParametersTagged:
    """
    Build parameters.
    
    Args:
        input_dsets: Input dataset(s) to be scaled.
        scale: Multiply each voxel by SS.
        prefix: Output prefix (just prefix, no view+suffix needed).
        mask: Process voxels inside this mask only. Default is no masking.
        help_aspx: Display help message with autolabeling.
        help_raw: Display raw help message as in the code.
        help_spx: Display help message in sphinx format.
        help_txt: Display help message in simple text.
        help_: Display help message in simple text.
        show_allowed_options: List of allowed options.
        verbosity_level: Verbosity level. 0 for quiet (Default). 1 or more:\
            talkative.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dRprogDemo",
        "input_dsets": input_dsets,
        "scale": scale,
        "prefix": prefix,
        "help_aspx": help_aspx,
        "help_raw": help_raw,
        "help_spx": help_spx,
        "help_txt": help_txt,
        "help": help_,
        "show_allowed_options": show_allowed_options,
    }
    if mask is not None:
        params["mask"] = mask
    if verbosity_level is not None:
        params["verbosity_level"] = verbosity_level
    return params


def v_3d_rprog_demo_cargs(
    params: V3dRprogDemoParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dRprogDemo")
    cargs.extend([execution.input_file(f) for f in params.get("input_dsets", None)])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    cargs.extend([
        "-scale",
        str(params.get("scale", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("help_aspx", False):
        cargs.append("-h_aspx")
    if params.get("help_raw", False):
        cargs.append("-h_raw")
    if params.get("help_spx", False):
        cargs.append("-h_spx")
    if params.get("help_txt", False):
        cargs.append("-h_txt")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("show_allowed_options", False):
        cargs.append("-show_allowed_options")
    if params.get("verbosity_level", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbosity_level", None))
        ])
    return cargs


def v_3d_rprog_demo_outputs(
    params: V3dRprogDemoParameters,
    execution: Execution,
) -> V3dRprogDemoOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dRprogDemoOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix", None) + ".nii"),
    )
    return ret


def v_3d_rprog_demo_execute(
    params: V3dRprogDemoParameters,
    runner: Runner | None = None,
) -> V3dRprogDemoOutputs:
    """
    3dRprogDemo
    
    Template program to help users write their own R processing routines on MRI
    volumes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dRprogDemoOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_RPROG_DEMO_METADATA)
    params = execution.params(params)
    cargs = v_3d_rprog_demo_cargs(params, execution)
    ret = v_3d_rprog_demo_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_rprog_demo(
    input_dsets: list[InputPathType],
    scale: float,
    prefix: str,
    mask: InputPathType | None = None,
    help_aspx: bool = False,
    help_raw: bool = False,
    help_spx: bool = False,
    help_txt: bool = False,
    help_: bool = False,
    show_allowed_options: bool = False,
    verbosity_level: float | None = None,
    runner: Runner | None = None,
) -> V3dRprogDemoOutputs:
    """
    3dRprogDemo
    
    Template program to help users write their own R processing routines on MRI
    volumes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dsets: Input dataset(s) to be scaled.
        scale: Multiply each voxel by SS.
        prefix: Output prefix (just prefix, no view+suffix needed).
        mask: Process voxels inside this mask only. Default is no masking.
        help_aspx: Display help message with autolabeling.
        help_raw: Display raw help message as in the code.
        help_spx: Display help message in sphinx format.
        help_txt: Display help message in simple text.
        help_: Display help message in simple text.
        show_allowed_options: List of allowed options.
        verbosity_level: Verbosity level. 0 for quiet (Default). 1 or more:\
            talkative.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dRprogDemoOutputs`).
    """
    params = v_3d_rprog_demo_params(
        input_dsets=input_dsets,
        mask=mask,
        scale=scale,
        prefix=prefix,
        help_aspx=help_aspx,
        help_raw=help_raw,
        help_spx=help_spx,
        help_txt=help_txt,
        help_=help_,
        show_allowed_options=show_allowed_options,
        verbosity_level=verbosity_level,
    )
    return v_3d_rprog_demo_execute(params, runner)


__all__ = [
    "V3dRprogDemoOutputs",
    "V_3D_RPROG_DEMO_METADATA",
    "v_3d_rprog_demo",
    "v_3d_rprog_demo_execute",
    "v_3d_rprog_demo_params",
]
