# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_SIGNATURES_METADATA = Metadata(
    id="62c42f9307b68462703f2e02d462d769ea17d659.boutiques",
    name="3dSignatures",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dSignaturesParameters = typing.TypedDict('V3dSignaturesParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dSignatures"]],
    "infile": InputPathType,
    "outfile": str,
    "segmentation": bool,
    "filter": bool,
    "threshold": typing.NotRequired[float | None],
    "smoothing": typing.NotRequired[float | None],
})
V3dSignaturesParametersTagged = typing.TypedDict('V3dSignaturesParametersTagged', {
    "@type": typing.Literal["afni/3dSignatures"],
    "infile": InputPathType,
    "outfile": str,
    "segmentation": bool,
    "filter": bool,
    "threshold": typing.NotRequired[float | None],
    "smoothing": typing.NotRequired[float | None],
})


class V3dSignaturesOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dSignaturesParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    results_file: OutputPathType
    """Main analysis results file"""


def v_3d_signatures_params(
    infile: InputPathType,
    outfile: str,
    segmentation: bool = False,
    filter_: bool = False,
    threshold: float | None = None,
    smoothing: float | None = None,
) -> V3dSignaturesParametersTagged:
    """
    Build parameters.
    
    Args:
        infile: Input file containing 3D genome data (e.g. genome_data.txt).
        outfile: Output file to store analysis results (e.g.\
            analysis_results.txt).
        segmentation: Flag to apply genome segmentation.
        filter_: Flag to apply data filtering.
        threshold: Threshold level for data filtering; default=0.5.
        smoothing: Apply smoothing with specified kernel size.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dSignatures",
        "infile": infile,
        "outfile": outfile,
        "segmentation": segmentation,
        "filter": filter_,
    }
    if threshold is not None:
        params["threshold"] = threshold
    if smoothing is not None:
        params["smoothing"] = smoothing
    return params


def v_3d_signatures_cargs(
    params: V3dSignaturesParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dSignatures")
    cargs.append(execution.input_file(params.get("infile", None)))
    cargs.append(params.get("outfile", None))
    if params.get("segmentation", False):
        cargs.append("--segmentation")
    if params.get("filter", False):
        cargs.append("--filter")
    if params.get("threshold", None) is not None:
        cargs.extend([
            "--threshold",
            str(params.get("threshold", None))
        ])
    if params.get("smoothing", None) is not None:
        cargs.extend([
            "--smoothing",
            str(params.get("smoothing", None))
        ])
    return cargs


def v_3d_signatures_outputs(
    params: V3dSignaturesParameters,
    execution: Execution,
) -> V3dSignaturesOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dSignaturesOutputs(
        root=execution.output_file("."),
        results_file=execution.output_file(params.get("outfile", None) + ".txt"),
    )
    return ret


def v_3d_signatures_execute(
    params: V3dSignaturesParameters,
    runner: Runner | None = None,
) -> V3dSignaturesOutputs:
    """
    3dSignatures
    
    3dSignatures analysis tool for 3D genome organization.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dSignaturesOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_SIGNATURES_METADATA)
    params = execution.params(params)
    cargs = v_3d_signatures_cargs(params, execution)
    ret = v_3d_signatures_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_signatures(
    infile: InputPathType,
    outfile: str,
    segmentation: bool = False,
    filter_: bool = False,
    threshold: float | None = None,
    smoothing: float | None = None,
    runner: Runner | None = None,
) -> V3dSignaturesOutputs:
    """
    3dSignatures
    
    3dSignatures analysis tool for 3D genome organization.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input file containing 3D genome data (e.g. genome_data.txt).
        outfile: Output file to store analysis results (e.g.\
            analysis_results.txt).
        segmentation: Flag to apply genome segmentation.
        filter_: Flag to apply data filtering.
        threshold: Threshold level for data filtering; default=0.5.
        smoothing: Apply smoothing with specified kernel size.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dSignaturesOutputs`).
    """
    params = v_3d_signatures_params(
        infile=infile,
        outfile=outfile,
        segmentation=segmentation,
        filter_=filter_,
        threshold=threshold,
        smoothing=smoothing,
    )
    return v_3d_signatures_execute(params, runner)


__all__ = [
    "V3dSignaturesOutputs",
    "V_3D_SIGNATURES_METADATA",
    "v_3d_signatures",
    "v_3d_signatures_execute",
    "v_3d_signatures_params",
]
