# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_SKULL_STRIP_METADATA = Metadata(
    id="fbceed0eb269040c8046f3ad034c5816057f27c3.boutiques",
    name="3dSkullStrip",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dSkullStripParameters = typing.TypedDict('V3dSkullStripParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dSkullStrip"]],
    "in_file": InputPathType,
    "num_threads": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
})
V3dSkullStripParametersTagged = typing.TypedDict('V3dSkullStripParametersTagged', {
    "@type": typing.Literal["afni/3dSkullStrip"],
    "in_file": InputPathType,
    "num_threads": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
})


class V3dSkullStripOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dSkullStripParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType
    """Output image file name."""
    out_file_: OutputPathType
    """Output file."""


def v_3d_skull_strip_params(
    in_file: InputPathType,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
) -> V3dSkullStripParametersTagged:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3dskullstrip.
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dSkullStrip",
        "in_file": in_file,
    }
    if num_threads is not None:
        params["num_threads"] = num_threads
    if outputtype is not None:
        params["outputtype"] = outputtype
    return params


def v_3d_skull_strip_cargs(
    params: V3dSkullStripParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dSkullStrip")
    cargs.extend([
        "-input",
        execution.input_file(params.get("in_file", None))
    ])
    if params.get("num_threads", None) is not None:
        cargs.append(str(params.get("num_threads", None)))
    if params.get("outputtype", None) is not None:
        cargs.append(params.get("outputtype", None))
    return cargs


def v_3d_skull_strip_outputs(
    params: V3dSkullStripParameters,
    execution: Execution,
) -> V3dSkullStripOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dSkullStripOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(pathlib.Path(params.get("in_file", None)).name + "_skullstrip"),
        out_file_=execution.output_file("out_file"),
    )
    return ret


def v_3d_skull_strip_execute(
    params: V3dSkullStripParameters,
    runner: Runner | None = None,
) -> V3dSkullStripOutputs:
    """
    3dSkullStrip
    
    A program to extract the brain from surrounding tissue from MRI T1-weighted
    images.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dSkullStripOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_SKULL_STRIP_METADATA)
    params = execution.params(params)
    cargs = v_3d_skull_strip_cargs(params, execution)
    ret = v_3d_skull_strip_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_skull_strip(
    in_file: InputPathType,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    runner: Runner | None = None,
) -> V3dSkullStripOutputs:
    """
    3dSkullStrip
    
    A program to extract the brain from surrounding tissue from MRI T1-weighted
    images.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3dskullstrip.
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dSkullStripOutputs`).
    """
    params = v_3d_skull_strip_params(
        in_file=in_file,
        num_threads=num_threads,
        outputtype=outputtype,
    )
    return v_3d_skull_strip_execute(params, runner)


__all__ = [
    "V3dSkullStripOutputs",
    "V_3D_SKULL_STRIP_METADATA",
    "v_3d_skull_strip",
    "v_3d_skull_strip_execute",
    "v_3d_skull_strip_params",
]
