# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_SLICE_NDICE_METADATA = Metadata(
    id="47faa2b7fa568539489509b1d3737397345c1187.boutiques",
    name="3dSliceNDice",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dSliceNdiceParameters = typing.TypedDict('V3dSliceNdiceParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dSliceNDice"]],
    "infile_a": InputPathType,
    "infile_b": InputPathType,
    "output_prefix": str,
    "out_domain": typing.NotRequired[typing.Literal["all", "AorB", "AandB", "Amask", "Bmask"] | None],
    "no_cmd_echo": bool,
})
V3dSliceNdiceParametersTagged = typing.TypedDict('V3dSliceNdiceParametersTagged', {
    "@type": typing.Literal["afni/3dSliceNDice"],
    "infile_a": InputPathType,
    "infile_b": InputPathType,
    "output_prefix": str,
    "out_domain": typing.NotRequired[typing.Literal["all", "AorB", "AandB", "Amask", "Bmask"] | None],
    "no_cmd_echo": bool,
})


class V3dSliceNdiceOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dSliceNdiceParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_rl: OutputPathType
    """Output file containing Dice coefficients along the right-left axis."""
    output_ap: OutputPathType
    """Output file containing Dice coefficients along the anterior-posterior
    axis."""
    output_is: OutputPathType
    """Output file containing Dice coefficients along the inferior-superior
    axis."""


def v_3d_slice_ndice_params(
    infile_a: InputPathType,
    infile_b: InputPathType,
    output_prefix: str,
    out_domain: typing.Literal["all", "AorB", "AandB", "Amask", "Bmask"] | None = None,
    no_cmd_echo: bool = False,
) -> V3dSliceNdiceParametersTagged:
    """
    Build parameters.
    
    Args:
        infile_a: Input dataset A (e.g. mask_1.nii.gz).
        infile_b: Input dataset B (e.g. mask_2.nii.gz).
        output_prefix: Prefix for output files (e.g. result_prefix).
        out_domain: Specify which slices to include in the Dice coefficient\
            report. Options are: all (default), AorB, AandB, Amask, Bmask.
        no_cmd_echo: Turn OFF recording the command line call in the output\
            *.1D files. Default is to do the recording.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dSliceNDice",
        "infile_a": infile_a,
        "infile_b": infile_b,
        "output_prefix": output_prefix,
        "no_cmd_echo": no_cmd_echo,
    }
    if out_domain is not None:
        params["out_domain"] = out_domain
    return params


def v_3d_slice_ndice_cargs(
    params: V3dSliceNdiceParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dSliceNDice")
    cargs.extend([
        "-insetA",
        execution.input_file(params.get("infile_a", None))
    ])
    cargs.extend([
        "-insetB",
        execution.input_file(params.get("infile_b", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("output_prefix", None)
    ])
    if params.get("out_domain", None) is not None:
        cargs.extend([
            "-out_domain",
            params.get("out_domain", None)
        ])
    if params.get("no_cmd_echo", False):
        cargs.append("-no_cmd_echo")
    return cargs


def v_3d_slice_ndice_outputs(
    params: V3dSliceNdiceParameters,
    execution: Execution,
) -> V3dSliceNdiceOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dSliceNdiceOutputs(
        root=execution.output_file("."),
        output_rl=execution.output_file(params.get("output_prefix", None) + "_0_RL.1D"),
        output_ap=execution.output_file(params.get("output_prefix", None) + "_1_AP.1D"),
        output_is=execution.output_file(params.get("output_prefix", None) + "_2_IS.1D"),
    )
    return ret


def v_3d_slice_ndice_execute(
    params: V3dSliceNdiceParameters,
    runner: Runner | None = None,
) -> V3dSliceNdiceOutputs:
    """
    3dSliceNDice
    
    Calculates the Dice coefficient between two volumes on a slice-by-slice
    basis.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dSliceNdiceOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_SLICE_NDICE_METADATA)
    params = execution.params(params)
    cargs = v_3d_slice_ndice_cargs(params, execution)
    ret = v_3d_slice_ndice_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_slice_ndice(
    infile_a: InputPathType,
    infile_b: InputPathType,
    output_prefix: str,
    out_domain: typing.Literal["all", "AorB", "AandB", "Amask", "Bmask"] | None = None,
    no_cmd_echo: bool = False,
    runner: Runner | None = None,
) -> V3dSliceNdiceOutputs:
    """
    3dSliceNDice
    
    Calculates the Dice coefficient between two volumes on a slice-by-slice
    basis.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile_a: Input dataset A (e.g. mask_1.nii.gz).
        infile_b: Input dataset B (e.g. mask_2.nii.gz).
        output_prefix: Prefix for output files (e.g. result_prefix).
        out_domain: Specify which slices to include in the Dice coefficient\
            report. Options are: all (default), AorB, AandB, Amask, Bmask.
        no_cmd_echo: Turn OFF recording the command line call in the output\
            *.1D files. Default is to do the recording.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dSliceNdiceOutputs`).
    """
    params = v_3d_slice_ndice_params(
        infile_a=infile_a,
        infile_b=infile_b,
        output_prefix=output_prefix,
        out_domain=out_domain,
        no_cmd_echo=no_cmd_echo,
    )
    return v_3d_slice_ndice_execute(params, runner)


__all__ = [
    "V3dSliceNdiceOutputs",
    "V_3D_SLICE_NDICE_METADATA",
    "v_3d_slice_ndice",
    "v_3d_slice_ndice_execute",
    "v_3d_slice_ndice_params",
]
