# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_SURF_MASK_METADATA = Metadata(
    id="0c8c0c85cb938597bc328e04d5ab913c255457c7.boutiques",
    name="3dSurfMask",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dSurfMaskParameters = typing.TypedDict('V3dSurfMaskParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dSurfMask"]],
    "surface_type": str,
    "surface_file": InputPathType,
    "prefix": str,
    "grid_parent": InputPathType,
    "fill_method": typing.NotRequired[str | None],
    "surface_volume": typing.NotRequired[InputPathType | None],
    "mask_only": bool,
    "flip_orientation": bool,
    "no_distance": bool,
})
V3dSurfMaskParametersTagged = typing.TypedDict('V3dSurfMaskParametersTagged', {
    "@type": typing.Literal["afni/3dSurfMask"],
    "surface_type": str,
    "surface_file": InputPathType,
    "prefix": str,
    "grid_parent": InputPathType,
    "fill_method": typing.NotRequired[str | None],
    "surface_volume": typing.NotRequired[InputPathType | None],
    "mask_only": bool,
    "flip_orientation": bool,
    "no_distance": bool,
})


class V3dSurfMaskOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dSurfMaskParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_mask: OutputPathType
    """Main output mask dataset."""
    distance_dataset: OutputPathType
    """Dataset reflecting voxel shortest distances to the surface."""


def v_3d_surf_mask_params(
    surface_type: str,
    surface_file: InputPathType,
    prefix: str,
    grid_parent: InputPathType,
    fill_method: str | None = None,
    surface_volume: InputPathType | None = None,
    mask_only: bool = False,
    flip_orientation: bool = False,
    no_distance: bool = False,
) -> V3dSurfMaskParametersTagged:
    """
    Build parameters.
    
    Args:
        surface_type: Specify input surface.
        surface_file: Specify input surface filename.
        prefix: Prefix of output dataset.
        grid_parent: Specifies the grid for the output volume.
        fill_method: Fill method: SLOW or FAST (default: FAST).
        surface_volume: Specify the surface volume.
        mask_only: Produce an output dataset where voxels are 1 inside the\
            surface and 0 outside.
        flip_orientation: Flip triangle winding of surface mesh.
        no_distance: Do not compute the distances, just the mask from the first\
            step.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dSurfMask",
        "surface_type": surface_type,
        "surface_file": surface_file,
        "prefix": prefix,
        "grid_parent": grid_parent,
        "mask_only": mask_only,
        "flip_orientation": flip_orientation,
        "no_distance": no_distance,
    }
    if fill_method is not None:
        params["fill_method"] = fill_method
    if surface_volume is not None:
        params["surface_volume"] = surface_volume
    return params


def v_3d_surf_mask_cargs(
    params: V3dSurfMaskParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dSurfMask")
    cargs.append(params.get("surface_type", None))
    cargs.append(execution.input_file(params.get("surface_file", None)))
    cargs.append(params.get("prefix", None))
    cargs.append(execution.input_file(params.get("grid_parent", None)))
    if params.get("fill_method", None) is not None:
        cargs.extend([
            "-fill_method",
            params.get("fill_method", None)
        ])
    if params.get("surface_volume", None) is not None:
        cargs.extend([
            "-sv",
            execution.input_file(params.get("surface_volume", None))
        ])
    if params.get("mask_only", False):
        cargs.append("-mask_only")
    if params.get("flip_orientation", False):
        cargs.append("-flip_orientation")
    if params.get("no_distance", False):
        cargs.append("-no_dist")
    return cargs


def v_3d_surf_mask_outputs(
    params: V3dSurfMaskParameters,
    execution: Execution,
) -> V3dSurfMaskOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dSurfMaskOutputs(
        root=execution.output_file("."),
        output_mask=execution.output_file(params.get("prefix", None) + ".m+orig.BRIK"),
        distance_dataset=execution.output_file(params.get("prefix", None) + ".d+orig.BRIK"),
    )
    return ret


def v_3d_surf_mask_execute(
    params: V3dSurfMaskParameters,
    runner: Runner | None = None,
) -> V3dSurfMaskOutputs:
    """
    3dSurfMask
    
    Creates volumetric datasets marking voxels based on their location relative
    to a surface.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dSurfMaskOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_SURF_MASK_METADATA)
    params = execution.params(params)
    cargs = v_3d_surf_mask_cargs(params, execution)
    ret = v_3d_surf_mask_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_surf_mask(
    surface_type: str,
    surface_file: InputPathType,
    prefix: str,
    grid_parent: InputPathType,
    fill_method: str | None = None,
    surface_volume: InputPathType | None = None,
    mask_only: bool = False,
    flip_orientation: bool = False,
    no_distance: bool = False,
    runner: Runner | None = None,
) -> V3dSurfMaskOutputs:
    """
    3dSurfMask
    
    Creates volumetric datasets marking voxels based on their location relative
    to a surface.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        surface_type: Specify input surface.
        surface_file: Specify input surface filename.
        prefix: Prefix of output dataset.
        grid_parent: Specifies the grid for the output volume.
        fill_method: Fill method: SLOW or FAST (default: FAST).
        surface_volume: Specify the surface volume.
        mask_only: Produce an output dataset where voxels are 1 inside the\
            surface and 0 outside.
        flip_orientation: Flip triangle winding of surface mesh.
        no_distance: Do not compute the distances, just the mask from the first\
            step.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dSurfMaskOutputs`).
    """
    params = v_3d_surf_mask_params(
        surface_type=surface_type,
        surface_file=surface_file,
        prefix=prefix,
        grid_parent=grid_parent,
        fill_method=fill_method,
        surface_volume=surface_volume,
        mask_only=mask_only,
        flip_orientation=flip_orientation,
        no_distance=no_distance,
    )
    return v_3d_surf_mask_execute(params, runner)


__all__ = [
    "V3dSurfMaskOutputs",
    "V_3D_SURF_MASK_METADATA",
    "v_3d_surf_mask",
    "v_3d_surf_mask_execute",
    "v_3d_surf_mask_params",
]
