# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_TCORRELATE_METADATA = Metadata(
    id="a3ab8a0beffb40435bf40983a8b4de8e9d88e384.boutiques",
    name="3dTcorrelate",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dTcorrelateParameters = typing.TypedDict('V3dTcorrelateParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dTcorrelate"]],
    "xset": InputPathType,
    "yset": InputPathType,
    "pearson": bool,
    "spearman": bool,
    "quadrant": bool,
    "ktaub": bool,
    "covariance": bool,
    "partial": typing.NotRequired[InputPathType | None],
    "ycoef": bool,
    "fisher": bool,
    "polort": typing.NotRequired[int | None],
    "ort": typing.NotRequired[InputPathType | None],
    "autoclip": bool,
    "automask": bool,
    "zcensor": bool,
    "prefix": typing.NotRequired[str | None],
})
V3dTcorrelateParametersTagged = typing.TypedDict('V3dTcorrelateParametersTagged', {
    "@type": typing.Literal["afni/3dTcorrelate"],
    "xset": InputPathType,
    "yset": InputPathType,
    "pearson": bool,
    "spearman": bool,
    "quadrant": bool,
    "ktaub": bool,
    "covariance": bool,
    "partial": typing.NotRequired[InputPathType | None],
    "ycoef": bool,
    "fisher": bool,
    "polort": typing.NotRequired[int | None],
    "ort": typing.NotRequired[InputPathType | None],
    "autoclip": bool,
    "automask": bool,
    "zcensor": bool,
    "prefix": typing.NotRequired[str | None],
})


class V3dTcorrelateOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dTcorrelateParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType | None
    """Output image file name."""


def v_3d_tcorrelate_params(
    xset: InputPathType,
    yset: InputPathType,
    pearson: bool = False,
    spearman: bool = False,
    quadrant: bool = False,
    ktaub: bool = False,
    covariance: bool = False,
    partial: InputPathType | None = None,
    ycoef: bool = False,
    fisher: bool = False,
    polort: int | None = None,
    ort: InputPathType | None = None,
    autoclip: bool = False,
    automask: bool = False,
    zcensor: bool = False,
    prefix: str | None = None,
) -> V3dTcorrelateParametersTagged:
    """
    Build parameters.
    
    Args:
        xset: Input xset.
        yset: Input yset.
        pearson: Correlation is the normal pearson correlation coefficient.
        spearman: Correlation is the Spearman (rank) correlation coefficient.
        quadrant: Correlation is the quadrant coefficient.
        ktaub: Correlation is Kendall's tau_b coefficient. For continuous or\
            finely discretized data, tau_b and rank correlation are nearly\
            equivalent.
        covariance: Covariance instead of correlation. That would be Pearson\
            correlation without scaling by the product of the standard deviations.
        partial: Partial Pearson's correlation of X & Y, adjusting for Z (the\
            dataset provided here).
        ycoef: Least squares coefficient that best fits y(t) to x(t), after\
            detrending. That is, if yd(t) is the detrended y(t) and xd(t) is the\
            detrended x(t), then the ycoef value is from the OLSQ fit to xd(t) =\
            ycoef & y(t) + error.
        fisher: Apply the Fisher (inverse hyperbolic tangent) transformation to\
            correlation results. Does not make sense with ktaub, covariance, or\
            ycoef.
        polort: Remove polynomial trend of order m. Using m=-1 mean no\
            detrending; this is only useful fro data that has been preprocessed.
        ort: A 1D file. Also detrend using the columbs of the 1D file provided\
            here. Only one -ort option can be given, so if you would like to use\
            more than one, create a temporary file using 1dcat.
        autoclip: Clip off low-intensity regions in the two datasets, so that\
            the correlation is only computed between high-intensity (presumably\
            brain) voxels. The intensity level is determined the same way that\
            3dClipLevel works.
        automask: Clip off low-intensity regions in the two datasets, so that\
            the correlation is only computed between high-intensity (presumably\
            brain) voxels. The intensity level is determined the same way that\
            3dClipLevel works.
        zcensor: Omit (censor out) any time points where the xset volume is all\
            zero OR where the yset volume is all zero (in mask). Please note that\
            using -zcensor with any detrending is unlikely to be useful.
        prefix: Save output into a dataset with this prefix.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dTcorrelate",
        "xset": xset,
        "yset": yset,
        "pearson": pearson,
        "spearman": spearman,
        "quadrant": quadrant,
        "ktaub": ktaub,
        "covariance": covariance,
        "ycoef": ycoef,
        "fisher": fisher,
        "autoclip": autoclip,
        "automask": automask,
        "zcensor": zcensor,
    }
    if partial is not None:
        params["partial"] = partial
    if polort is not None:
        params["polort"] = polort
    if ort is not None:
        params["ort"] = ort
    if prefix is not None:
        params["prefix"] = prefix
    return params


def v_3d_tcorrelate_cargs(
    params: V3dTcorrelateParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dTcorrelate")
    cargs.append(execution.input_file(params.get("xset", None)))
    cargs.append(execution.input_file(params.get("yset", None)))
    if params.get("pearson", False):
        cargs.append("-pearson")
    if params.get("spearman", False):
        cargs.append("-spearman")
    if params.get("quadrant", False):
        cargs.append("-quadrant")
    if params.get("ktaub", False):
        cargs.append("-ktaub")
    if params.get("covariance", False):
        cargs.append("-covariance")
    if params.get("partial", None) is not None:
        cargs.extend([
            "-partial",
            execution.input_file(params.get("partial", None))
        ])
    if params.get("ycoef", False):
        cargs.append("-ycoef")
    if params.get("fisher", False):
        cargs.append("-Fisher")
    if params.get("polort", None) is not None:
        cargs.extend([
            "-polort",
            str(params.get("polort", None))
        ])
    if params.get("ort", None) is not None:
        cargs.extend([
            "-ort",
            execution.input_file(params.get("ort", None))
        ])
    if params.get("autoclip", False):
        cargs.append("-autoclip")
    if params.get("automask", False):
        cargs.append("-automask")
    if params.get("zcensor", False):
        cargs.append("-zcensor")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    return cargs


def v_3d_tcorrelate_outputs(
    params: V3dTcorrelateParameters,
    execution: Execution,
) -> V3dTcorrelateOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dTcorrelateOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(params.get("prefix", None)) if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_tcorrelate_execute(
    params: V3dTcorrelateParameters,
    runner: Runner | None = None,
) -> V3dTcorrelateOutputs:
    """
    3dTcorrelate
    
    3dTcorrelate. Computes the correlation coefficient between corresponding
    voxel time series in two input 3D+time datasets 'xset' and 'yset'.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dTcorrelateOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_TCORRELATE_METADATA)
    params = execution.params(params)
    cargs = v_3d_tcorrelate_cargs(params, execution)
    ret = v_3d_tcorrelate_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_tcorrelate(
    xset: InputPathType,
    yset: InputPathType,
    pearson: bool = False,
    spearman: bool = False,
    quadrant: bool = False,
    ktaub: bool = False,
    covariance: bool = False,
    partial: InputPathType | None = None,
    ycoef: bool = False,
    fisher: bool = False,
    polort: int | None = None,
    ort: InputPathType | None = None,
    autoclip: bool = False,
    automask: bool = False,
    zcensor: bool = False,
    prefix: str | None = None,
    runner: Runner | None = None,
) -> V3dTcorrelateOutputs:
    """
    3dTcorrelate
    
    3dTcorrelate. Computes the correlation coefficient between corresponding
    voxel time series in two input 3D+time datasets 'xset' and 'yset'.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        xset: Input xset.
        yset: Input yset.
        pearson: Correlation is the normal pearson correlation coefficient.
        spearman: Correlation is the Spearman (rank) correlation coefficient.
        quadrant: Correlation is the quadrant coefficient.
        ktaub: Correlation is Kendall's tau_b coefficient. For continuous or\
            finely discretized data, tau_b and rank correlation are nearly\
            equivalent.
        covariance: Covariance instead of correlation. That would be Pearson\
            correlation without scaling by the product of the standard deviations.
        partial: Partial Pearson's correlation of X & Y, adjusting for Z (the\
            dataset provided here).
        ycoef: Least squares coefficient that best fits y(t) to x(t), after\
            detrending. That is, if yd(t) is the detrended y(t) and xd(t) is the\
            detrended x(t), then the ycoef value is from the OLSQ fit to xd(t) =\
            ycoef & y(t) + error.
        fisher: Apply the Fisher (inverse hyperbolic tangent) transformation to\
            correlation results. Does not make sense with ktaub, covariance, or\
            ycoef.
        polort: Remove polynomial trend of order m. Using m=-1 mean no\
            detrending; this is only useful fro data that has been preprocessed.
        ort: A 1D file. Also detrend using the columbs of the 1D file provided\
            here. Only one -ort option can be given, so if you would like to use\
            more than one, create a temporary file using 1dcat.
        autoclip: Clip off low-intensity regions in the two datasets, so that\
            the correlation is only computed between high-intensity (presumably\
            brain) voxels. The intensity level is determined the same way that\
            3dClipLevel works.
        automask: Clip off low-intensity regions in the two datasets, so that\
            the correlation is only computed between high-intensity (presumably\
            brain) voxels. The intensity level is determined the same way that\
            3dClipLevel works.
        zcensor: Omit (censor out) any time points where the xset volume is all\
            zero OR where the yset volume is all zero (in mask). Please note that\
            using -zcensor with any detrending is unlikely to be useful.
        prefix: Save output into a dataset with this prefix.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dTcorrelateOutputs`).
    """
    params = v_3d_tcorrelate_params(
        xset=xset,
        yset=yset,
        pearson=pearson,
        spearman=spearman,
        quadrant=quadrant,
        ktaub=ktaub,
        covariance=covariance,
        partial=partial,
        ycoef=ycoef,
        fisher=fisher,
        polort=polort,
        ort=ort,
        autoclip=autoclip,
        automask=automask,
        zcensor=zcensor,
        prefix=prefix,
    )
    return v_3d_tcorrelate_execute(params, runner)


__all__ = [
    "V3dTcorrelateOutputs",
    "V_3D_TCORRELATE_METADATA",
    "v_3d_tcorrelate",
    "v_3d_tcorrelate_execute",
    "v_3d_tcorrelate_params",
]
