# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_TSORT_METADATA = Metadata(
    id="5d9ca58028660f8bc8ecbc139838677b6c58e892.boutiques",
    name="3dTsort",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dTsortParameters = typing.TypedDict('V3dTsortParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dTsort"]],
    "input_file": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "inc": bool,
    "dec": bool,
    "rank": bool,
    "ind": bool,
    "val": bool,
    "random": bool,
    "ranfft": bool,
    "randft": bool,
    "datum": typing.NotRequired[str | None],
})
V3dTsortParametersTagged = typing.TypedDict('V3dTsortParametersTagged', {
    "@type": typing.Literal["afni/3dTsort"],
    "input_file": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "inc": bool,
    "dec": bool,
    "rank": bool,
    "ind": bool,
    "val": bool,
    "random": bool,
    "ranfft": bool,
    "randft": bool,
    "datum": typing.NotRequired[str | None],
})


class V3dTsortOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dTsortParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType | None
    """Main default output of 3dTsort"""


def v_3d_tsort_params(
    input_file: InputPathType,
    prefix: str | None = None,
    inc: bool = False,
    dec: bool = False,
    rank: bool = False,
    ind: bool = False,
    val: bool = False,
    random_: bool = False,
    ranfft: bool = False,
    randft: bool = False,
    datum: str | None = None,
) -> V3dTsortParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Input dataset to be sorted.
        prefix: Prefix for the output dataset.
        inc: Sort into increasing order (default).
        dec: Sort into decreasing order.
        rank: Output rank instead of sorted values; ranks range from 1 to Nvals.
        ind: Output sorting index (0 to Nvals -1).
        val: Output sorted values (default).
        random_: Randomly shuffle (permute) the time points in each voxel.
        ranfft: Randomize each time series by scrambling the FFT phase.
        randft: Randomize each time series by scrambling the DFT phase.
        datum: Coerce the output data to be stored as the given type (byte,\
            short, or float).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dTsort",
        "input_file": input_file,
        "inc": inc,
        "dec": dec,
        "rank": rank,
        "ind": ind,
        "val": val,
        "random": random_,
        "ranfft": ranfft,
        "randft": randft,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if datum is not None:
        params["datum"] = datum
    return params


def v_3d_tsort_cargs(
    params: V3dTsortParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dTsort")
    cargs.append(execution.input_file(params.get("input_file", None)))
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("inc", False):
        cargs.append("-inc")
    if params.get("dec", False):
        cargs.append("-dec")
    if params.get("rank", False):
        cargs.append("-rank")
    if params.get("ind", False):
        cargs.append("-ind")
    if params.get("val", False):
        cargs.append("-val")
    if params.get("random", False):
        cargs.append("-random")
    if params.get("ranfft", False):
        cargs.append("-ranFFT")
    if params.get("randft", False):
        cargs.append("-ranDFT")
    if params.get("datum", None) is not None:
        cargs.extend([
            "-datum",
            params.get("datum", None)
        ])
    return cargs


def v_3d_tsort_outputs(
    params: V3dTsortParameters,
    execution: Execution,
) -> V3dTsortOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dTsortOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file(params.get("prefix", None) + ".nii.gz") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3d_tsort_execute(
    params: V3dTsortParameters,
    runner: Runner | None = None,
) -> V3dTsortOutputs:
    """
    3dTsort
    
    Sorts each voxel in a dataset and produces a new dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dTsortOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_TSORT_METADATA)
    params = execution.params(params)
    cargs = v_3d_tsort_cargs(params, execution)
    ret = v_3d_tsort_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_tsort(
    input_file: InputPathType,
    prefix: str | None = None,
    inc: bool = False,
    dec: bool = False,
    rank: bool = False,
    ind: bool = False,
    val: bool = False,
    random_: bool = False,
    ranfft: bool = False,
    randft: bool = False,
    datum: str | None = None,
    runner: Runner | None = None,
) -> V3dTsortOutputs:
    """
    3dTsort
    
    Sorts each voxel in a dataset and produces a new dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Input dataset to be sorted.
        prefix: Prefix for the output dataset.
        inc: Sort into increasing order (default).
        dec: Sort into decreasing order.
        rank: Output rank instead of sorted values; ranks range from 1 to Nvals.
        ind: Output sorting index (0 to Nvals -1).
        val: Output sorted values (default).
        random_: Randomly shuffle (permute) the time points in each voxel.
        ranfft: Randomize each time series by scrambling the FFT phase.
        randft: Randomize each time series by scrambling the DFT phase.
        datum: Coerce the output data to be stored as the given type (byte,\
            short, or float).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dTsortOutputs`).
    """
    params = v_3d_tsort_params(
        input_file=input_file,
        prefix=prefix,
        inc=inc,
        dec=dec,
        rank=rank,
        ind=ind,
        val=val,
        random_=random_,
        ranfft=ranfft,
        randft=randft,
        datum=datum,
    )
    return v_3d_tsort_execute(params, runner)


__all__ = [
    "V3dTsortOutputs",
    "V_3D_TSORT_METADATA",
    "v_3d_tsort",
    "v_3d_tsort_execute",
    "v_3d_tsort_params",
]
