# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_TSPLIT4_D_METADATA = Metadata(
    id="f793f3b639c9da84b752d9dfa8909607817a79ec.boutiques",
    name="3dTsplit4D",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dTsplit4DParameters = typing.TypedDict('V3dTsplit4DParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dTsplit4D"]],
    "prefix": str,
    "infile": InputPathType,
    "keep_datum": bool,
    "digits": typing.NotRequired[float | None],
})
V3dTsplit4DParametersTagged = typing.TypedDict('V3dTsplit4DParametersTagged', {
    "@type": typing.Literal["afni/3dTsplit4D"],
    "prefix": str,
    "infile": InputPathType,
    "keep_datum": bool,
    "digits": typing.NotRequired[float | None],
})


class V3dTsplit4DOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dTsplit4DParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3d_tsplit4_d_params(
    prefix: str,
    infile: InputPathType,
    keep_datum: bool = False,
    digits: float | None = None,
) -> V3dTsplit4DParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix of the output datasets (e.g., out/epi).
        infile: Input 3D+time dataset (e.g., epi_r1+orig).
        keep_datum: Output uses original datum (no conversion to float).
        digits: Number of digits to use for output filenames.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dTsplit4D",
        "prefix": prefix,
        "infile": infile,
        "keep_datum": keep_datum,
    }
    if digits is not None:
        params["digits"] = digits
    return params


def v_3d_tsplit4_d_cargs(
    params: V3dTsplit4DParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dTsplit4D")
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    cargs.append(execution.input_file(params.get("infile", None)))
    if params.get("keep_datum", False):
        cargs.append("-keep_datum")
    if params.get("digits", None) is not None:
        cargs.extend([
            "-digits",
            str(params.get("digits", None))
        ])
    return cargs


def v_3d_tsplit4_d_outputs(
    params: V3dTsplit4DParameters,
    execution: Execution,
) -> V3dTsplit4DOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dTsplit4DOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3d_tsplit4_d_execute(
    params: V3dTsplit4DParameters,
    runner: Runner | None = None,
) -> V3dTsplit4DOutputs:
    """
    3dTsplit4D
    
    Convert a 3D+time dataset into multiple 3D single-brick files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dTsplit4DOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_TSPLIT4_D_METADATA)
    params = execution.params(params)
    cargs = v_3d_tsplit4_d_cargs(params, execution)
    ret = v_3d_tsplit4_d_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_tsplit4_d(
    prefix: str,
    infile: InputPathType,
    keep_datum: bool = False,
    digits: float | None = None,
    runner: Runner | None = None,
) -> V3dTsplit4DOutputs:
    """
    3dTsplit4D
    
    Convert a 3D+time dataset into multiple 3D single-brick files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix of the output datasets (e.g., out/epi).
        infile: Input 3D+time dataset (e.g., epi_r1+orig).
        keep_datum: Output uses original datum (no conversion to float).
        digits: Number of digits to use for output filenames.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dTsplit4DOutputs`).
    """
    params = v_3d_tsplit4_d_params(
        prefix=prefix,
        infile=infile,
        keep_datum=keep_datum,
        digits=digits,
    )
    return v_3d_tsplit4_d_execute(params, runner)


__all__ = [
    "V3dTsplit4DOutputs",
    "V_3D_TSPLIT4_D_METADATA",
    "v_3d_tsplit4_d",
    "v_3d_tsplit4_d_execute",
    "v_3d_tsplit4_d_params",
]
