# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_UNIFIZE_METADATA = Metadata(
    id="9fab3ba8f4e528c3b3fe2bdcd3fc9fd6c7cd2841.boutiques",
    name="3dUnifize",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dUnifizeParameters = typing.TypedDict('V3dUnifizeParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dUnifize"]],
    "cl_frac": typing.NotRequired[float | None],
    "epi": bool,
    "gm": bool,
    "no_duplo": bool,
    "num_threads": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "quiet": bool,
    "rbt": typing.NotRequired[list[float] | None],
    "prefix": typing.NotRequired[str | None],
    "scale_file": typing.NotRequired[InputPathType | None],
    "t2": bool,
    "t2_up": typing.NotRequired[float | None],
    "urad": typing.NotRequired[float | None],
    "in_file": InputPathType,
})
V3dUnifizeParametersTagged = typing.TypedDict('V3dUnifizeParametersTagged', {
    "@type": typing.Literal["afni/3dUnifize"],
    "cl_frac": typing.NotRequired[float | None],
    "epi": bool,
    "gm": bool,
    "no_duplo": bool,
    "num_threads": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "quiet": bool,
    "rbt": typing.NotRequired[list[float] | None],
    "prefix": typing.NotRequired[str | None],
    "scale_file": typing.NotRequired[InputPathType | None],
    "t2": bool,
    "t2_up": typing.NotRequired[float | None],
    "urad": typing.NotRequired[float | None],
    "in_file": InputPathType,
})


class V3dUnifizeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dUnifizeParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType | None
    """Output image file name."""
    scale_file_outfile: OutputPathType | None
    """Scale factor file."""


def v_3d_unifize_params(
    in_file: InputPathType,
    cl_frac: float | None = None,
    epi: bool = False,
    gm: bool = False,
    no_duplo: bool = False,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    quiet: bool = False,
    rbt: list[float] | None = None,
    prefix: str | None = None,
    scale_file: InputPathType | None = None,
    t2: bool = False,
    t2_up: float | None = None,
    urad: float | None = None,
) -> V3dUnifizeParametersTagged:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3dunifize.
        cl_frac: Option for afni experts only.set the automask 'clip level\
            fraction'. must be between 0.1 and 0.9. a small fraction means to make\
            the initial threshold for clipping (a la 3dcliplevel) smaller, which\
            will tend to make the mask larger. [default=0.1].
        epi: Assume the input dataset is a t2 (or t2\\*) weighted epi time\
            series. after computing the scaling, apply it to all volumes (trs) in\
            the input dataset. that is, a given voxel will be scaled by the same\
            factor at each tr. this option also implies '-noduplo' and '-t2'.this\
            option turns off '-gm' if you turned it on.
        gm: Also scale to unifize 'gray matter' = lower intensity voxels (to\
            aid in registering images from different scanners).
        no_duplo: Do not use the 'duplo down' step; this can be useful for\
            lower resolution datasets.
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        quiet: Don't print the progress messages.
        rbt: (a float, a float, a float). Option for afni experts only.specify\
            the 3 parameters for the algorithm:r = radius; same as given by option\
            '-urad', [default=18.3]b = bottom percentile of normalizing data range,\
            [default=70.0]r = top percentile of normalizing data range,\
            [default=80.0].
        prefix: Output image file name.
        scale_file: Output file name to save the scale factor used at each\
            voxel .
        t2: Treat the input as if it were t2-weighted, rather than t1-weighted.\
            this processing is done simply by inverting the image contrast,\
            processing it as if that result were t1-weighted, and then re-inverting\
            the results counts of voxel overlap, i.e., each voxel will contain the\
            number of masks that it is set in.
        t2_up: Option for afni experts only.set the upper percentile point used\
            for t2-t1 inversion. allowed to be anything between 90 and 100\
            (inclusive), with default to 98.5 (for no good reason).
        urad: Sets the radius (in voxels) of the ball used for the sneaky\
            trick. default value is 18.3, and should be changed proportionally if\
            the dataset voxel size differs significantly from 1 mm.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dUnifize",
        "epi": epi,
        "gm": gm,
        "no_duplo": no_duplo,
        "quiet": quiet,
        "t2": t2,
        "in_file": in_file,
    }
    if cl_frac is not None:
        params["cl_frac"] = cl_frac
    if num_threads is not None:
        params["num_threads"] = num_threads
    if outputtype is not None:
        params["outputtype"] = outputtype
    if rbt is not None:
        params["rbt"] = rbt
    if prefix is not None:
        params["prefix"] = prefix
    if scale_file is not None:
        params["scale_file"] = scale_file
    if t2_up is not None:
        params["t2_up"] = t2_up
    if urad is not None:
        params["urad"] = urad
    return params


def v_3d_unifize_cargs(
    params: V3dUnifizeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dUnifize")
    if params.get("cl_frac", None) is not None:
        cargs.extend([
            "-clfrac",
            str(params.get("cl_frac", None))
        ])
    if params.get("epi", False):
        cargs.append("-EPI")
    if params.get("gm", False):
        cargs.append("-GM")
    if params.get("no_duplo", False):
        cargs.append("-noduplo")
    if params.get("num_threads", None) is not None:
        cargs.append(str(params.get("num_threads", None)))
    if params.get("outputtype", None) is not None:
        cargs.append(params.get("outputtype", None))
    if params.get("quiet", False):
        cargs.append("-quiet")
    if params.get("rbt", None) is not None:
        cargs.extend([
            "-rbt",
            *map(str, params.get("rbt", None))
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("scale_file", None) is not None:
        cargs.extend([
            "-ssave",
            execution.input_file(params.get("scale_file", None))
        ])
    if params.get("t2", False):
        cargs.append("-T2")
    if params.get("t2_up", None) is not None:
        cargs.extend([
            "-T2up",
            str(params.get("t2_up", None))
        ])
    if params.get("urad", None) is not None:
        cargs.extend([
            "-Urad",
            str(params.get("urad", None))
        ])
    cargs.extend([
        "-input",
        execution.input_file(params.get("in_file", None))
    ])
    return cargs


def v_3d_unifize_outputs(
    params: V3dUnifizeParameters,
    execution: Execution,
) -> V3dUnifizeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dUnifizeOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(params.get("prefix", None)) if (params.get("prefix") is not None) else None,
        scale_file_outfile=execution.output_file(pathlib.Path(params.get("scale_file", None)).name) if (params.get("scale_file") is not None) else None,
    )
    return ret


def v_3d_unifize_execute(
    params: V3dUnifizeParameters,
    runner: Runner | None = None,
) -> V3dUnifizeOutputs:
    """
    3dUnifize
    
    3dUnifize - for uniformizing image intensity
    * The input dataset is supposed to be a T1-weighted volume, possibly already
    skull-stripped (e.g., via 3dSkullStrip). However, this program can be a
    useful step to take BEFORE 3dSkullStrip, since the latter program can fail
    if the input volume is strongly shaded -- 3dUnifize will (mostly) remove
    such shading artifacts.
    * The output dataset has the white matter (WM) intensity approximately
    uniformized across space, and scaled to peak at about 1000.
    * The output dataset is always stored in float format!
    * If the input dataset has more than 1 sub-brick, only sub-brick #0 will be
    processed!
    * Want to correct EPI datasets for nonuniformity? You can try the new and
    experimental [Mar 2017] '-EPI' option.
    * The principal motive for this program is for use in an image registration
    script, and it may or may not be useful otherwise.
    * This program replaces the older (and very different) 3dUniformize, which
    is no longer maintained and may sublimate at any moment. (In other words, we
    do not recommend the use of 3dUniformize.).
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dUnifizeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_UNIFIZE_METADATA)
    params = execution.params(params)
    cargs = v_3d_unifize_cargs(params, execution)
    ret = v_3d_unifize_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_unifize(
    in_file: InputPathType,
    cl_frac: float | None = None,
    epi: bool = False,
    gm: bool = False,
    no_duplo: bool = False,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    quiet: bool = False,
    rbt: list[float] | None = None,
    prefix: str | None = None,
    scale_file: InputPathType | None = None,
    t2: bool = False,
    t2_up: float | None = None,
    urad: float | None = None,
    runner: Runner | None = None,
) -> V3dUnifizeOutputs:
    """
    3dUnifize
    
    3dUnifize - for uniformizing image intensity
    * The input dataset is supposed to be a T1-weighted volume, possibly already
    skull-stripped (e.g., via 3dSkullStrip). However, this program can be a
    useful step to take BEFORE 3dSkullStrip, since the latter program can fail
    if the input volume is strongly shaded -- 3dUnifize will (mostly) remove
    such shading artifacts.
    * The output dataset has the white matter (WM) intensity approximately
    uniformized across space, and scaled to peak at about 1000.
    * The output dataset is always stored in float format!
    * If the input dataset has more than 1 sub-brick, only sub-brick #0 will be
    processed!
    * Want to correct EPI datasets for nonuniformity? You can try the new and
    experimental [Mar 2017] '-EPI' option.
    * The principal motive for this program is for use in an image registration
    script, and it may or may not be useful otherwise.
    * This program replaces the older (and very different) 3dUniformize, which
    is no longer maintained and may sublimate at any moment. (In other words, we
    do not recommend the use of 3dUniformize.).
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3dunifize.
        cl_frac: Option for afni experts only.set the automask 'clip level\
            fraction'. must be between 0.1 and 0.9. a small fraction means to make\
            the initial threshold for clipping (a la 3dcliplevel) smaller, which\
            will tend to make the mask larger. [default=0.1].
        epi: Assume the input dataset is a t2 (or t2\\*) weighted epi time\
            series. after computing the scaling, apply it to all volumes (trs) in\
            the input dataset. that is, a given voxel will be scaled by the same\
            factor at each tr. this option also implies '-noduplo' and '-t2'.this\
            option turns off '-gm' if you turned it on.
        gm: Also scale to unifize 'gray matter' = lower intensity voxels (to\
            aid in registering images from different scanners).
        no_duplo: Do not use the 'duplo down' step; this can be useful for\
            lower resolution datasets.
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        quiet: Don't print the progress messages.
        rbt: (a float, a float, a float). Option for afni experts only.specify\
            the 3 parameters for the algorithm:r = radius; same as given by option\
            '-urad', [default=18.3]b = bottom percentile of normalizing data range,\
            [default=70.0]r = top percentile of normalizing data range,\
            [default=80.0].
        prefix: Output image file name.
        scale_file: Output file name to save the scale factor used at each\
            voxel .
        t2: Treat the input as if it were t2-weighted, rather than t1-weighted.\
            this processing is done simply by inverting the image contrast,\
            processing it as if that result were t1-weighted, and then re-inverting\
            the results counts of voxel overlap, i.e., each voxel will contain the\
            number of masks that it is set in.
        t2_up: Option for afni experts only.set the upper percentile point used\
            for t2-t1 inversion. allowed to be anything between 90 and 100\
            (inclusive), with default to 98.5 (for no good reason).
        urad: Sets the radius (in voxels) of the ball used for the sneaky\
            trick. default value is 18.3, and should be changed proportionally if\
            the dataset voxel size differs significantly from 1 mm.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dUnifizeOutputs`).
    """
    params = v_3d_unifize_params(
        cl_frac=cl_frac,
        epi=epi,
        gm=gm,
        no_duplo=no_duplo,
        num_threads=num_threads,
        outputtype=outputtype,
        quiet=quiet,
        rbt=rbt,
        prefix=prefix,
        scale_file=scale_file,
        t2=t2,
        t2_up=t2_up,
        urad=urad,
        in_file=in_file,
    )
    return v_3d_unifize_execute(params, runner)


__all__ = [
    "V3dUnifizeOutputs",
    "V_3D_UNIFIZE_METADATA",
    "v_3d_unifize",
    "v_3d_unifize_execute",
    "v_3d_unifize_params",
]
