# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3D_WILCOXON_METADATA = Metadata(
    id="fcdfe176a791fcc4e58413ccf00db5b02ca3fa85.boutiques",
    name="3dWilcoxon",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dWilcoxonParameters = typing.TypedDict('V3dWilcoxonParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dWilcoxon"]],
    "workmem": typing.NotRequired[float | None],
    "voxel": typing.NotRequired[float | None],
    "dset1_x": list[InputPathType],
    "dset2_y": list[InputPathType],
    "output_prefix": str,
})
V3dWilcoxonParametersTagged = typing.TypedDict('V3dWilcoxonParametersTagged', {
    "@type": typing.Literal["afni/3dWilcoxon"],
    "workmem": typing.NotRequired[float | None],
    "voxel": typing.NotRequired[float | None],
    "dset1_x": list[InputPathType],
    "dset2_y": list[InputPathType],
    "output_prefix": str,
})


class V3dWilcoxonOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dWilcoxonParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Estimated population delta and Wilcoxon signed-rank statistics"""


def v_3d_wilcoxon_params(
    dset1_x: list[InputPathType],
    dset2_y: list[InputPathType],
    output_prefix: str,
    workmem: float | None = None,
    voxel: float | None = None,
) -> V3dWilcoxonParametersTagged:
    """
    Build parameters.
    
    Args:
        dset1_x: Data set for X observations. The user must specify 1 and only\
            1 sub-brick with each -dset command.
        dset2_y: Data set for Y observations. The user must specify 1 and only\
            1 sub-brick with each -dset command.
        output_prefix: Estimated population delta and Wilcoxon signed-rank\
            statistics are written to file.
        workmem: Number of megabytes of RAM to use for statistical workspace.
        voxel: Screen output for voxel # num.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dWilcoxon",
        "dset1_x": dset1_x,
        "dset2_y": dset2_y,
        "output_prefix": output_prefix,
    }
    if workmem is not None:
        params["workmem"] = workmem
    if voxel is not None:
        params["voxel"] = voxel
    return params


def v_3d_wilcoxon_cargs(
    params: V3dWilcoxonParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dWilcoxon")
    if params.get("workmem", None) is not None:
        cargs.extend([
            "-workmem",
            str(params.get("workmem", None))
        ])
    if params.get("voxel", None) is not None:
        cargs.extend([
            "-voxel",
            str(params.get("voxel", None))
        ])
    cargs.extend([
        "-dset 1",
        *[execution.input_file(f) for f in params.get("dset1_x", None)]
    ])
    cargs.extend([
        "-dset 2",
        *[execution.input_file(f) for f in params.get("dset2_y", None)]
    ])
    cargs.extend([
        "-out",
        params.get("output_prefix", None)
    ])
    return cargs


def v_3d_wilcoxon_outputs(
    params: V3dWilcoxonParameters,
    execution: Execution,
) -> V3dWilcoxonOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dWilcoxonOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output_prefix", None)),
    )
    return ret


def v_3d_wilcoxon_execute(
    params: V3dWilcoxonParameters,
    runner: Runner | None = None,
) -> V3dWilcoxonOutputs:
    """
    3dWilcoxon
    
    Nonparametric Wilcoxon signed-rank test for paired comparisons of two
    samples.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dWilcoxonOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3D_WILCOXON_METADATA)
    params = execution.params(params)
    cargs = v_3d_wilcoxon_cargs(params, execution)
    ret = v_3d_wilcoxon_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3d_wilcoxon(
    dset1_x: list[InputPathType],
    dset2_y: list[InputPathType],
    output_prefix: str,
    workmem: float | None = None,
    voxel: float | None = None,
    runner: Runner | None = None,
) -> V3dWilcoxonOutputs:
    """
    3dWilcoxon
    
    Nonparametric Wilcoxon signed-rank test for paired comparisons of two
    samples.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dset1_x: Data set for X observations. The user must specify 1 and only\
            1 sub-brick with each -dset command.
        dset2_y: Data set for Y observations. The user must specify 1 and only\
            1 sub-brick with each -dset command.
        output_prefix: Estimated population delta and Wilcoxon signed-rank\
            statistics are written to file.
        workmem: Number of megabytes of RAM to use for statistical workspace.
        voxel: Screen output for voxel # num.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dWilcoxonOutputs`).
    """
    params = v_3d_wilcoxon_params(
        workmem=workmem,
        voxel=voxel,
        dset1_x=dset1_x,
        dset2_y=dset2_y,
        output_prefix=output_prefix,
    )
    return v_3d_wilcoxon_execute(params, runner)


__all__ = [
    "V3dWilcoxonOutputs",
    "V_3D_WILCOXON_METADATA",
    "v_3d_wilcoxon",
    "v_3d_wilcoxon_execute",
    "v_3d_wilcoxon_params",
]
