# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DANISOSMOOTH_METADATA = Metadata(
    id="dae012901f3b9c0ef9fb5a4a4f358d15d077efc3.boutiques",
    name="3danisosmooth",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3danisosmoothParameters = typing.TypedDict('V3danisosmoothParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3danisosmooth"]],
    "input_dataset": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "iterations": typing.NotRequired[float | None],
    "2d_flag": bool,
    "3d_flag": bool,
    "mask_dataset": typing.NotRequired[InputPathType | None],
    "automask_flag": bool,
    "viewer_flag": bool,
    "nosmooth_flag": bool,
    "sigma1": typing.NotRequired[float | None],
    "sigma2": typing.NotRequired[float | None],
    "deltat": typing.NotRequired[float | None],
    "savetempdata_flag": bool,
    "save_temp_with_diff_measures_flag": bool,
    "phiding_flag": bool,
    "phiexp_flag": bool,
    "noneg_flag": bool,
    "setneg_value": typing.NotRequired[float | None],
    "edgefraction": typing.NotRequired[float | None],
    "datum_type": typing.NotRequired[str | None],
    "matchorig_flag": bool,
    "help_flag": bool,
})
V3danisosmoothParametersTagged = typing.TypedDict('V3danisosmoothParametersTagged', {
    "@type": typing.Literal["afni/3danisosmooth"],
    "input_dataset": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "iterations": typing.NotRequired[float | None],
    "2d_flag": bool,
    "3d_flag": bool,
    "mask_dataset": typing.NotRequired[InputPathType | None],
    "automask_flag": bool,
    "viewer_flag": bool,
    "nosmooth_flag": bool,
    "sigma1": typing.NotRequired[float | None],
    "sigma2": typing.NotRequired[float | None],
    "deltat": typing.NotRequired[float | None],
    "savetempdata_flag": bool,
    "save_temp_with_diff_measures_flag": bool,
    "phiding_flag": bool,
    "phiexp_flag": bool,
    "noneg_flag": bool,
    "setneg_value": typing.NotRequired[float | None],
    "edgefraction": typing.NotRequired[float | None],
    "datum_type": typing.NotRequired[str | None],
    "matchorig_flag": bool,
    "help_flag": bool,
})


class V3danisosmoothOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3danisosmoothParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType | None
    """Output dataset after anisotropic smoothing"""
    gradient_data: OutputPathType
    """Gradient dataset saved at each iteration"""
    eigens_data: OutputPathType
    """Eigens dataset saved at each iteration"""
    phi_data: OutputPathType
    """Phi dataset saved at each iteration"""
    dtensor_data: OutputPathType
    """Dtensor dataset saved at each iteration"""
    ematrix_data: OutputPathType
    """Ematrix dataset saved at the first sub-brick iteration"""
    flux_data: OutputPathType
    """Flux dataset saved at the first sub-brick iteration"""
    gmatrix_data: OutputPathType
    """Gmatrix dataset saved at the first sub-brick iteration"""
    diff_measures_data: OutputPathType
    """Dataset containing FA, MD, Cl, Cp, and Cs values saved at each
    iteration"""


def v_3danisosmooth_params(
    input_dataset: InputPathType,
    prefix: str | None = None,
    iterations: float | None = None,
    v_2d_flag: bool = False,
    v_3d_flag: bool = False,
    mask_dataset: InputPathType | None = None,
    automask_flag: bool = False,
    viewer_flag: bool = False,
    nosmooth_flag: bool = False,
    sigma1: float | None = None,
    sigma2: float | None = None,
    deltat: float | None = None,
    savetempdata_flag: bool = False,
    save_temp_with_diff_measures_flag: bool = False,
    phiding_flag: bool = False,
    phiexp_flag: bool = False,
    noneg_flag: bool = False,
    setneg_value: float | None = None,
    edgefraction: float | None = None,
    datum_type: str | None = None,
    matchorig_flag: bool = False,
    help_flag: bool = False,
) -> V3danisosmoothParametersTagged:
    """
    Build parameters.
    
    Args:
        input_dataset: Input dataset to be smoothed.
        prefix: Output dataset prefix name.
        iterations: Number of iterations (default=10).
        v_2d_flag: Smooth a slice at a time (default).
        v_3d_flag: Smooth through slices.
        mask_dataset: Use specified dataset as mask to include/exclude voxels.
        automask_flag: Automatically compute mask for dataset.
        viewer_flag: Show central axial slice image every iteration.
        nosmooth_flag: Do not do intermediate smoothing of gradients.
        sigma1: Gaussian smoothing sigma before gradient computation\
            (default=0.5).
        sigma2: Gaussian smoothing sigma after gradient computation\
            (default=1.0).
        deltat: Pseudo-time step (default=0.25).
        savetempdata_flag: Save temporary datasets each iteration.
        save_temp_with_diff_measures_flag: Save temporary datasets with\
            different measures in a dataset.
        phiding_flag: Use Ding method for computing phi (default).
        phiexp_flag: Use exponential method for computing phi.
        noneg_flag: Set negative voxels to 0.
        setneg_value: Set negative voxels to specified value.
        edgefraction: Adjust the fraction of the anisotropic component added (0\
            to 1, default=0.5).
        datum_type: Specify type for output data (byte, short, float)\
            [default=float].
        matchorig_flag: Match datum type and clip min/max to input data.
        help_flag: Print help message.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3danisosmooth",
        "input_dataset": input_dataset,
        "2d_flag": v_2d_flag,
        "3d_flag": v_3d_flag,
        "automask_flag": automask_flag,
        "viewer_flag": viewer_flag,
        "nosmooth_flag": nosmooth_flag,
        "savetempdata_flag": savetempdata_flag,
        "save_temp_with_diff_measures_flag": save_temp_with_diff_measures_flag,
        "phiding_flag": phiding_flag,
        "phiexp_flag": phiexp_flag,
        "noneg_flag": noneg_flag,
        "matchorig_flag": matchorig_flag,
        "help_flag": help_flag,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if iterations is not None:
        params["iterations"] = iterations
    if mask_dataset is not None:
        params["mask_dataset"] = mask_dataset
    if sigma1 is not None:
        params["sigma1"] = sigma1
    if sigma2 is not None:
        params["sigma2"] = sigma2
    if deltat is not None:
        params["deltat"] = deltat
    if setneg_value is not None:
        params["setneg_value"] = setneg_value
    if edgefraction is not None:
        params["edgefraction"] = edgefraction
    if datum_type is not None:
        params["datum_type"] = datum_type
    return params


def v_3danisosmooth_cargs(
    params: V3danisosmoothParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3danisosmooth")
    cargs.append(execution.input_file(params.get("input_dataset", None)))
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("iterations", None) is not None:
        cargs.extend([
            "-iters",
            str(params.get("iterations", None))
        ])
    if params.get("2d_flag", False):
        cargs.append("-2D")
    if params.get("3d_flag", False):
        cargs.append("-3D")
    if params.get("mask_dataset", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask_dataset", None))
        ])
    if params.get("automask_flag", False):
        cargs.append("-automask")
    if params.get("viewer_flag", False):
        cargs.append("-viewer")
    if params.get("nosmooth_flag", False):
        cargs.append("-nosmooth")
    if params.get("sigma1", None) is not None:
        cargs.extend([
            "-sigma1",
            str(params.get("sigma1", None))
        ])
    if params.get("sigma2", None) is not None:
        cargs.extend([
            "-sigma2",
            str(params.get("sigma2", None))
        ])
    if params.get("deltat", None) is not None:
        cargs.extend([
            "-deltat",
            str(params.get("deltat", None))
        ])
    if params.get("savetempdata_flag", False):
        cargs.append("-savetempdata")
    if params.get("save_temp_with_diff_measures_flag", False):
        cargs.append("-save_temp_with_diff_measures")
    if params.get("phiding_flag", False):
        cargs.append("-phiding")
    if params.get("phiexp_flag", False):
        cargs.append("-phiexp")
    if params.get("noneg_flag", False):
        cargs.append("-noneg")
    if params.get("setneg_value", None) is not None:
        cargs.extend([
            "-setneg",
            str(params.get("setneg_value", None))
        ])
    if params.get("edgefraction", None) is not None:
        cargs.extend([
            "-edgefraction",
            str(params.get("edgefraction", None))
        ])
    if params.get("datum_type", None) is not None:
        cargs.extend([
            "-datum",
            params.get("datum_type", None)
        ])
    if params.get("matchorig_flag", False):
        cargs.append("-matchorig")
    if params.get("help_flag", False):
        cargs.append("-help")
    return cargs


def v_3danisosmooth_outputs(
    params: V3danisosmoothParameters,
    execution: Execution,
) -> V3danisosmoothOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3danisosmoothOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file(params.get("prefix", None) + "+smooth") if (params.get("prefix") is not None) else None,
        gradient_data=execution.output_file("Gradient.ITER"),
        eigens_data=execution.output_file("Eigens.ITER"),
        phi_data=execution.output_file("phi.ITER"),
        dtensor_data=execution.output_file("Dtensor.ITER"),
        ematrix_data=execution.output_file("Ematrix.ITER"),
        flux_data=execution.output_file("Flux.ITER"),
        gmatrix_data=execution.output_file("Gmatrix.ITER"),
        diff_measures_data=execution.output_file("Diff_measures.ITER"),
    )
    return ret


def v_3danisosmooth_execute(
    params: V3danisosmoothParameters,
    runner: Runner | None = None,
) -> V3danisosmoothOutputs:
    """
    3danisosmooth
    
    Smooths a dataset using an anisotropic smoothing technique.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3danisosmoothOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DANISOSMOOTH_METADATA)
    params = execution.params(params)
    cargs = v_3danisosmooth_cargs(params, execution)
    ret = v_3danisosmooth_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3danisosmooth(
    input_dataset: InputPathType,
    prefix: str | None = None,
    iterations: float | None = None,
    v_2d_flag: bool = False,
    v_3d_flag: bool = False,
    mask_dataset: InputPathType | None = None,
    automask_flag: bool = False,
    viewer_flag: bool = False,
    nosmooth_flag: bool = False,
    sigma1: float | None = None,
    sigma2: float | None = None,
    deltat: float | None = None,
    savetempdata_flag: bool = False,
    save_temp_with_diff_measures_flag: bool = False,
    phiding_flag: bool = False,
    phiexp_flag: bool = False,
    noneg_flag: bool = False,
    setneg_value: float | None = None,
    edgefraction: float | None = None,
    datum_type: str | None = None,
    matchorig_flag: bool = False,
    help_flag: bool = False,
    runner: Runner | None = None,
) -> V3danisosmoothOutputs:
    """
    3danisosmooth
    
    Smooths a dataset using an anisotropic smoothing technique.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Input dataset to be smoothed.
        prefix: Output dataset prefix name.
        iterations: Number of iterations (default=10).
        v_2d_flag: Smooth a slice at a time (default).
        v_3d_flag: Smooth through slices.
        mask_dataset: Use specified dataset as mask to include/exclude voxels.
        automask_flag: Automatically compute mask for dataset.
        viewer_flag: Show central axial slice image every iteration.
        nosmooth_flag: Do not do intermediate smoothing of gradients.
        sigma1: Gaussian smoothing sigma before gradient computation\
            (default=0.5).
        sigma2: Gaussian smoothing sigma after gradient computation\
            (default=1.0).
        deltat: Pseudo-time step (default=0.25).
        savetempdata_flag: Save temporary datasets each iteration.
        save_temp_with_diff_measures_flag: Save temporary datasets with\
            different measures in a dataset.
        phiding_flag: Use Ding method for computing phi (default).
        phiexp_flag: Use exponential method for computing phi.
        noneg_flag: Set negative voxels to 0.
        setneg_value: Set negative voxels to specified value.
        edgefraction: Adjust the fraction of the anisotropic component added (0\
            to 1, default=0.5).
        datum_type: Specify type for output data (byte, short, float)\
            [default=float].
        matchorig_flag: Match datum type and clip min/max to input data.
        help_flag: Print help message.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3danisosmoothOutputs`).
    """
    params = v_3danisosmooth_params(
        input_dataset=input_dataset,
        prefix=prefix,
        iterations=iterations,
        v_2d_flag=v_2d_flag,
        v_3d_flag=v_3d_flag,
        mask_dataset=mask_dataset,
        automask_flag=automask_flag,
        viewer_flag=viewer_flag,
        nosmooth_flag=nosmooth_flag,
        sigma1=sigma1,
        sigma2=sigma2,
        deltat=deltat,
        savetempdata_flag=savetempdata_flag,
        save_temp_with_diff_measures_flag=save_temp_with_diff_measures_flag,
        phiding_flag=phiding_flag,
        phiexp_flag=phiexp_flag,
        noneg_flag=noneg_flag,
        setneg_value=setneg_value,
        edgefraction=edgefraction,
        datum_type=datum_type,
        matchorig_flag=matchorig_flag,
        help_flag=help_flag,
    )
    return v_3danisosmooth_execute(params, runner)


__all__ = [
    "V3danisosmoothOutputs",
    "V_3DANISOSMOOTH_METADATA",
    "v_3danisosmooth",
    "v_3danisosmooth_execute",
    "v_3danisosmooth_params",
]
