# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DBUCKET_METADATA = Metadata(
    id="e8cc2881149d3136709a0708be9b84949d81918c.boutiques",
    name="3dbucket",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dbucketParameters = typing.TypedDict('V3dbucketParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dbucket"]],
    "prefix": typing.NotRequired[str | None],
    "output": typing.NotRequired[str | None],
    "session": typing.NotRequired[str | None],
    "glueto": typing.NotRequired[str | None],
    "aglueto": typing.NotRequired[str | None],
    "dry": bool,
    "verbose": bool,
    "fbuc": bool,
    "abuc": bool,
    "input_files": list[str],
})
V3dbucketParametersTagged = typing.TypedDict('V3dbucketParametersTagged', {
    "@type": typing.Literal["afni/3dbucket"],
    "prefix": typing.NotRequired[str | None],
    "output": typing.NotRequired[str | None],
    "session": typing.NotRequired[str | None],
    "glueto": typing.NotRequired[str | None],
    "aglueto": typing.NotRequired[str | None],
    "dry": bool,
    "verbose": bool,
    "fbuc": bool,
    "abuc": bool,
    "input_files": list[str],
})


class V3dbucketOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dbucketParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3dbucket_params(
    input_files: list[str],
    prefix: str | None = None,
    output: str | None = None,
    session: str | None = None,
    glueto: str | None = None,
    aglueto: str | None = None,
    dry: bool = False,
    verbose: bool = False,
    fbuc: bool = False,
    abuc: bool = False,
) -> V3dbucketParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: Input datasets with optional sub-brick selection.
        prefix: Use 'pname' for the output dataset prefix name.
        output: Use 'pname' for the output dataset prefix name.
        session: Use 'dir' for the output dataset session directory.\
            [default='./'=current working directory].
        glueto: Append bricks to the end of the 'fname' dataset.
        aglueto: If fname dataset does not exist, create it (like -prefix).\
            Otherwise append to fname (like -glueto).
        dry: Execute a 'dry run'; only print out what would be done.
        verbose: Print out some verbose output as the program proceeds.
        fbuc: Create a functional bucket.
        abuc: Create an anatomical bucket. If neither of these options is\
            given, the output type is determined from the first input type.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dbucket",
        "dry": dry,
        "verbose": verbose,
        "fbuc": fbuc,
        "abuc": abuc,
        "input_files": input_files,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if output is not None:
        params["output"] = output
    if session is not None:
        params["session"] = session
    if glueto is not None:
        params["glueto"] = glueto
    if aglueto is not None:
        params["aglueto"] = aglueto
    return params


def v_3dbucket_cargs(
    params: V3dbucketParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dbucket")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("output", None) is not None:
        cargs.extend([
            "-output",
            params.get("output", None)
        ])
    if params.get("session", None) is not None:
        cargs.extend([
            "-session",
            params.get("session", None)
        ])
    if params.get("glueto", None) is not None:
        cargs.extend([
            "-glueto",
            params.get("glueto", None)
        ])
    if params.get("aglueto", None) is not None:
        cargs.extend([
            "-aglueto",
            params.get("aglueto", None)
        ])
    if params.get("dry", False):
        cargs.append("-dry")
    if params.get("verbose", False):
        cargs.append("-verb")
    if params.get("fbuc", False):
        cargs.append("-fbuc")
    if params.get("abuc", False):
        cargs.append("-abuc")
    cargs.extend(params.get("input_files", None))
    return cargs


def v_3dbucket_outputs(
    params: V3dbucketParameters,
    execution: Execution,
) -> V3dbucketOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dbucketOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3dbucket_execute(
    params: V3dbucketParameters,
    runner: Runner | None = None,
) -> V3dbucketOutputs:
    """
    3dbucket
    
    Concatenate sub-bricks from input datasets into one big bucket dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dbucketOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DBUCKET_METADATA)
    params = execution.params(params)
    cargs = v_3dbucket_cargs(params, execution)
    ret = v_3dbucket_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dbucket(
    input_files: list[str],
    prefix: str | None = None,
    output: str | None = None,
    session: str | None = None,
    glueto: str | None = None,
    aglueto: str | None = None,
    dry: bool = False,
    verbose: bool = False,
    fbuc: bool = False,
    abuc: bool = False,
    runner: Runner | None = None,
) -> V3dbucketOutputs:
    """
    3dbucket
    
    Concatenate sub-bricks from input datasets into one big bucket dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input datasets with optional sub-brick selection.
        prefix: Use 'pname' for the output dataset prefix name.
        output: Use 'pname' for the output dataset prefix name.
        session: Use 'dir' for the output dataset session directory.\
            [default='./'=current working directory].
        glueto: Append bricks to the end of the 'fname' dataset.
        aglueto: If fname dataset does not exist, create it (like -prefix).\
            Otherwise append to fname (like -glueto).
        dry: Execute a 'dry run'; only print out what would be done.
        verbose: Print out some verbose output as the program proceeds.
        fbuc: Create a functional bucket.
        abuc: Create an anatomical bucket. If neither of these options is\
            given, the output type is determined from the first input type.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dbucketOutputs`).
    """
    params = v_3dbucket_params(
        prefix=prefix,
        output=output,
        session=session,
        glueto=glueto,
        aglueto=aglueto,
        dry=dry,
        verbose=verbose,
        fbuc=fbuc,
        abuc=abuc,
        input_files=input_files,
    )
    return v_3dbucket_execute(params, runner)


__all__ = [
    "V3dbucketOutputs",
    "V_3DBUCKET_METADATA",
    "v_3dbucket",
    "v_3dbucket_execute",
    "v_3dbucket_params",
]
