# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DCOPY_METADATA = Metadata(
    id="b76c4eb6f3fedeb1f796f98fbebf2944bc361657.boutiques",
    name="3dcopy",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dcopyParameters = typing.TypedDict('V3dcopyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dcopy"]],
    "verbose": bool,
    "denote": bool,
    "old_prefix": str,
    "view": typing.NotRequired[str | None],
    "new_prefix": str,
})
V3dcopyParametersTagged = typing.TypedDict('V3dcopyParametersTagged', {
    "@type": typing.Literal["afni/3dcopy"],
    "verbose": bool,
    "denote": bool,
    "old_prefix": str,
    "view": typing.NotRequired[str | None],
    "new_prefix": str,
})


class V3dcopyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dcopyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3dcopy_params(
    old_prefix: str,
    new_prefix: str,
    verbose: bool = False,
    denote: bool = False,
    view: str | None = None,
) -> V3dcopyParametersTagged:
    """
    Build parameters.
    
    Args:
        old_prefix: Old dataset prefix (and view if specific dataset view is to\
            be copied).
        new_prefix: New dataset prefix or directory path.
        verbose: Print progress reports.
        denote: Remove any Notes from the file.
        view: Specified view (orig, acpc, tlrc).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dcopy",
        "verbose": verbose,
        "denote": denote,
        "old_prefix": old_prefix,
        "new_prefix": new_prefix,
    }
    if view is not None:
        params["view"] = view
    return params


def v_3dcopy_cargs(
    params: V3dcopyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dcopy")
    if params.get("verbose", False):
        cargs.append("-verb")
    if params.get("denote", False):
        cargs.append("-denote")
    if params.get("view", None) is not None:
        cargs.extend([
            "+",
            params.get("old_prefix", None) + params.get("view", None)
        ])
    cargs.append(params.get("new_prefix", None))
    return cargs


def v_3dcopy_outputs(
    params: V3dcopyParameters,
    execution: Execution,
) -> V3dcopyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dcopyOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3dcopy_execute(
    params: V3dcopyParameters,
    runner: Runner | None = None,
) -> V3dcopyOutputs:
    """
    3dcopy
    
    3dcopy copies datasets with or without altering prefixes and converting
    formats.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dcopyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DCOPY_METADATA)
    params = execution.params(params)
    cargs = v_3dcopy_cargs(params, execution)
    ret = v_3dcopy_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dcopy(
    old_prefix: str,
    new_prefix: str,
    verbose: bool = False,
    denote: bool = False,
    view: str | None = None,
    runner: Runner | None = None,
) -> V3dcopyOutputs:
    """
    3dcopy
    
    3dcopy copies datasets with or without altering prefixes and converting
    formats.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        old_prefix: Old dataset prefix (and view if specific dataset view is to\
            be copied).
        new_prefix: New dataset prefix or directory path.
        verbose: Print progress reports.
        denote: Remove any Notes from the file.
        view: Specified view (orig, acpc, tlrc).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dcopyOutputs`).
    """
    params = v_3dcopy_params(
        verbose=verbose,
        denote=denote,
        old_prefix=old_prefix,
        view=view,
        new_prefix=new_prefix,
    )
    return v_3dcopy_execute(params, runner)


__all__ = [
    "V3dcopyOutputs",
    "V_3DCOPY_METADATA",
    "v_3dcopy",
    "v_3dcopy_execute",
    "v_3dcopy_params",
]
