# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DDOT_BETA_METADATA = Metadata(
    id="29f85c73d1e8013050b3f32ac425b1405e6a97d0.boutiques",
    name="3ddot_beta",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3ddotBetaParameters = typing.TypedDict('V3ddotBetaParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3ddot_beta"]],
    "input_file": InputPathType,
    "prefix": str,
    "doeta2": bool,
    "mask": typing.NotRequired[InputPathType | None],
})
V3ddotBetaParametersTagged = typing.TypedDict('V3ddotBetaParametersTagged', {
    "@type": typing.Literal["afni/3ddot_beta"],
    "input_file": InputPathType,
    "prefix": str,
    "doeta2": bool,
    "mask": typing.NotRequired[InputPathType | None],
})


class V3ddotBetaOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3ddotBetaParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Output text file containing the correlation-like matrix"""


def v_3ddot_beta_params(
    input_file: InputPathType,
    prefix: str,
    doeta2: bool = False,
    mask: InputPathType | None = None,
) -> V3ddotBetaParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Input file with N bricks.
        prefix: Output prefix for the result file.
        doeta2: Required flag for performing eta2 tests.
        mask: Optional mask file within which to take values.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3ddot_beta",
        "input_file": input_file,
        "prefix": prefix,
        "doeta2": doeta2,
    }
    if mask is not None:
        params["mask"] = mask
    return params


def v_3ddot_beta_cargs(
    params: V3ddotBetaParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3ddot_beta")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("doeta2", False):
        cargs.append("-doeta2")
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    return cargs


def v_3ddot_beta_outputs(
    params: V3ddotBetaParameters,
    execution: Execution,
) -> V3ddotBetaOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3ddotBetaOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix", None) + "_eta2.dat"),
    )
    return ret


def v_3ddot_beta_execute(
    params: V3ddotBetaParameters,
    runner: Runner | None = None,
) -> V3ddotBetaOutputs:
    """
    3ddot_beta
    
    Beta version of updating 3ddot, currently only performing eta2 tests and
    outputting a full matrix to a text file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3ddotBetaOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DDOT_BETA_METADATA)
    params = execution.params(params)
    cargs = v_3ddot_beta_cargs(params, execution)
    ret = v_3ddot_beta_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3ddot_beta(
    input_file: InputPathType,
    prefix: str,
    doeta2: bool = False,
    mask: InputPathType | None = None,
    runner: Runner | None = None,
) -> V3ddotBetaOutputs:
    """
    3ddot_beta
    
    Beta version of updating 3ddot, currently only performing eta2 tests and
    outputting a full matrix to a text file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Input file with N bricks.
        prefix: Output prefix for the result file.
        doeta2: Required flag for performing eta2 tests.
        mask: Optional mask file within which to take values.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3ddotBetaOutputs`).
    """
    params = v_3ddot_beta_params(
        input_file=input_file,
        prefix=prefix,
        doeta2=doeta2,
        mask=mask,
    )
    return v_3ddot_beta_execute(params, runner)


__all__ = [
    "V3ddotBetaOutputs",
    "V_3DDOT_BETA_METADATA",
    "v_3ddot_beta",
    "v_3ddot_beta_execute",
    "v_3ddot_beta_params",
]
