# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DHISTOG_METADATA = Metadata(
    id="24d0ff6d7c8b05720aa5aa52e4f3d4acbfcf0ae4.boutiques",
    name="3dhistog",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dhistogParameters = typing.TypedDict('V3dhistogParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dhistog"]],
    "dataset": InputPathType,
    "nbin": typing.NotRequired[float | None],
    "dind": typing.NotRequired[float | None],
    "omit": typing.NotRequired[list[float] | None],
    "mask": typing.NotRequired[InputPathType | None],
    "roi_mask": typing.NotRequired[InputPathType | None],
    "doall": bool,
    "noempty": bool,
    "notitle": bool,
    "log10": bool,
    "pdf": bool,
    "min": typing.NotRequired[float | None],
    "max": typing.NotRequired[float | None],
    "igfac": bool,
    "int": bool,
    "float": bool,
    "unq": typing.NotRequired[str | None],
    "prefix": typing.NotRequired[str | None],
})
V3dhistogParametersTagged = typing.TypedDict('V3dhistogParametersTagged', {
    "@type": typing.Literal["afni/3dhistog"],
    "dataset": InputPathType,
    "nbin": typing.NotRequired[float | None],
    "dind": typing.NotRequired[float | None],
    "omit": typing.NotRequired[list[float] | None],
    "mask": typing.NotRequired[InputPathType | None],
    "roi_mask": typing.NotRequired[InputPathType | None],
    "doall": bool,
    "noempty": bool,
    "notitle": bool,
    "log10": bool,
    "pdf": bool,
    "min": typing.NotRequired[float | None],
    "max": typing.NotRequired[float | None],
    "igfac": bool,
    "int": bool,
    "float": bool,
    "unq": typing.NotRequired[str | None],
    "prefix": typing.NotRequired[str | None],
})


class V3dhistogOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dhistogParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    histogram_output: OutputPathType
    """Histogram output when -prefix option is used"""


def v_3dhistog_params(
    dataset: InputPathType,
    nbin: float | None = None,
    dind: float | None = None,
    omit: list[float] | None = None,
    mask: InputPathType | None = None,
    roi_mask: InputPathType | None = None,
    doall: bool = False,
    noempty: bool = False,
    notitle: bool = False,
    log10: bool = False,
    pdf: bool = False,
    min_: float | None = None,
    max_: float | None = None,
    igfac: bool = False,
    int_: bool = False,
    float_: bool = False,
    unq: str | None = None,
    prefix: str | None = None,
) -> V3dhistogParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: Input dataset.
        nbin: Use specified number of bins.
        dind: Use data from specified sub-brick index.
        omit: Omit specified value from the count.
        mask: Use mask dataset to determine which voxels to use.
        roi_mask: Create histogram for each non-zero value in 'r' dataset.
        doall: Include all sub-bricks in the calculation.
        noempty: Only output bins that are not empty.
        notitle: Leave the title line off the output.
        log10: Output log10() of the counts.
        pdf: Output the counts divided by the number of samples.
        min_: Specify minimum (inclusive) of histogram.
        max_: Specify maximum (inclusive) of histogram.
        igfac: Ignore sub-brick scale factors and histogram-ize the 'raw' data.
        int_: Treat data and output as integers.
        float_: Treat data and output as floats.
        unq: Writes out the sorted unique values to file.
        prefix: Write a copy of the histogram into specified file.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dhistog",
        "dataset": dataset,
        "doall": doall,
        "noempty": noempty,
        "notitle": notitle,
        "log10": log10,
        "pdf": pdf,
        "igfac": igfac,
        "int": int_,
        "float": float_,
    }
    if nbin is not None:
        params["nbin"] = nbin
    if dind is not None:
        params["dind"] = dind
    if omit is not None:
        params["omit"] = omit
    if mask is not None:
        params["mask"] = mask
    if roi_mask is not None:
        params["roi_mask"] = roi_mask
    if min_ is not None:
        params["min"] = min_
    if max_ is not None:
        params["max"] = max_
    if unq is not None:
        params["unq"] = unq
    if prefix is not None:
        params["prefix"] = prefix
    return params


def v_3dhistog_cargs(
    params: V3dhistogParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dhistog")
    cargs.append(execution.input_file(params.get("dataset", None)))
    if params.get("nbin", None) is not None:
        cargs.extend([
            "-nbin",
            str(params.get("nbin", None))
        ])
    if params.get("dind", None) is not None:
        cargs.extend([
            "-dind",
            str(params.get("dind", None))
        ])
    if params.get("omit", None) is not None:
        cargs.extend([
            "-omit",
            *map(str, params.get("omit", None))
        ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("roi_mask", None) is not None:
        cargs.extend([
            "-roi_mask",
            execution.input_file(params.get("roi_mask", None))
        ])
    if params.get("doall", False):
        cargs.append("-doall")
    if params.get("noempty", False):
        cargs.append("-noempty")
    if params.get("notitle", False):
        cargs.append("-notitle")
    if params.get("log10", False):
        cargs.append("-log10")
    if params.get("pdf", False):
        cargs.append("-pdf")
    if params.get("min", None) is not None:
        cargs.extend([
            "-min",
            str(params.get("min", None))
        ])
    if params.get("max", None) is not None:
        cargs.extend([
            "-max",
            str(params.get("max", None))
        ])
    if params.get("igfac", False):
        cargs.append("-igfac")
    if params.get("int", False):
        cargs.append("-int")
    if params.get("float", False):
        cargs.append("-float")
    if params.get("unq", None) is not None:
        cargs.extend([
            "-unq",
            params.get("unq", None)
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    return cargs


def v_3dhistog_outputs(
    params: V3dhistogParameters,
    execution: Execution,
) -> V3dhistogOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dhistogOutputs(
        root=execution.output_file("."),
        histogram_output=execution.output_file("HOUT.1D"),
    )
    return ret


def v_3dhistog_execute(
    params: V3dhistogParameters,
    runner: Runner | None = None,
) -> V3dhistogOutputs:
    """
    3dhistog
    
    Compute histogram of a 3D dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dhistogOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DHISTOG_METADATA)
    params = execution.params(params)
    cargs = v_3dhistog_cargs(params, execution)
    ret = v_3dhistog_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dhistog(
    dataset: InputPathType,
    nbin: float | None = None,
    dind: float | None = None,
    omit: list[float] | None = None,
    mask: InputPathType | None = None,
    roi_mask: InputPathType | None = None,
    doall: bool = False,
    noempty: bool = False,
    notitle: bool = False,
    log10: bool = False,
    pdf: bool = False,
    min_: float | None = None,
    max_: float | None = None,
    igfac: bool = False,
    int_: bool = False,
    float_: bool = False,
    unq: str | None = None,
    prefix: str | None = None,
    runner: Runner | None = None,
) -> V3dhistogOutputs:
    """
    3dhistog
    
    Compute histogram of a 3D dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input dataset.
        nbin: Use specified number of bins.
        dind: Use data from specified sub-brick index.
        omit: Omit specified value from the count.
        mask: Use mask dataset to determine which voxels to use.
        roi_mask: Create histogram for each non-zero value in 'r' dataset.
        doall: Include all sub-bricks in the calculation.
        noempty: Only output bins that are not empty.
        notitle: Leave the title line off the output.
        log10: Output log10() of the counts.
        pdf: Output the counts divided by the number of samples.
        min_: Specify minimum (inclusive) of histogram.
        max_: Specify maximum (inclusive) of histogram.
        igfac: Ignore sub-brick scale factors and histogram-ize the 'raw' data.
        int_: Treat data and output as integers.
        float_: Treat data and output as floats.
        unq: Writes out the sorted unique values to file.
        prefix: Write a copy of the histogram into specified file.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dhistogOutputs`).
    """
    params = v_3dhistog_params(
        dataset=dataset,
        nbin=nbin,
        dind=dind,
        omit=omit,
        mask=mask,
        roi_mask=roi_mask,
        doall=doall,
        noempty=noempty,
        notitle=notitle,
        log10=log10,
        pdf=pdf,
        min_=min_,
        max_=max_,
        igfac=igfac,
        int_=int_,
        float_=float_,
        unq=unq,
        prefix=prefix,
    )
    return v_3dhistog_execute(params, runner)


__all__ = [
    "V3dhistogOutputs",
    "V_3DHISTOG_METADATA",
    "v_3dhistog",
    "v_3dhistog_execute",
    "v_3dhistog_params",
]
