# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DINFILL_METADATA = Metadata(
    id="7c02b47d67b1f7d68e47ba9a754a7865584a2b99.boutiques",
    name="3dinfill",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dinfillParameters = typing.TypedDict('V3dinfillParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dinfill"]],
    "input": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "niter": typing.NotRequired[float | None],
    "blend": typing.NotRequired[typing.Literal["MODE", "AVG", "AUTO", "SOLID", "SOLID_CLEAN"] | None],
    "minhits": typing.NotRequired[float | None],
    "ed": typing.NotRequired[list[float] | None],
    "mask": typing.NotRequired[InputPathType | None],
    "mask_range": typing.NotRequired[list[float] | None],
    "mrange": typing.NotRequired[list[float] | None],
    "cmask": typing.NotRequired[str | None],
})
V3dinfillParametersTagged = typing.TypedDict('V3dinfillParametersTagged', {
    "@type": typing.Literal["afni/3dinfill"],
    "input": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "niter": typing.NotRequired[float | None],
    "blend": typing.NotRequired[typing.Literal["MODE", "AVG", "AUTO", "SOLID", "SOLID_CLEAN"] | None],
    "minhits": typing.NotRequired[float | None],
    "ed": typing.NotRequired[list[float] | None],
    "mask": typing.NotRequired[InputPathType | None],
    "mask_range": typing.NotRequired[list[float] | None],
    "mrange": typing.NotRequired[list[float] | None],
    "cmask": typing.NotRequired[str | None],
})


class V3dinfillOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dinfillParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_filled: OutputPathType | None
    """Filled volume output"""


def v_3dinfill_params(
    input_: InputPathType,
    prefix: str | None = None,
    niter: float | None = None,
    blend: typing.Literal["MODE", "AVG", "AUTO", "SOLID", "SOLID_CLEAN"] | None = None,
    minhits: float | None = None,
    ed: list[float] | None = None,
    mask: InputPathType | None = None,
    mask_range: list[float] | None = None,
    mrange: list[float] | None = None,
    cmask: str | None = None,
) -> V3dinfillParametersTagged:
    """
    Build parameters.
    
    Args:
        input_: Fill volume dataset.
        prefix: Use PREF for output prefix.
        niter: Do not allow the fill function to do more than NITER passes.
        blend: Method for assigning a value to a hole.
        minhits: Criterion for considering a zero voxel to be a hole. Can only\
            be used with -blend SOLID.
        ed: Erode N times then dilate N times to get rid of hanging chunks.\
            Values filled in by this process get value V.
        mask: Provide mask dataset to select subset of input.
        mask_range: Specify the range of values to consider from mask dataset.
        mrange: Alias for -mask_range option.
        cmask: Provide cmask expression. Voxels where expression is 0 are\
            excluded from computations.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dinfill",
        "input": input_,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if niter is not None:
        params["niter"] = niter
    if blend is not None:
        params["blend"] = blend
    if minhits is not None:
        params["minhits"] = minhits
    if ed is not None:
        params["ed"] = ed
    if mask is not None:
        params["mask"] = mask
    if mask_range is not None:
        params["mask_range"] = mask_range
    if mrange is not None:
        params["mrange"] = mrange
    if cmask is not None:
        params["cmask"] = cmask
    return params


def v_3dinfill_cargs(
    params: V3dinfillParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dinfill")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input", None))
    ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("niter", None) is not None:
        cargs.extend([
            "-Niter",
            str(params.get("niter", None))
        ])
    if params.get("blend", None) is not None:
        cargs.extend([
            "-blend",
            params.get("blend", None)
        ])
    if params.get("minhits", None) is not None:
        cargs.extend([
            "-minhits",
            str(params.get("minhits", None))
        ])
    if params.get("ed", None) is not None:
        cargs.extend([
            "-ed",
            *map(str, params.get("ed", None))
        ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("mask_range", None) is not None:
        cargs.extend([
            "-mask_range",
            *map(str, params.get("mask_range", None))
        ])
    if params.get("mrange", None) is not None:
        cargs.extend([
            "-mrange",
            *map(str, params.get("mrange", None))
        ])
    if params.get("cmask", None) is not None:
        cargs.extend([
            "-cmask",
            params.get("cmask", None)
        ])
    return cargs


def v_3dinfill_outputs(
    params: V3dinfillParameters,
    execution: Execution,
) -> V3dinfillOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dinfillOutputs(
        root=execution.output_file("."),
        output_filled=execution.output_file(params.get("prefix", None) + "_filled.nii.gz") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3dinfill_execute(
    params: V3dinfillParameters,
    runner: Runner | None = None,
) -> V3dinfillOutputs:
    """
    3dinfill
    
    A program to fill holes in volumes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dinfillOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DINFILL_METADATA)
    params = execution.params(params)
    cargs = v_3dinfill_cargs(params, execution)
    ret = v_3dinfill_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dinfill(
    input_: InputPathType,
    prefix: str | None = None,
    niter: float | None = None,
    blend: typing.Literal["MODE", "AVG", "AUTO", "SOLID", "SOLID_CLEAN"] | None = None,
    minhits: float | None = None,
    ed: list[float] | None = None,
    mask: InputPathType | None = None,
    mask_range: list[float] | None = None,
    mrange: list[float] | None = None,
    cmask: str | None = None,
    runner: Runner | None = None,
) -> V3dinfillOutputs:
    """
    3dinfill
    
    A program to fill holes in volumes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_: Fill volume dataset.
        prefix: Use PREF for output prefix.
        niter: Do not allow the fill function to do more than NITER passes.
        blend: Method for assigning a value to a hole.
        minhits: Criterion for considering a zero voxel to be a hole. Can only\
            be used with -blend SOLID.
        ed: Erode N times then dilate N times to get rid of hanging chunks.\
            Values filled in by this process get value V.
        mask: Provide mask dataset to select subset of input.
        mask_range: Specify the range of values to consider from mask dataset.
        mrange: Alias for -mask_range option.
        cmask: Provide cmask expression. Voxels where expression is 0 are\
            excluded from computations.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dinfillOutputs`).
    """
    params = v_3dinfill_params(
        input_=input_,
        prefix=prefix,
        niter=niter,
        blend=blend,
        minhits=minhits,
        ed=ed,
        mask=mask,
        mask_range=mask_range,
        mrange=mrange,
        cmask=cmask,
    )
    return v_3dinfill_execute(params, runner)


__all__ = [
    "V3dinfillOutputs",
    "V_3DINFILL_METADATA",
    "v_3dinfill",
    "v_3dinfill_execute",
    "v_3dinfill_params",
]
