# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DINFO_METADATA = Metadata(
    id="9ef9b03b6039458b0a98cada644ac698c6387f71.boutiques",
    name="3dinfo",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dinfoParameters = typing.TypedDict('V3dinfoParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dinfo"]],
    "orient": bool,
    "Lextent": bool,
    "Rextent": bool,
    "Aextent": bool,
    "Pextent": bool,
    "Iextent": bool,
    "Sextent": bool,
    "all_names": bool,
    "verb": bool,
    "very_verbose": bool,
    "short": bool,
    "no_hist": bool,
    "h": bool,
    "help": bool,
    "extreme_help": bool,
    "h_view": bool,
    "h_web": bool,
    "h_find": typing.NotRequired[str | None],
    "h_raw": bool,
    "h_spx": bool,
    "h_aspx": bool,
    "all_opts": bool,
    "label2index": typing.NotRequired[str | None],
    "niml_hdr": bool,
    "subbrick_info": bool,
    "exists": bool,
    "id": bool,
    "is_atlas": bool,
    "is_atlas_or_labeltable": bool,
    "is_nifti": bool,
    "dset_extension": bool,
    "storage_mode": bool,
    "space": bool,
    "gen_space": bool,
    "av_space": bool,
    "nifti_code": bool,
    "is_oblique": bool,
    "handedness": bool,
    "obliquity": bool,
    "prefix": bool,
    "prefix_noext": bool,
    "ni": bool,
    "nj": bool,
    "nk": bool,
    "nijk": bool,
    "nv": bool,
    "nt": bool,
    "n4": bool,
    "nvi": bool,
    "nti": bool,
    "ntimes": bool,
    "max_node": bool,
    "di": bool,
    "dj": bool,
    "dk": bool,
    "d3": bool,
    "adi": bool,
    "adj": bool,
    "adk": bool,
    "ad3": bool,
    "voxvol": bool,
    "oi": bool,
    "oj": bool,
    "ok": bool,
    "o3": bool,
    "dcx": bool,
    "dcy": bool,
    "dcz": bool,
    "dc3": bool,
    "tr": bool,
    "dmin": bool,
    "dmax": bool,
    "dminus": bool,
    "dmaxus": bool,
    "smode": bool,
    "header_name": bool,
    "brick_name": bool,
    "iname": bool,
    "extent": bool,
    "fac": bool,
    "label": bool,
    "datum": bool,
    "min": bool,
    "max": bool,
    "minus": bool,
    "maxus": bool,
    "labeltable": bool,
    "labeltable_as_atlas_points": bool,
    "atlas_points": bool,
    "history": bool,
    "slice_timing": bool,
    "header_line": bool,
    "hdr": bool,
    "sb_delim": typing.NotRequired[str | None],
    "NA_flag": typing.NotRequired[str | None],
    "atr_delim": typing.NotRequired[str | None],
    "aform_real": bool,
    "aform_real_oneline": bool,
    "aform_real_refit_ori": bool,
    "is_aform_real_orth": bool,
    "aform_orth": bool,
    "perm_to_orient": typing.NotRequired[str | None],
    "same_grid": bool,
    "same_dim": bool,
    "same_delta": bool,
    "same_orient": bool,
    "same_center": bool,
    "same_obl": bool,
    "same_all_grid": bool,
    "val_diff": bool,
    "sval_diff": bool,
    "monog_pairs": bool,
    "dataset": list[InputPathType],
})
V3dinfoParametersTagged = typing.TypedDict('V3dinfoParametersTagged', {
    "@type": typing.Literal["afni/3dinfo"],
    "orient": bool,
    "Lextent": bool,
    "Rextent": bool,
    "Aextent": bool,
    "Pextent": bool,
    "Iextent": bool,
    "Sextent": bool,
    "all_names": bool,
    "verb": bool,
    "very_verbose": bool,
    "short": bool,
    "no_hist": bool,
    "h": bool,
    "help": bool,
    "extreme_help": bool,
    "h_view": bool,
    "h_web": bool,
    "h_find": typing.NotRequired[str | None],
    "h_raw": bool,
    "h_spx": bool,
    "h_aspx": bool,
    "all_opts": bool,
    "label2index": typing.NotRequired[str | None],
    "niml_hdr": bool,
    "subbrick_info": bool,
    "exists": bool,
    "id": bool,
    "is_atlas": bool,
    "is_atlas_or_labeltable": bool,
    "is_nifti": bool,
    "dset_extension": bool,
    "storage_mode": bool,
    "space": bool,
    "gen_space": bool,
    "av_space": bool,
    "nifti_code": bool,
    "is_oblique": bool,
    "handedness": bool,
    "obliquity": bool,
    "prefix": bool,
    "prefix_noext": bool,
    "ni": bool,
    "nj": bool,
    "nk": bool,
    "nijk": bool,
    "nv": bool,
    "nt": bool,
    "n4": bool,
    "nvi": bool,
    "nti": bool,
    "ntimes": bool,
    "max_node": bool,
    "di": bool,
    "dj": bool,
    "dk": bool,
    "d3": bool,
    "adi": bool,
    "adj": bool,
    "adk": bool,
    "ad3": bool,
    "voxvol": bool,
    "oi": bool,
    "oj": bool,
    "ok": bool,
    "o3": bool,
    "dcx": bool,
    "dcy": bool,
    "dcz": bool,
    "dc3": bool,
    "tr": bool,
    "dmin": bool,
    "dmax": bool,
    "dminus": bool,
    "dmaxus": bool,
    "smode": bool,
    "header_name": bool,
    "brick_name": bool,
    "iname": bool,
    "extent": bool,
    "fac": bool,
    "label": bool,
    "datum": bool,
    "min": bool,
    "max": bool,
    "minus": bool,
    "maxus": bool,
    "labeltable": bool,
    "labeltable_as_atlas_points": bool,
    "atlas_points": bool,
    "history": bool,
    "slice_timing": bool,
    "header_line": bool,
    "hdr": bool,
    "sb_delim": typing.NotRequired[str | None],
    "NA_flag": typing.NotRequired[str | None],
    "atr_delim": typing.NotRequired[str | None],
    "aform_real": bool,
    "aform_real_oneline": bool,
    "aform_real_refit_ori": bool,
    "is_aform_real_orth": bool,
    "aform_orth": bool,
    "perm_to_orient": typing.NotRequired[str | None],
    "same_grid": bool,
    "same_dim": bool,
    "same_delta": bool,
    "same_orient": bool,
    "same_center": bool,
    "same_obl": bool,
    "same_all_grid": bool,
    "val_diff": bool,
    "sval_diff": bool,
    "monog_pairs": bool,
    "dataset": list[InputPathType],
})


class V3dinfoOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dinfoParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    info: list[str]
    """Sort-of-useful information from a 3D dataset's header"""


def v_3dinfo_params(
    dataset: list[InputPathType],
    orient: bool = False,
    lextent: bool = False,
    rextent: bool = False,
    aextent: bool = False,
    pextent: bool = False,
    iextent: bool = False,
    sextent: bool = False,
    all_names: bool = False,
    verb: bool = False,
    very_verbose: bool = False,
    short: bool = False,
    no_hist: bool = False,
    h: bool = False,
    help_: bool = False,
    extreme_help: bool = False,
    h_view: bool = False,
    h_web: bool = False,
    h_find: str | None = None,
    h_raw: bool = False,
    h_spx: bool = False,
    h_aspx: bool = False,
    all_opts: bool = False,
    label2index: str | None = None,
    niml_hdr: bool = False,
    subbrick_info: bool = False,
    exists: bool = False,
    id_: bool = False,
    is_atlas: bool = False,
    is_atlas_or_labeltable: bool = False,
    is_nifti: bool = False,
    dset_extension: bool = False,
    storage_mode: bool = False,
    space: bool = False,
    gen_space: bool = False,
    av_space: bool = False,
    nifti_code: bool = False,
    is_oblique: bool = False,
    handedness: bool = False,
    obliquity: bool = False,
    prefix: bool = False,
    prefix_noext: bool = False,
    ni: bool = False,
    nj: bool = False,
    nk: bool = False,
    nijk: bool = False,
    nv: bool = False,
    nt_: bool = False,
    n4: bool = False,
    nvi: bool = False,
    nti: bool = False,
    ntimes: bool = False,
    max_node: bool = False,
    di: bool = False,
    dj: bool = False,
    dk: bool = False,
    d3: bool = False,
    adi: bool = False,
    adj: bool = False,
    adk: bool = False,
    ad3: bool = False,
    voxvol: bool = False,
    oi: bool = False,
    oj: bool = False,
    ok: bool = False,
    o3: bool = False,
    dcx: bool = False,
    dcy: bool = False,
    dcz: bool = False,
    dc3: bool = False,
    tr: bool = False,
    dmin: bool = False,
    dmax: bool = False,
    dminus: bool = False,
    dmaxus: bool = False,
    smode: bool = False,
    header_name: bool = False,
    brick_name: bool = False,
    iname: bool = False,
    extent: bool = False,
    fac: bool = False,
    label: bool = False,
    datum: bool = False,
    min_: bool = False,
    max_: bool = False,
    minus: bool = False,
    maxus: bool = False,
    labeltable: bool = False,
    labeltable_as_atlas_points: bool = False,
    atlas_points: bool = False,
    history: bool = False,
    slice_timing: bool = False,
    header_line: bool = False,
    hdr: bool = False,
    sb_delim: str | None = None,
    na_flag: str | None = None,
    atr_delim: str | None = None,
    aform_real: bool = False,
    aform_real_oneline: bool = False,
    aform_real_refit_ori: bool = False,
    is_aform_real_orth: bool = False,
    aform_orth: bool = False,
    perm_to_orient: str | None = None,
    same_grid: bool = False,
    same_dim: bool = False,
    same_delta: bool = False,
    same_orient: bool = False,
    same_center: bool = False,
    same_obl: bool = False,
    same_all_grid: bool = False,
    val_diff: bool = False,
    sval_diff: bool = False,
    monog_pairs: bool = False,
) -> V3dinfoParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: Datasets to retrieve information from.
        orient: Value of orientation string. For example, LPI means: i\
            direction grows from Left(negative) to Right(positive). j direction\
            grows from Posterior (neg.) to Anterior (pos.) k direction grows from\
            Inferior (neg.) to Superior (pos.).
        lextent: Extent along L.
        rextent: Extent along R.
        aextent: Extent along A.
        pextent: Extent along P.
        iextent: Extent along I.
        sextent: Extent along S.
        all_names: Value of various dset structures handling filenames.
        verb: Print out lots of information.
        very_verbose: Print out even more information including slice time\
            offsets.
        short: Print out less information (default).
        no_hist: Omit the HISTORY text.
        h: Mini help.
        help_: Display entire help output.
        extreme_help: Extreme help.
        h_view: Open help in text editor.
        h_web: Open help in web browser.
        h_find: Look for lines in help output that match WORD.
        h_raw: Display unedited help string.
        h_spx: Help string in sphinx format without autoformatting options.
        h_aspx: Help string in sphinx format with autoformatting options.
        all_opts: Try to identify all options for the program from the help\
            output.
        label2index: Output index corresponding to label.
        niml_hdr: Output entire NIML-formatted header.
        subbrick_info: Output only sub-brick part of information.
        exists: 1 if dset is loadable, 0 otherwise. This works on prefix also.
        id_: Idcodestring of dset.
        is_atlas: 1 if dset is an atlas.
        is_atlas_or_labeltable: 1 if dset has an atlas or labeltable.
        is_nifti: 1 if dset is NIFTI format, 0 otherwise.
        dset_extension: Show filename extension for valid dataset (e.g.\
            .nii.gz).
        storage_mode: Show internal storage mode of dataset (e.g. NIFTI).
        space: Dataset's space.
        gen_space: Dataset's generic space.
        av_space: AFNI format's view extension for the space.
        nifti_code: What AFNI would use for an output NIFTI (q)sform_code.
        is_oblique: 1 if dset is oblique.
        handedness: L if orientation is Left handed, R if it is right handed.
        obliquity: Angle from plumb direction. Angles of 0 (or close) are for\
            cardinal orientations.
        prefix: Return the prefix.
        prefix_noext: Return the prefix without extensions.
        ni: Return the number of voxels in i dimension.
        nj: Return the number of voxels in j dimension.
        nk: Return the number of voxels in k dimension.
        nijk: Return ni*nj*nk.
        nv: Return number of points in time or the number of sub-bricks.
        nt_: Same as -nv.
        n4: Same as -ni -nj -nk -nv.
        nvi: The maximum sub-brick index (= nv -1 ).
        nti: Same as -nvi.
        ntimes: Return number of sub-bricks points in time. This is an option\
            for debugging use, stay away from it.
        max_node: For a surface-based dset, return the maximum node index.
        di: Signed displacement per voxel along i direction, aka dx.
        dj: Signed displacement per voxel along j direction, aka dy.
        dk: Signed displacement per voxel along k direction, aka dz.
        d3: Same as -di -dj -dk.
        adi: Voxel size along i direction (abs(di)).
        adj: Voxel size along j direction (abs(dj)).
        adk: Voxel size along k direction (abs(dk)).
        ad3: Same as -adi -adj -adk.
        voxvol: Voxel volume in cubic millimeters.
        oi: Volume origin along the i direction.
        oj: Volume origin along the j direction.
        ok: Volume origin along the k direction.
        o3: Same as -oi -oj -ok.
        dcx: Volumetric center in x direction (DICOM coordinates).
        dcy: Volumetric center in y direction (DICOM coordinates).
        dcz: Volumetric center in z direction (DICOM coordinates).
        dc3: Same as -dcx -dcy -dcz.
        tr: The TR value in seconds.
        dmin: The dataset's minimum value, scaled by fac.
        dmax: The dataset's maximum value, scaled by fac.
        dminus: The dataset's minimum value, unscaled.
        dmaxus: The dataset's maximum value, unscaled.
        smode: Dset storage mode string.
        header_name: Value of dset structure (sub)field 'header_name'.
        brick_name: Value of dset structure (sub)field 'brick_name'.
        iname: Name of dset as input on the command line.
        extent: The spatial extent of the dataset along R, L, A, P, I and S.
        fac: Return the float scaling factor.
        label: The label of each sub-brick.
        datum: The data storage type.
        min_: The minimum value, scaled by fac.
        max_: The maximum value, scaled by fac.
        minus: The minimum value, unscaled.
        maxus: The maximum value, unscaled.
        labeltable: Show label table, if any.
        labeltable_as_atlas_points: Show label table in atlas point format.
        atlas_points: Show atlas points list, if any.
        history: History note.
        slice_timing: Show slice timing.
        header_line: Output as the first line the names of attributes in each\
            field (column).
        hdr: Same as -header_line.
        sb_delim: Delimiter string between sub-brick values. Default SB_DELIM\
            is '|'.
        na_flag: String to use when a field is not found or not applicable.\
            Default is 'NA'.
        atr_delim: Delimiter string between attributes. Default ATR_DELIM is\
            the tab character.
        aform_real: Display full 3x4 'aform_real' matrix (AFNI's RAI equivalent\
            of the sform matrix in NIFTI, may contain obliquity info), with comment\
            line first.
        aform_real_oneline: Display full 'aform_real' matrix (see\
            '-aform_real') as 1 row of 12 numbers. No additional comment.
        aform_real_refit_ori: Display full 3x4 'aform_real' matrix (see\
            '-aform_real') *if* the dset were reoriented (via 3drefit) to new\
            orient XXX. Includes comment line first.
        is_aform_real_orth: If true, aform_real == aform_orth, which should be\
            a very common occurrence.
        aform_orth: Display full 3x4 'aform_orth' matrix (AFNI's RAI matrix\
            equivalent of the NIFTI quaternion, which may contain obliquity info),\
            with comment line first. This matrix is the orthogonalized form of\
            aform_real, and very often AFNI-produced dsets, we will have:\
            aform_orth == aform_real.
        perm_to_orient: Display 3x3 permutation matrix to go from the dset's\
            current orientation to the YYY orient.
        same_grid: Output 1 if the grid is identical between two dsets, 0\
            otherwise. For -same_grid to be 1, all of -same_dim, -same_delta,\
            -same_orient, -same_center, and -same_obl must return 1.
        same_dim: 1 if dimensions (nx, ny, nz) are the same between dset pairs.
        same_delta: 1 if voxel sizes are the same between dset pairs.
        same_orient: 1 if orientation is the same between dset pairs.
        same_center: 1 if geometric center is the same between dset pairs.
        same_obl: 1 if obliquity is the same between dset pairs.
        same_all_grid: Equivalent to listing all of -same_dim, -same_delta,\
            -same_orient, -same_center, and -same_obl on the command line.
        val_diff: Output the sum of absolute differences of all voxels in the\
            dataset pair. A -1.0 value indicates a grid mismatch between volume\
            pairs.
        sval_diff: Same as -val_diff, but the sum is divided (scaled) by the\
            total number of voxels that are not zero in at least one of the two\
            datasets.
        monog_pairs: Instead of pairing each dset with the first, pair each\
            couple separately. This requires you to have an even number of dsets on\
            the command line.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dinfo",
        "orient": orient,
        "Lextent": lextent,
        "Rextent": rextent,
        "Aextent": aextent,
        "Pextent": pextent,
        "Iextent": iextent,
        "Sextent": sextent,
        "all_names": all_names,
        "verb": verb,
        "very_verbose": very_verbose,
        "short": short,
        "no_hist": no_hist,
        "h": h,
        "help": help_,
        "extreme_help": extreme_help,
        "h_view": h_view,
        "h_web": h_web,
        "h_raw": h_raw,
        "h_spx": h_spx,
        "h_aspx": h_aspx,
        "all_opts": all_opts,
        "niml_hdr": niml_hdr,
        "subbrick_info": subbrick_info,
        "exists": exists,
        "id": id_,
        "is_atlas": is_atlas,
        "is_atlas_or_labeltable": is_atlas_or_labeltable,
        "is_nifti": is_nifti,
        "dset_extension": dset_extension,
        "storage_mode": storage_mode,
        "space": space,
        "gen_space": gen_space,
        "av_space": av_space,
        "nifti_code": nifti_code,
        "is_oblique": is_oblique,
        "handedness": handedness,
        "obliquity": obliquity,
        "prefix": prefix,
        "prefix_noext": prefix_noext,
        "ni": ni,
        "nj": nj,
        "nk": nk,
        "nijk": nijk,
        "nv": nv,
        "nt": nt_,
        "n4": n4,
        "nvi": nvi,
        "nti": nti,
        "ntimes": ntimes,
        "max_node": max_node,
        "di": di,
        "dj": dj,
        "dk": dk,
        "d3": d3,
        "adi": adi,
        "adj": adj,
        "adk": adk,
        "ad3": ad3,
        "voxvol": voxvol,
        "oi": oi,
        "oj": oj,
        "ok": ok,
        "o3": o3,
        "dcx": dcx,
        "dcy": dcy,
        "dcz": dcz,
        "dc3": dc3,
        "tr": tr,
        "dmin": dmin,
        "dmax": dmax,
        "dminus": dminus,
        "dmaxus": dmaxus,
        "smode": smode,
        "header_name": header_name,
        "brick_name": brick_name,
        "iname": iname,
        "extent": extent,
        "fac": fac,
        "label": label,
        "datum": datum,
        "min": min_,
        "max": max_,
        "minus": minus,
        "maxus": maxus,
        "labeltable": labeltable,
        "labeltable_as_atlas_points": labeltable_as_atlas_points,
        "atlas_points": atlas_points,
        "history": history,
        "slice_timing": slice_timing,
        "header_line": header_line,
        "hdr": hdr,
        "aform_real": aform_real,
        "aform_real_oneline": aform_real_oneline,
        "aform_real_refit_ori": aform_real_refit_ori,
        "is_aform_real_orth": is_aform_real_orth,
        "aform_orth": aform_orth,
        "same_grid": same_grid,
        "same_dim": same_dim,
        "same_delta": same_delta,
        "same_orient": same_orient,
        "same_center": same_center,
        "same_obl": same_obl,
        "same_all_grid": same_all_grid,
        "val_diff": val_diff,
        "sval_diff": sval_diff,
        "monog_pairs": monog_pairs,
        "dataset": dataset,
    }
    if h_find is not None:
        params["h_find"] = h_find
    if label2index is not None:
        params["label2index"] = label2index
    if sb_delim is not None:
        params["sb_delim"] = sb_delim
    if na_flag is not None:
        params["NA_flag"] = na_flag
    if atr_delim is not None:
        params["atr_delim"] = atr_delim
    if perm_to_orient is not None:
        params["perm_to_orient"] = perm_to_orient
    return params


def v_3dinfo_cargs(
    params: V3dinfoParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dinfo")
    if params.get("orient", False):
        cargs.append("-orient")
    if params.get("Lextent", False):
        cargs.append("-Lextent")
    if params.get("Rextent", False):
        cargs.append("-Rextent")
    if params.get("Aextent", False):
        cargs.append("-Aextent")
    if params.get("Pextent", False):
        cargs.append("-Pextent")
    if params.get("Iextent", False):
        cargs.append("-Iextent")
    if params.get("Sextent", False):
        cargs.append("-Sextent")
    if params.get("all_names", False):
        cargs.append("-all_names")
    if params.get("verb", False):
        cargs.append("-verb")
    if params.get("very_verbose", False):
        cargs.append("-VERB")
    if params.get("short", False):
        cargs.append("-short")
    if params.get("no_hist", False):
        cargs.append("-no_hist")
    if params.get("h", False):
        cargs.append("-h")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("extreme_help", False):
        cargs.append("-HELP")
    if params.get("h_view", False):
        cargs.append("-h_view")
    if params.get("h_web", False):
        cargs.append("-h_web")
    if params.get("h_find", None) is not None:
        cargs.extend([
            "-h_find",
            params.get("h_find", None)
        ])
    if params.get("h_raw", False):
        cargs.append("-h_raw")
    if params.get("h_spx", False):
        cargs.append("-h_spx")
    if params.get("h_aspx", False):
        cargs.append("-h_aspx")
    if params.get("all_opts", False):
        cargs.append("-all_opts")
    if params.get("label2index", None) is not None:
        cargs.extend([
            "-label2index",
            params.get("label2index", None)
        ])
    if params.get("niml_hdr", False):
        cargs.append("-niml_hdr")
    if params.get("subbrick_info", False):
        cargs.append("-subbrick_info")
    if params.get("exists", False):
        cargs.append("-exists")
    if params.get("id", False):
        cargs.append("-id")
    if params.get("is_atlas", False):
        cargs.append("-is_atlas")
    if params.get("is_atlas_or_labeltable", False):
        cargs.append("-is_atlas_or_labeltable")
    if params.get("is_nifti", False):
        cargs.append("-is_nifti")
    if params.get("dset_extension", False):
        cargs.append("-dset_extension")
    if params.get("storage_mode", False):
        cargs.append("-storage_mode")
    if params.get("space", False):
        cargs.append("-space")
    if params.get("gen_space", False):
        cargs.append("-gen_space")
    if params.get("av_space", False):
        cargs.append("-av_space")
    if params.get("nifti_code", False):
        cargs.append("-nifti_code")
    if params.get("is_oblique", False):
        cargs.append("-is_oblique")
    if params.get("handedness", False):
        cargs.append("-handedness")
    if params.get("obliquity", False):
        cargs.append("-obliquity")
    if params.get("prefix", False):
        cargs.append("-prefix")
    if params.get("prefix_noext", False):
        cargs.append("-prefix_noext")
    if params.get("ni", False):
        cargs.append("-ni")
    if params.get("nj", False):
        cargs.append("-nj")
    if params.get("nk", False):
        cargs.append("-nk")
    if params.get("nijk", False):
        cargs.append("-nijk")
    if params.get("nv", False):
        cargs.append("-nv")
    if params.get("nt", False):
        cargs.append("-nt")
    if params.get("n4", False):
        cargs.append("-n4")
    if params.get("nvi", False):
        cargs.append("-nvi")
    if params.get("nti", False):
        cargs.append("-nti")
    if params.get("ntimes", False):
        cargs.append("-ntimes")
    if params.get("max_node", False):
        cargs.append("-max_node")
    if params.get("di", False):
        cargs.append("-di")
    if params.get("dj", False):
        cargs.append("-dj")
    if params.get("dk", False):
        cargs.append("-dk")
    if params.get("d3", False):
        cargs.append("-d3")
    if params.get("adi", False):
        cargs.append("-adi")
    if params.get("adj", False):
        cargs.append("-adj")
    if params.get("adk", False):
        cargs.append("-adk")
    if params.get("ad3", False):
        cargs.append("-ad3")
    if params.get("voxvol", False):
        cargs.append("-voxvol")
    if params.get("oi", False):
        cargs.append("-oi")
    if params.get("oj", False):
        cargs.append("-oj")
    if params.get("ok", False):
        cargs.append("-ok")
    if params.get("o3", False):
        cargs.append("-o3")
    if params.get("dcx", False):
        cargs.append("-dcx")
    if params.get("dcy", False):
        cargs.append("-dcy")
    if params.get("dcz", False):
        cargs.append("-dcz")
    if params.get("dc3", False):
        cargs.append("-dc3")
    if params.get("tr", False):
        cargs.append("-tr")
    if params.get("dmin", False):
        cargs.append("-dmin")
    if params.get("dmax", False):
        cargs.append("-dmax")
    if params.get("dminus", False):
        cargs.append("-dminus")
    if params.get("dmaxus", False):
        cargs.append("-dmaxus")
    if params.get("smode", False):
        cargs.append("-smode")
    if params.get("header_name", False):
        cargs.append("-header_name")
    if params.get("brick_name", False):
        cargs.append("-brick_name")
    if params.get("iname", False):
        cargs.append("-iname")
    if params.get("extent", False):
        cargs.append("-extent")
    if params.get("fac", False):
        cargs.append("-fac")
    if params.get("label", False):
        cargs.append("-label")
    if params.get("datum", False):
        cargs.append("-datum")
    if params.get("min", False):
        cargs.append("-min")
    if params.get("max", False):
        cargs.append("-max")
    if params.get("minus", False):
        cargs.append("-minus")
    if params.get("maxus", False):
        cargs.append("-maxus")
    if params.get("labeltable", False):
        cargs.append("-labeltable")
    if params.get("labeltable_as_atlas_points", False):
        cargs.append("-labeltable_as_atlas_points")
    if params.get("atlas_points", False):
        cargs.append("-atlas_points")
    if params.get("history", False):
        cargs.append("-history")
    if params.get("slice_timing", False):
        cargs.append("-slice_timing")
    if params.get("header_line", False):
        cargs.append("-header_line")
    if params.get("hdr", False):
        cargs.append("-hdr")
    if params.get("sb_delim", None) is not None:
        cargs.extend([
            "-sb_delim",
            params.get("sb_delim", None)
        ])
    if params.get("NA_flag", None) is not None:
        cargs.extend([
            "-NA_flag",
            params.get("NA_flag", None)
        ])
    if params.get("atr_delim", None) is not None:
        cargs.extend([
            "-atr_delim",
            params.get("atr_delim", None)
        ])
    if params.get("aform_real", False):
        cargs.append("-aform_real")
    if params.get("aform_real_oneline", False):
        cargs.append("-aform_real_oneline")
    if params.get("aform_real_refit_ori", False):
        cargs.append("-aform_real_refit_ori")
    if params.get("is_aform_real_orth", False):
        cargs.append("-is_aform_real_orth")
    if params.get("aform_orth", False):
        cargs.append("-aform_orth")
    if params.get("perm_to_orient", None) is not None:
        cargs.extend([
            "-perm_to_orient",
            params.get("perm_to_orient", None)
        ])
    if params.get("same_grid", False):
        cargs.append("-same_grid")
    if params.get("same_dim", False):
        cargs.append("-same_dim")
    if params.get("same_delta", False):
        cargs.append("-same_delta")
    if params.get("same_orient", False):
        cargs.append("-same_orient")
    if params.get("same_center", False):
        cargs.append("-same_center")
    if params.get("same_obl", False):
        cargs.append("-same_obl")
    if params.get("same_all_grid", False):
        cargs.append("-same_all_grid")
    if params.get("val_diff", False):
        cargs.append("-val_diff")
    if params.get("sval_diff", False):
        cargs.append("-sval_diff")
    if params.get("monog_pairs", False):
        cargs.append("-monog_pairs")
    cargs.extend([execution.input_file(f) for f in params.get("dataset", None)])
    return cargs


def v_3dinfo_outputs(
    params: V3dinfoParameters,
    execution: Execution,
) -> V3dinfoOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dinfoOutputs(
        root=execution.output_file("."),
        info=[],
    )
    return ret


def v_3dinfo_execute(
    params: V3dinfoParameters,
    runner: Runner | None = None,
) -> V3dinfoOutputs:
    """
    3dinfo
    
    Prints out sort-of-useful information from a 3D dataset's header.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dinfoOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DINFO_METADATA)
    params = execution.params(params)
    cargs = v_3dinfo_cargs(params, execution)
    ret = v_3dinfo_outputs(params, execution)
    execution.run(cargs, handle_stdout=lambda s: ret.info.append(s))
    return ret


def v_3dinfo(
    dataset: list[InputPathType],
    orient: bool = False,
    lextent: bool = False,
    rextent: bool = False,
    aextent: bool = False,
    pextent: bool = False,
    iextent: bool = False,
    sextent: bool = False,
    all_names: bool = False,
    verb: bool = False,
    very_verbose: bool = False,
    short: bool = False,
    no_hist: bool = False,
    h: bool = False,
    help_: bool = False,
    extreme_help: bool = False,
    h_view: bool = False,
    h_web: bool = False,
    h_find: str | None = None,
    h_raw: bool = False,
    h_spx: bool = False,
    h_aspx: bool = False,
    all_opts: bool = False,
    label2index: str | None = None,
    niml_hdr: bool = False,
    subbrick_info: bool = False,
    exists: bool = False,
    id_: bool = False,
    is_atlas: bool = False,
    is_atlas_or_labeltable: bool = False,
    is_nifti: bool = False,
    dset_extension: bool = False,
    storage_mode: bool = False,
    space: bool = False,
    gen_space: bool = False,
    av_space: bool = False,
    nifti_code: bool = False,
    is_oblique: bool = False,
    handedness: bool = False,
    obliquity: bool = False,
    prefix: bool = False,
    prefix_noext: bool = False,
    ni: bool = False,
    nj: bool = False,
    nk: bool = False,
    nijk: bool = False,
    nv: bool = False,
    nt_: bool = False,
    n4: bool = False,
    nvi: bool = False,
    nti: bool = False,
    ntimes: bool = False,
    max_node: bool = False,
    di: bool = False,
    dj: bool = False,
    dk: bool = False,
    d3: bool = False,
    adi: bool = False,
    adj: bool = False,
    adk: bool = False,
    ad3: bool = False,
    voxvol: bool = False,
    oi: bool = False,
    oj: bool = False,
    ok: bool = False,
    o3: bool = False,
    dcx: bool = False,
    dcy: bool = False,
    dcz: bool = False,
    dc3: bool = False,
    tr: bool = False,
    dmin: bool = False,
    dmax: bool = False,
    dminus: bool = False,
    dmaxus: bool = False,
    smode: bool = False,
    header_name: bool = False,
    brick_name: bool = False,
    iname: bool = False,
    extent: bool = False,
    fac: bool = False,
    label: bool = False,
    datum: bool = False,
    min_: bool = False,
    max_: bool = False,
    minus: bool = False,
    maxus: bool = False,
    labeltable: bool = False,
    labeltable_as_atlas_points: bool = False,
    atlas_points: bool = False,
    history: bool = False,
    slice_timing: bool = False,
    header_line: bool = False,
    hdr: bool = False,
    sb_delim: str | None = None,
    na_flag: str | None = None,
    atr_delim: str | None = None,
    aform_real: bool = False,
    aform_real_oneline: bool = False,
    aform_real_refit_ori: bool = False,
    is_aform_real_orth: bool = False,
    aform_orth: bool = False,
    perm_to_orient: str | None = None,
    same_grid: bool = False,
    same_dim: bool = False,
    same_delta: bool = False,
    same_orient: bool = False,
    same_center: bool = False,
    same_obl: bool = False,
    same_all_grid: bool = False,
    val_diff: bool = False,
    sval_diff: bool = False,
    monog_pairs: bool = False,
    runner: Runner | None = None,
) -> V3dinfoOutputs:
    """
    3dinfo
    
    Prints out sort-of-useful information from a 3D dataset's header.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Datasets to retrieve information from.
        orient: Value of orientation string. For example, LPI means: i\
            direction grows from Left(negative) to Right(positive). j direction\
            grows from Posterior (neg.) to Anterior (pos.) k direction grows from\
            Inferior (neg.) to Superior (pos.).
        lextent: Extent along L.
        rextent: Extent along R.
        aextent: Extent along A.
        pextent: Extent along P.
        iextent: Extent along I.
        sextent: Extent along S.
        all_names: Value of various dset structures handling filenames.
        verb: Print out lots of information.
        very_verbose: Print out even more information including slice time\
            offsets.
        short: Print out less information (default).
        no_hist: Omit the HISTORY text.
        h: Mini help.
        help_: Display entire help output.
        extreme_help: Extreme help.
        h_view: Open help in text editor.
        h_web: Open help in web browser.
        h_find: Look for lines in help output that match WORD.
        h_raw: Display unedited help string.
        h_spx: Help string in sphinx format without autoformatting options.
        h_aspx: Help string in sphinx format with autoformatting options.
        all_opts: Try to identify all options for the program from the help\
            output.
        label2index: Output index corresponding to label.
        niml_hdr: Output entire NIML-formatted header.
        subbrick_info: Output only sub-brick part of information.
        exists: 1 if dset is loadable, 0 otherwise. This works on prefix also.
        id_: Idcodestring of dset.
        is_atlas: 1 if dset is an atlas.
        is_atlas_or_labeltable: 1 if dset has an atlas or labeltable.
        is_nifti: 1 if dset is NIFTI format, 0 otherwise.
        dset_extension: Show filename extension for valid dataset (e.g.\
            .nii.gz).
        storage_mode: Show internal storage mode of dataset (e.g. NIFTI).
        space: Dataset's space.
        gen_space: Dataset's generic space.
        av_space: AFNI format's view extension for the space.
        nifti_code: What AFNI would use for an output NIFTI (q)sform_code.
        is_oblique: 1 if dset is oblique.
        handedness: L if orientation is Left handed, R if it is right handed.
        obliquity: Angle from plumb direction. Angles of 0 (or close) are for\
            cardinal orientations.
        prefix: Return the prefix.
        prefix_noext: Return the prefix without extensions.
        ni: Return the number of voxels in i dimension.
        nj: Return the number of voxels in j dimension.
        nk: Return the number of voxels in k dimension.
        nijk: Return ni*nj*nk.
        nv: Return number of points in time or the number of sub-bricks.
        nt_: Same as -nv.
        n4: Same as -ni -nj -nk -nv.
        nvi: The maximum sub-brick index (= nv -1 ).
        nti: Same as -nvi.
        ntimes: Return number of sub-bricks points in time. This is an option\
            for debugging use, stay away from it.
        max_node: For a surface-based dset, return the maximum node index.
        di: Signed displacement per voxel along i direction, aka dx.
        dj: Signed displacement per voxel along j direction, aka dy.
        dk: Signed displacement per voxel along k direction, aka dz.
        d3: Same as -di -dj -dk.
        adi: Voxel size along i direction (abs(di)).
        adj: Voxel size along j direction (abs(dj)).
        adk: Voxel size along k direction (abs(dk)).
        ad3: Same as -adi -adj -adk.
        voxvol: Voxel volume in cubic millimeters.
        oi: Volume origin along the i direction.
        oj: Volume origin along the j direction.
        ok: Volume origin along the k direction.
        o3: Same as -oi -oj -ok.
        dcx: Volumetric center in x direction (DICOM coordinates).
        dcy: Volumetric center in y direction (DICOM coordinates).
        dcz: Volumetric center in z direction (DICOM coordinates).
        dc3: Same as -dcx -dcy -dcz.
        tr: The TR value in seconds.
        dmin: The dataset's minimum value, scaled by fac.
        dmax: The dataset's maximum value, scaled by fac.
        dminus: The dataset's minimum value, unscaled.
        dmaxus: The dataset's maximum value, unscaled.
        smode: Dset storage mode string.
        header_name: Value of dset structure (sub)field 'header_name'.
        brick_name: Value of dset structure (sub)field 'brick_name'.
        iname: Name of dset as input on the command line.
        extent: The spatial extent of the dataset along R, L, A, P, I and S.
        fac: Return the float scaling factor.
        label: The label of each sub-brick.
        datum: The data storage type.
        min_: The minimum value, scaled by fac.
        max_: The maximum value, scaled by fac.
        minus: The minimum value, unscaled.
        maxus: The maximum value, unscaled.
        labeltable: Show label table, if any.
        labeltable_as_atlas_points: Show label table in atlas point format.
        atlas_points: Show atlas points list, if any.
        history: History note.
        slice_timing: Show slice timing.
        header_line: Output as the first line the names of attributes in each\
            field (column).
        hdr: Same as -header_line.
        sb_delim: Delimiter string between sub-brick values. Default SB_DELIM\
            is '|'.
        na_flag: String to use when a field is not found or not applicable.\
            Default is 'NA'.
        atr_delim: Delimiter string between attributes. Default ATR_DELIM is\
            the tab character.
        aform_real: Display full 3x4 'aform_real' matrix (AFNI's RAI equivalent\
            of the sform matrix in NIFTI, may contain obliquity info), with comment\
            line first.
        aform_real_oneline: Display full 'aform_real' matrix (see\
            '-aform_real') as 1 row of 12 numbers. No additional comment.
        aform_real_refit_ori: Display full 3x4 'aform_real' matrix (see\
            '-aform_real') *if* the dset were reoriented (via 3drefit) to new\
            orient XXX. Includes comment line first.
        is_aform_real_orth: If true, aform_real == aform_orth, which should be\
            a very common occurrence.
        aform_orth: Display full 3x4 'aform_orth' matrix (AFNI's RAI matrix\
            equivalent of the NIFTI quaternion, which may contain obliquity info),\
            with comment line first. This matrix is the orthogonalized form of\
            aform_real, and very often AFNI-produced dsets, we will have:\
            aform_orth == aform_real.
        perm_to_orient: Display 3x3 permutation matrix to go from the dset's\
            current orientation to the YYY orient.
        same_grid: Output 1 if the grid is identical between two dsets, 0\
            otherwise. For -same_grid to be 1, all of -same_dim, -same_delta,\
            -same_orient, -same_center, and -same_obl must return 1.
        same_dim: 1 if dimensions (nx, ny, nz) are the same between dset pairs.
        same_delta: 1 if voxel sizes are the same between dset pairs.
        same_orient: 1 if orientation is the same between dset pairs.
        same_center: 1 if geometric center is the same between dset pairs.
        same_obl: 1 if obliquity is the same between dset pairs.
        same_all_grid: Equivalent to listing all of -same_dim, -same_delta,\
            -same_orient, -same_center, and -same_obl on the command line.
        val_diff: Output the sum of absolute differences of all voxels in the\
            dataset pair. A -1.0 value indicates a grid mismatch between volume\
            pairs.
        sval_diff: Same as -val_diff, but the sum is divided (scaled) by the\
            total number of voxels that are not zero in at least one of the two\
            datasets.
        monog_pairs: Instead of pairing each dset with the first, pair each\
            couple separately. This requires you to have an even number of dsets on\
            the command line.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dinfoOutputs`).
    """
    params = v_3dinfo_params(
        orient=orient,
        lextent=lextent,
        rextent=rextent,
        aextent=aextent,
        pextent=pextent,
        iextent=iextent,
        sextent=sextent,
        all_names=all_names,
        verb=verb,
        very_verbose=very_verbose,
        short=short,
        no_hist=no_hist,
        h=h,
        help_=help_,
        extreme_help=extreme_help,
        h_view=h_view,
        h_web=h_web,
        h_find=h_find,
        h_raw=h_raw,
        h_spx=h_spx,
        h_aspx=h_aspx,
        all_opts=all_opts,
        label2index=label2index,
        niml_hdr=niml_hdr,
        subbrick_info=subbrick_info,
        exists=exists,
        id_=id_,
        is_atlas=is_atlas,
        is_atlas_or_labeltable=is_atlas_or_labeltable,
        is_nifti=is_nifti,
        dset_extension=dset_extension,
        storage_mode=storage_mode,
        space=space,
        gen_space=gen_space,
        av_space=av_space,
        nifti_code=nifti_code,
        is_oblique=is_oblique,
        handedness=handedness,
        obliquity=obliquity,
        prefix=prefix,
        prefix_noext=prefix_noext,
        ni=ni,
        nj=nj,
        nk=nk,
        nijk=nijk,
        nv=nv,
        nt_=nt_,
        n4=n4,
        nvi=nvi,
        nti=nti,
        ntimes=ntimes,
        max_node=max_node,
        di=di,
        dj=dj,
        dk=dk,
        d3=d3,
        adi=adi,
        adj=adj,
        adk=adk,
        ad3=ad3,
        voxvol=voxvol,
        oi=oi,
        oj=oj,
        ok=ok,
        o3=o3,
        dcx=dcx,
        dcy=dcy,
        dcz=dcz,
        dc3=dc3,
        tr=tr,
        dmin=dmin,
        dmax=dmax,
        dminus=dminus,
        dmaxus=dmaxus,
        smode=smode,
        header_name=header_name,
        brick_name=brick_name,
        iname=iname,
        extent=extent,
        fac=fac,
        label=label,
        datum=datum,
        min_=min_,
        max_=max_,
        minus=minus,
        maxus=maxus,
        labeltable=labeltable,
        labeltable_as_atlas_points=labeltable_as_atlas_points,
        atlas_points=atlas_points,
        history=history,
        slice_timing=slice_timing,
        header_line=header_line,
        hdr=hdr,
        sb_delim=sb_delim,
        na_flag=na_flag,
        atr_delim=atr_delim,
        aform_real=aform_real,
        aform_real_oneline=aform_real_oneline,
        aform_real_refit_ori=aform_real_refit_ori,
        is_aform_real_orth=is_aform_real_orth,
        aform_orth=aform_orth,
        perm_to_orient=perm_to_orient,
        same_grid=same_grid,
        same_dim=same_dim,
        same_delta=same_delta,
        same_orient=same_orient,
        same_center=same_center,
        same_obl=same_obl,
        same_all_grid=same_all_grid,
        val_diff=val_diff,
        sval_diff=sval_diff,
        monog_pairs=monog_pairs,
        dataset=dataset,
    )
    return v_3dinfo_execute(params, runner)


__all__ = [
    "V3dinfoOutputs",
    "V_3DINFO_METADATA",
    "v_3dinfo",
    "v_3dinfo_execute",
    "v_3dinfo_params",
]
