# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DMATCALC_METADATA = Metadata(
    id="8f178bdc30988773d64483c60aa601e33c83d9f6.boutiques",
    name="3dmatcalc",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dmatcalcParameters = typing.TypedDict('V3dmatcalcParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dmatcalc"]],
    "input_dataset": InputPathType,
    "input_matrix": InputPathType,
    "output_dataset": str,
    "mask": typing.NotRequired[InputPathType | None],
})
V3dmatcalcParametersTagged = typing.TypedDict('V3dmatcalcParametersTagged', {
    "@type": typing.Literal["afni/3dmatcalc"],
    "input_dataset": InputPathType,
    "input_matrix": InputPathType,
    "output_dataset": str,
    "mask": typing.NotRequired[InputPathType | None],
})


class V3dmatcalcOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dmatcalcParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_header: OutputPathType
    """Output dataset header file."""
    output_brick: OutputPathType
    """Output dataset brick file."""


def v_3dmatcalc_params(
    input_dataset: InputPathType,
    input_matrix: InputPathType,
    output_dataset: str,
    mask: InputPathType | None = None,
) -> V3dmatcalcParametersTagged:
    """
    Build parameters.
    
    Args:
        input_dataset: Input dataset to be processed.
        input_matrix: The matrix to be applied, specified as a .1D file or as\
            an expression in the syntax of 1dmatcalc.
        output_dataset: Prefix for the output dataset.
        mask: Apply the matrix only to voxels in the mask; other voxels will be\
            set to all zeroes.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dmatcalc",
        "input_dataset": input_dataset,
        "input_matrix": input_matrix,
        "output_dataset": output_dataset,
    }
    if mask is not None:
        params["mask"] = mask
    return params


def v_3dmatcalc_cargs(
    params: V3dmatcalcParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dmatcalc")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_dataset", None))
    ])
    cargs.extend([
        "-matrix",
        execution.input_file(params.get("input_matrix", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("output_dataset", None)
    ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    return cargs


def v_3dmatcalc_outputs(
    params: V3dmatcalcParameters,
    execution: Execution,
) -> V3dmatcalcOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dmatcalcOutputs(
        root=execution.output_file("."),
        output_header=execution.output_file(params.get("output_dataset", None) + "+tlrc.HEAD"),
        output_brick=execution.output_file(params.get("output_dataset", None) + "+tlrc.BRIK"),
    )
    return ret


def v_3dmatcalc_execute(
    params: V3dmatcalcParameters,
    runner: Runner | None = None,
) -> V3dmatcalcOutputs:
    """
    3dmatcalc
    
    Apply a matrix to a dataset, voxel-by-voxel, to produce a new dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dmatcalcOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DMATCALC_METADATA)
    params = execution.params(params)
    cargs = v_3dmatcalc_cargs(params, execution)
    ret = v_3dmatcalc_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dmatcalc(
    input_dataset: InputPathType,
    input_matrix: InputPathType,
    output_dataset: str,
    mask: InputPathType | None = None,
    runner: Runner | None = None,
) -> V3dmatcalcOutputs:
    """
    3dmatcalc
    
    Apply a matrix to a dataset, voxel-by-voxel, to produce a new dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Input dataset to be processed.
        input_matrix: The matrix to be applied, specified as a .1D file or as\
            an expression in the syntax of 1dmatcalc.
        output_dataset: Prefix for the output dataset.
        mask: Apply the matrix only to voxels in the mask; other voxels will be\
            set to all zeroes.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dmatcalcOutputs`).
    """
    params = v_3dmatcalc_params(
        input_dataset=input_dataset,
        input_matrix=input_matrix,
        output_dataset=output_dataset,
        mask=mask,
    )
    return v_3dmatcalc_execute(params, runner)


__all__ = [
    "V3dmatcalcOutputs",
    "V_3DMATCALC_METADATA",
    "v_3dmatcalc",
    "v_3dmatcalc_execute",
    "v_3dmatcalc_params",
]
