# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DMATMULT_METADATA = Metadata(
    id="025bcf26f324d0334be68bee9d41585c8c6c570d.boutiques",
    name="3dmatmult",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dmatmultParameters = typing.TypedDict('V3dmatmultParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dmatmult"]],
    "inputA": InputPathType,
    "inputB": InputPathType,
    "prefix": str,
    "datum": typing.NotRequired[str | None],
    "verb": typing.NotRequired[float | None],
})
V3dmatmultParametersTagged = typing.TypedDict('V3dmatmultParametersTagged', {
    "@type": typing.Literal["afni/3dmatmult"],
    "inputA": InputPathType,
    "inputB": InputPathType,
    "prefix": str,
    "datum": typing.NotRequired[str | None],
    "verb": typing.NotRequired[float | None],
})


class V3dmatmultOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dmatmultParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Output dataset from the matrix multiplication"""


def v_3dmatmult_params(
    input_a: InputPathType,
    input_b: InputPathType,
    prefix: str,
    datum: str | None = None,
    verb: float | None = None,
) -> V3dmatmultParametersTagged:
    """
    Build parameters.
    
    Args:
        input_a: Specify first (matrix) dataset.
        input_b: Specify second (matrix) dataset.
        prefix: Specify output dataset prefix.
        datum: Specify output data type ('byte', 'short', 'float').
        verb: Specify verbosity level.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dmatmult",
        "inputA": input_a,
        "inputB": input_b,
        "prefix": prefix,
    }
    if datum is not None:
        params["datum"] = datum
    if verb is not None:
        params["verb"] = verb
    return params


def v_3dmatmult_cargs(
    params: V3dmatmultParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dmatmult")
    cargs.extend([
        "-inputA",
        execution.input_file(params.get("inputA", None))
    ])
    cargs.extend([
        "-inputB",
        execution.input_file(params.get("inputB", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("datum", None) is not None:
        cargs.extend([
            "-datum",
            params.get("datum", None)
        ])
    if params.get("verb", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verb", None))
        ])
    return cargs


def v_3dmatmult_outputs(
    params: V3dmatmultParameters,
    execution: Execution,
) -> V3dmatmultOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dmatmultOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix", None)),
    )
    return ret


def v_3dmatmult_execute(
    params: V3dmatmultParameters,
    runner: Runner | None = None,
) -> V3dmatmultOutputs:
    """
    3dmatmult
    
    Multiply AFNI datasets slice-by-slice as matrices.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dmatmultOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DMATMULT_METADATA)
    params = execution.params(params)
    cargs = v_3dmatmult_cargs(params, execution)
    ret = v_3dmatmult_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dmatmult(
    input_a: InputPathType,
    input_b: InputPathType,
    prefix: str,
    datum: str | None = None,
    verb: float | None = None,
    runner: Runner | None = None,
) -> V3dmatmultOutputs:
    """
    3dmatmult
    
    Multiply AFNI datasets slice-by-slice as matrices.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_a: Specify first (matrix) dataset.
        input_b: Specify second (matrix) dataset.
        prefix: Specify output dataset prefix.
        datum: Specify output data type ('byte', 'short', 'float').
        verb: Specify verbosity level.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dmatmultOutputs`).
    """
    params = v_3dmatmult_params(
        input_a=input_a,
        input_b=input_b,
        prefix=prefix,
        datum=datum,
        verb=verb,
    )
    return v_3dmatmult_execute(params, runner)


__all__ = [
    "V3dmatmultOutputs",
    "V_3DMATMULT_METADATA",
    "v_3dmatmult",
    "v_3dmatmult_execute",
    "v_3dmatmult_params",
]
