# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DMAXDISP_METADATA = Metadata(
    id="df5cebff8f2b1777c51dee0444455c1379652c77.boutiques",
    name="3dmaxdisp",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dmaxdispParameters = typing.TypedDict('V3dmaxdispParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dmaxdisp"]],
    "inset": InputPathType,
    "matrix": InputPathType,
    "verbose": bool,
})
V3dmaxdispParametersTagged = typing.TypedDict('V3dmaxdispParametersTagged', {
    "@type": typing.Literal["afni/3dmaxdisp"],
    "inset": InputPathType,
    "matrix": InputPathType,
    "verbose": bool,
})


class V3dmaxdispOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dmaxdispParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    displacement_output: OutputPathType
    """Results showing average and maximum displacements."""


def v_3dmaxdisp_params(
    inset: InputPathType,
    matrix: InputPathType,
    verbose: bool = False,
) -> V3dmaxdispParametersTagged:
    """
    Build parameters.
    
    Args:
        inset: Input dataset file used to form the mask over which\
            displacements will be computed.
        matrix: 3x4 affine transformation matrix file applied to the\
            coordinates of the voxels in the dataset mask.
        verbose: Print a few progress reports.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dmaxdisp",
        "inset": inset,
        "matrix": matrix,
        "verbose": verbose,
    }
    return params


def v_3dmaxdisp_cargs(
    params: V3dmaxdispParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dmaxdisp")
    cargs.extend([
        "-inset",
        execution.input_file(params.get("inset", None))
    ])
    cargs.extend([
        "-matrix",
        execution.input_file(params.get("matrix", None))
    ])
    if params.get("verbose", False):
        cargs.append("-verb")
    return cargs


def v_3dmaxdisp_outputs(
    params: V3dmaxdispParameters,
    execution: Execution,
) -> V3dmaxdispOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dmaxdispOutputs(
        root=execution.output_file("."),
        displacement_output=execution.output_file("stdout"),
    )
    return ret


def v_3dmaxdisp_execute(
    params: V3dmaxdispParameters,
    runner: Runner | None = None,
) -> V3dmaxdispOutputs:
    """
    3dmaxdisp
    
    Reads in a 3D dataset and a DICOM-based affine matrix to output the average
    and maximum displacement applied to the edge voxels of the 3D dataset's
    automask.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dmaxdispOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DMAXDISP_METADATA)
    params = execution.params(params)
    cargs = v_3dmaxdisp_cargs(params, execution)
    ret = v_3dmaxdisp_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dmaxdisp(
    inset: InputPathType,
    matrix: InputPathType,
    verbose: bool = False,
    runner: Runner | None = None,
) -> V3dmaxdispOutputs:
    """
    3dmaxdisp
    
    Reads in a 3D dataset and a DICOM-based affine matrix to output the average
    and maximum displacement applied to the edge voxels of the 3D dataset's
    automask.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        inset: Input dataset file used to form the mask over which\
            displacements will be computed.
        matrix: 3x4 affine transformation matrix file applied to the\
            coordinates of the voxels in the dataset mask.
        verbose: Print a few progress reports.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dmaxdispOutputs`).
    """
    params = v_3dmaxdisp_params(
        inset=inset,
        matrix=matrix,
        verbose=verbose,
    )
    return v_3dmaxdisp_execute(params, runner)


__all__ = [
    "V3dmaxdispOutputs",
    "V_3DMAXDISP_METADATA",
    "v_3dmaxdisp",
    "v_3dmaxdisp_execute",
    "v_3dmaxdisp_params",
]
