# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DNEWID_METADATA = Metadata(
    id="d9631a81a6ce88bab00129e99a4fffcedf738735.boutiques",
    name="3dnewid",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dnewidParameters = typing.TypedDict('V3dnewidParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dnewid"]],
    "datasets": list[InputPathType],
    "fun": typing.NotRequired[float | None],
    "fun11": bool,
    "int": bool,
    "hash": typing.NotRequired[str | None],
    "MD5": typing.NotRequired[str | None],
})
V3dnewidParametersTagged = typing.TypedDict('V3dnewidParametersTagged', {
    "@type": typing.Literal["afni/3dnewid"],
    "datasets": list[InputPathType],
    "fun": typing.NotRequired[float | None],
    "fun11": bool,
    "int": bool,
    "hash": typing.NotRequired[str | None],
    "MD5": typing.NotRequired[str | None],
})


class V3dnewidOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dnewidParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3dnewid_params(
    datasets: list[InputPathType],
    fun: float | None = None,
    fun11: bool = False,
    int_: bool = False,
    hash_: str | None = None,
    md5: str | None = None,
) -> V3dnewidParametersTagged:
    """
    Build parameters.
    
    Args:
        datasets: Input datasets to assign new ID codes.
        fun: Generate n randomly generated ID codes. If n is not present, 1 ID\
            code is printed.
        fun11: Generate an 11 character ID code for use in scripting.
        int_: Generate a random positive integer between 1 million and 1\
            billion.
        hash_: Generate a unique hash code of the provided string. The same\
            string produces the same hash code.
        md5: Generate the MD5 hash of the provided string. Output should be the\
            same as the -hash output without the prefix and without the + and /\
            char substitutions.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dnewid",
        "datasets": datasets,
        "fun11": fun11,
        "int": int_,
    }
    if fun is not None:
        params["fun"] = fun
    if hash_ is not None:
        params["hash"] = hash_
    if md5 is not None:
        params["MD5"] = md5
    return params


def v_3dnewid_cargs(
    params: V3dnewidParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dnewid")
    cargs.extend([execution.input_file(f) for f in params.get("datasets", None)])
    if params.get("fun", None) is not None:
        cargs.extend([
            "-fun",
            str(params.get("fun", None))
        ])
    if params.get("fun11", False):
        cargs.append("-fun11")
    if params.get("int", False):
        cargs.append("-int")
    if params.get("hash", None) is not None:
        cargs.extend([
            "-hash",
            params.get("hash", None)
        ])
    if params.get("MD5", None) is not None:
        cargs.extend([
            "-MD5",
            params.get("MD5", None)
        ])
    return cargs


def v_3dnewid_outputs(
    params: V3dnewidParameters,
    execution: Execution,
) -> V3dnewidOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dnewidOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3dnewid_execute(
    params: V3dnewidParameters,
    runner: Runner | None = None,
) -> V3dnewidOutputs:
    """
    3dnewid
    
    Assigns a new ID code to a dataset, ensuring internal ID codes remain
    unique.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dnewidOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DNEWID_METADATA)
    params = execution.params(params)
    cargs = v_3dnewid_cargs(params, execution)
    ret = v_3dnewid_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dnewid(
    datasets: list[InputPathType],
    fun: float | None = None,
    fun11: bool = False,
    int_: bool = False,
    hash_: str | None = None,
    md5: str | None = None,
    runner: Runner | None = None,
) -> V3dnewidOutputs:
    """
    3dnewid
    
    Assigns a new ID code to a dataset, ensuring internal ID codes remain
    unique.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        datasets: Input datasets to assign new ID codes.
        fun: Generate n randomly generated ID codes. If n is not present, 1 ID\
            code is printed.
        fun11: Generate an 11 character ID code for use in scripting.
        int_: Generate a random positive integer between 1 million and 1\
            billion.
        hash_: Generate a unique hash code of the provided string. The same\
            string produces the same hash code.
        md5: Generate the MD5 hash of the provided string. Output should be the\
            same as the -hash output without the prefix and without the + and /\
            char substitutions.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dnewidOutputs`).
    """
    params = v_3dnewid_params(
        datasets=datasets,
        fun=fun,
        fun11=fun11,
        int_=int_,
        hash_=hash_,
        md5=md5,
    )
    return v_3dnewid_execute(params, runner)


__all__ = [
    "V3dnewidOutputs",
    "V_3DNEWID_METADATA",
    "v_3dnewid",
    "v_3dnewid_execute",
    "v_3dnewid_params",
]
