# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DNVALS_METADATA = Metadata(
    id="d32979be81ea2707669bbfdc54a5b8ae7ef58f3d.boutiques",
    name="3dnvals",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dnvalsParameters = typing.TypedDict('V3dnvalsParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dnvals"]],
    "datasets": list[InputPathType],
    "all_flag": bool,
    "verbose_flag": bool,
})
V3dnvalsParametersTagged = typing.TypedDict('V3dnvalsParametersTagged', {
    "@type": typing.Literal["afni/3dnvals"],
    "datasets": list[InputPathType],
    "all_flag": bool,
    "verbose_flag": bool,
})


class V3dnvalsOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dnvalsParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_3dnvals_params(
    datasets: list[InputPathType],
    all_flag: bool = False,
    verbose_flag: bool = False,
) -> V3dnvalsParametersTagged:
    """
    Build parameters.
    
    Args:
        datasets: Input 3D dataset(s).
        all_flag: Print out all 4 dimensions: Nx, Ny, Nz, Nvals.
        verbose_flag: Print the header name of the dataset first.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dnvals",
        "datasets": datasets,
        "all_flag": all_flag,
        "verbose_flag": verbose_flag,
    }
    return params


def v_3dnvals_cargs(
    params: V3dnvalsParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dnvals")
    cargs.extend([execution.input_file(f) for f in params.get("datasets", None)])
    if params.get("all_flag", False):
        cargs.append("-all")
    if params.get("verbose_flag", False):
        cargs.append("-verbose")
    return cargs


def v_3dnvals_outputs(
    params: V3dnvalsParameters,
    execution: Execution,
) -> V3dnvalsOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dnvalsOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_3dnvals_execute(
    params: V3dnvalsParameters,
    runner: Runner | None = None,
) -> V3dnvalsOutputs:
    """
    3dnvals
    
    Tool to print the number of sub-bricks in a 3D dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dnvalsOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DNVALS_METADATA)
    params = execution.params(params)
    cargs = v_3dnvals_cargs(params, execution)
    ret = v_3dnvals_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dnvals(
    datasets: list[InputPathType],
    all_flag: bool = False,
    verbose_flag: bool = False,
    runner: Runner | None = None,
) -> V3dnvalsOutputs:
    """
    3dnvals
    
    Tool to print the number of sub-bricks in a 3D dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        datasets: Input 3D dataset(s).
        all_flag: Print out all 4 dimensions: Nx, Ny, Nz, Nvals.
        verbose_flag: Print the header name of the dataset first.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dnvalsOutputs`).
    """
    params = v_3dnvals_params(
        datasets=datasets,
        all_flag=all_flag,
        verbose_flag=verbose_flag,
    )
    return v_3dnvals_execute(params, runner)


__all__ = [
    "V3dnvalsOutputs",
    "V_3DNVALS_METADATA",
    "v_3dnvals",
    "v_3dnvals_execute",
    "v_3dnvals_params",
]
