# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DPC_METADATA = Metadata(
    id="cb83a78d80ca40f71ab808cf9db4c7db704ac5bb.boutiques",
    name="3dpc",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dpcParameters = typing.TypedDict('V3dpcParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dpc"]],
    "datasets": list[InputPathType],
    "dmean": bool,
    "vmean": bool,
    "vnorm": bool,
    "normalize": bool,
    "nscale": bool,
    "pcsave": typing.NotRequired[str | None],
    "reduce": typing.NotRequired[list[str] | None],
    "prefix": typing.NotRequired[str | None],
    "dummy_lines": typing.NotRequired[int | None],
    "verbose": bool,
    "quiet": bool,
    "eigonly": bool,
    "float": bool,
    "mask": typing.NotRequired[InputPathType | None],
})
V3dpcParametersTagged = typing.TypedDict('V3dpcParametersTagged', {
    "@type": typing.Literal["afni/3dpc"],
    "datasets": list[InputPathType],
    "dmean": bool,
    "vmean": bool,
    "vnorm": bool,
    "normalize": bool,
    "nscale": bool,
    "pcsave": typing.NotRequired[str | None],
    "reduce": typing.NotRequired[list[str] | None],
    "prefix": typing.NotRequired[str | None],
    "dummy_lines": typing.NotRequired[int | None],
    "verbose": bool,
    "quiet": bool,
    "eigonly": bool,
    "float": bool,
    "mask": typing.NotRequired[InputPathType | None],
})


class V3dpcOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dpcParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType | None
    """Output dataset file"""
    output_header: OutputPathType | None
    """Output dataset header file"""
    output_eig: OutputPathType | None
    """File with computed eigenvalues"""
    output_vec: OutputPathType | None
    """File with all eigen-timeseries"""
    output_individual_vec: OutputPathType | None
    """File with individual eigenvalue timeseries"""


def v_3dpc_params(
    datasets: list[InputPathType],
    dmean: bool = False,
    vmean: bool = False,
    vnorm: bool = False,
    normalize: bool = False,
    nscale: bool = False,
    pcsave: str | None = None,
    reduce: list[str] | None = None,
    prefix: str | None = None,
    dummy_lines: int | None = None,
    verbose: bool = False,
    quiet: bool = False,
    eigonly: bool = False,
    float_: bool = False,
    mask: InputPathType | None = None,
) -> V3dpcParametersTagged:
    """
    Build parameters.
    
    Args:
        datasets: Input dataset(s) with sub-brick selector list support.
        dmean: Remove the mean from each input brick (across space).
        vmean: Remove the mean from each input voxel (across bricks).
        vnorm: L2 normalize each input voxel time series.
        normalize: L2 normalize each input brick (after mean subtraction).
        nscale: Scale the covariance matrix by the number of samples.
        pcsave: 'sss' is the number of components to save in the output.
        reduce: Compute a dimensionally reduced dataset with top 'r'\
            eigenvalues and write to disk in dataset 'pp'.
        prefix: Name for the output dataset.
        dummy_lines: Add 'ddd' dummy lines to the top of each *.1D file.
        verbose: Print progress reports during the computations.
        quiet: Don't print progress reports.
        eigonly: Only compute eigenvalues, write them to 'pname'_eig.1D, then\
            stop.
        float_: Save eigen-bricks as floats (default = shorts).
        mask: Use the 0 sub-brick of dataset 'mset' as a mask indicating which\
            voxels to analyze.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dpc",
        "datasets": datasets,
        "dmean": dmean,
        "vmean": vmean,
        "vnorm": vnorm,
        "normalize": normalize,
        "nscale": nscale,
        "verbose": verbose,
        "quiet": quiet,
        "eigonly": eigonly,
        "float": float_,
    }
    if pcsave is not None:
        params["pcsave"] = pcsave
    if reduce is not None:
        params["reduce"] = reduce
    if prefix is not None:
        params["prefix"] = prefix
    if dummy_lines is not None:
        params["dummy_lines"] = dummy_lines
    if mask is not None:
        params["mask"] = mask
    return params


def v_3dpc_cargs(
    params: V3dpcParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dpc")
    cargs.extend([execution.input_file(f) for f in params.get("datasets", None)])
    if params.get("dmean", False):
        cargs.append("-dmean")
    if params.get("vmean", False):
        cargs.append("-vmean")
    if params.get("vnorm", False):
        cargs.append("-vnorm")
    if params.get("normalize", False):
        cargs.append("-normalize")
    if params.get("nscale", False):
        cargs.append("-nscale")
    if params.get("pcsave", None) is not None:
        cargs.extend([
            "-pcsave",
            params.get("pcsave", None)
        ])
    if params.get("reduce", None) is not None:
        cargs.extend([
            "-reduce",
            *params.get("reduce", None)
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("dummy_lines", None) is not None:
        cargs.extend([
            "-1ddum",
            str(params.get("dummy_lines", None))
        ])
    if params.get("verbose", False):
        cargs.append("-verbose")
    if params.get("quiet", False):
        cargs.append("-quiet")
    if params.get("eigonly", False):
        cargs.append("-eigonly")
    if params.get("float", False):
        cargs.append("-float")
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    return cargs


def v_3dpc_outputs(
    params: V3dpcParameters,
    execution: Execution,
) -> V3dpcOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dpcOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file(params.get("prefix", None) + "+orig.BRIK") if (params.get("prefix") is not None) else None,
        output_header=execution.output_file(params.get("prefix", None) + "+orig.HEAD") if (params.get("prefix") is not None) else None,
        output_eig=execution.output_file(params.get("prefix", None) + "_eig.1D") if (params.get("prefix") is not None) else None,
        output_vec=execution.output_file(params.get("prefix", None) + "_vec.1D") if (params.get("prefix") is not None) else None,
        output_individual_vec=execution.output_file(params.get("prefix", None) + "[NN].1D") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3dpc_execute(
    params: V3dpcParameters,
    runner: Runner | None = None,
) -> V3dpcOutputs:
    """
    3dpc
    
    Principal Component Analysis of 3D Datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dpcOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DPC_METADATA)
    params = execution.params(params)
    cargs = v_3dpc_cargs(params, execution)
    ret = v_3dpc_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dpc(
    datasets: list[InputPathType],
    dmean: bool = False,
    vmean: bool = False,
    vnorm: bool = False,
    normalize: bool = False,
    nscale: bool = False,
    pcsave: str | None = None,
    reduce: list[str] | None = None,
    prefix: str | None = None,
    dummy_lines: int | None = None,
    verbose: bool = False,
    quiet: bool = False,
    eigonly: bool = False,
    float_: bool = False,
    mask: InputPathType | None = None,
    runner: Runner | None = None,
) -> V3dpcOutputs:
    """
    3dpc
    
    Principal Component Analysis of 3D Datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        datasets: Input dataset(s) with sub-brick selector list support.
        dmean: Remove the mean from each input brick (across space).
        vmean: Remove the mean from each input voxel (across bricks).
        vnorm: L2 normalize each input voxel time series.
        normalize: L2 normalize each input brick (after mean subtraction).
        nscale: Scale the covariance matrix by the number of samples.
        pcsave: 'sss' is the number of components to save in the output.
        reduce: Compute a dimensionally reduced dataset with top 'r'\
            eigenvalues and write to disk in dataset 'pp'.
        prefix: Name for the output dataset.
        dummy_lines: Add 'ddd' dummy lines to the top of each *.1D file.
        verbose: Print progress reports during the computations.
        quiet: Don't print progress reports.
        eigonly: Only compute eigenvalues, write them to 'pname'_eig.1D, then\
            stop.
        float_: Save eigen-bricks as floats (default = shorts).
        mask: Use the 0 sub-brick of dataset 'mset' as a mask indicating which\
            voxels to analyze.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dpcOutputs`).
    """
    params = v_3dpc_params(
        datasets=datasets,
        dmean=dmean,
        vmean=vmean,
        vnorm=vnorm,
        normalize=normalize,
        nscale=nscale,
        pcsave=pcsave,
        reduce=reduce,
        prefix=prefix,
        dummy_lines=dummy_lines,
        verbose=verbose,
        quiet=quiet,
        eigonly=eigonly,
        float_=float_,
        mask=mask,
    )
    return v_3dpc_execute(params, runner)


__all__ = [
    "V3dpcOutputs",
    "V_3DPC_METADATA",
    "v_3dpc",
    "v_3dpc_execute",
    "v_3dpc_params",
]
