# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DRESAMPLE_METADATA = Metadata(
    id="8a3913d033c0e71a4bd6f9bad072454f5fd37c5b.boutiques",
    name="3dresample",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dresampleParameters = typing.TypedDict('V3dresampleParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dresample"]],
    "in_file": InputPathType,
    "master": typing.NotRequired[InputPathType | None],
    "orientation": typing.NotRequired[typing.Literal["AIL", "AIR", "ASL", "ASR", "PIL", "PIR", "PSL", "PSR", "ALI", "ALS", "ARI", "ARS", "PLI", "PLS", "PRI", "PRS", "IAL", "IAR", "IPL", "IPR", "SAL", "SAR", "SPL", "SPR", "ILA", "ILP", "IRA", "IRP", "SLA", "SLP", "SRA", "SRP", "LAI", "LAS", "LPI", "LPS", "RAI", "RAS", "RPI", "RPS", "LIA", "LIP", "LSA", "LSP", "RIA", "RIP", "RSA", "RSP"] | None],
    "prefix": str,
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "resample_mode": typing.NotRequired[typing.Literal["NN", "Li", "Cu", "Bk"] | None],
    "voxel_size": typing.NotRequired[list[float] | None],
})
V3dresampleParametersTagged = typing.TypedDict('V3dresampleParametersTagged', {
    "@type": typing.Literal["afni/3dresample"],
    "in_file": InputPathType,
    "master": typing.NotRequired[InputPathType | None],
    "orientation": typing.NotRequired[typing.Literal["AIL", "AIR", "ASL", "ASR", "PIL", "PIR", "PSL", "PSR", "ALI", "ALS", "ARI", "ARS", "PLI", "PLS", "PRI", "PRS", "IAL", "IAR", "IPL", "IPR", "SAL", "SAR", "SPL", "SPR", "ILA", "ILP", "IRA", "IRP", "SLA", "SLP", "SRA", "SRP", "LAI", "LAS", "LPI", "LPS", "RAI", "RAS", "RPI", "RPS", "LIA", "LIP", "LSA", "LSP", "RIA", "RIP", "RSA", "RSP"] | None],
    "prefix": str,
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "resample_mode": typing.NotRequired[typing.Literal["NN", "Li", "Cu", "Bk"] | None],
    "voxel_size": typing.NotRequired[list[float] | None],
})


class V3dresampleOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dresampleParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_file: OutputPathType
    """Output image file name."""


def v_3dresample_params(
    in_file: InputPathType,
    prefix: str,
    master: InputPathType | None = None,
    orientation: typing.Literal["AIL", "AIR", "ASL", "ASR", "PIL", "PIR", "PSL", "PSR", "ALI", "ALS", "ARI", "ARS", "PLI", "PLS", "PRI", "PRS", "IAL", "IAR", "IPL", "IPR", "SAL", "SAR", "SPL", "SPR", "ILA", "ILP", "IRA", "IRP", "SLA", "SLP", "SRA", "SRP", "LAI", "LAS", "LPI", "LPS", "RAI", "RAS", "RPI", "RPS", "LIA", "LIP", "LSA", "LSP", "RIA", "RIP", "RSA", "RSP"] | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    resample_mode: typing.Literal["NN", "Li", "Cu", "Bk"] | None = None,
    voxel_size: list[float] | None = None,
) -> V3dresampleParametersTagged:
    """
    Build parameters.
    
    Args:
        in_file: Input file to 3dresample.
        prefix: required prefix for output dataset.
        master: Align dataset grid to a reference file.
        orientation: New orientation code.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        resample_mode: 'nn' or 'li' or 'cu' or 'bk'. Resampling method from set\
            {"nn", "li", "cu", "bk"}. these are for "nearest neighbor", "linear",\
            "cubic" and "blocky"interpolation, respectively. default is nn.
        voxel_size: (a float, a float, a float). Resample to new dx, dy and dz.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dresample",
        "in_file": in_file,
        "prefix": prefix,
    }
    if master is not None:
        params["master"] = master
    if orientation is not None:
        params["orientation"] = orientation
    if outputtype is not None:
        params["outputtype"] = outputtype
    if resample_mode is not None:
        params["resample_mode"] = resample_mode
    if voxel_size is not None:
        params["voxel_size"] = voxel_size
    return params


def v_3dresample_cargs(
    params: V3dresampleParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dresample")
    cargs.extend([
        "-inset",
        execution.input_file(params.get("in_file", None))
    ])
    if params.get("master", None) is not None:
        cargs.extend([
            "-master",
            execution.input_file(params.get("master", None))
        ])
    if params.get("orientation", None) is not None:
        cargs.extend([
            "-orient",
            params.get("orientation", None)
        ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("outputtype", None) is not None:
        cargs.append(params.get("outputtype", None))
    if params.get("resample_mode", None) is not None:
        cargs.extend([
            "-rmode",
            params.get("resample_mode", None)
        ])
    if params.get("voxel_size", None) is not None:
        cargs.extend([
            "-dxyz",
            *map(str, params.get("voxel_size", None))
        ])
    return cargs


def v_3dresample_outputs(
    params: V3dresampleParameters,
    execution: Execution,
) -> V3dresampleOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dresampleOutputs(
        root=execution.output_file("."),
        out_file=execution.output_file(params.get("prefix", None)),
    )
    return ret


def v_3dresample_execute(
    params: V3dresampleParameters,
    runner: Runner | None = None,
) -> V3dresampleOutputs:
    """
    3dresample
    
    Resample or reorient an image using AFNI 3dresample command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dresampleOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DRESAMPLE_METADATA)
    params = execution.params(params)
    cargs = v_3dresample_cargs(params, execution)
    ret = v_3dresample_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dresample(
    in_file: InputPathType,
    prefix: str,
    master: InputPathType | None = None,
    orientation: typing.Literal["AIL", "AIR", "ASL", "ASR", "PIL", "PIR", "PSL", "PSR", "ALI", "ALS", "ARI", "ARS", "PLI", "PLS", "PRI", "PRS", "IAL", "IAR", "IPL", "IPR", "SAL", "SAR", "SPL", "SPR", "ILA", "ILP", "IRA", "IRP", "SLA", "SLP", "SRA", "SRP", "LAI", "LAS", "LPI", "LPS", "RAI", "RAS", "RPI", "RPS", "LIA", "LIP", "LSA", "LSP", "RIA", "RIP", "RSA", "RSP"] | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    resample_mode: typing.Literal["NN", "Li", "Cu", "Bk"] | None = None,
    voxel_size: list[float] | None = None,
    runner: Runner | None = None,
) -> V3dresampleOutputs:
    """
    3dresample
    
    Resample or reorient an image using AFNI 3dresample command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        in_file: Input file to 3dresample.
        prefix: required prefix for output dataset.
        master: Align dataset grid to a reference file.
        orientation: New orientation code.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        resample_mode: 'nn' or 'li' or 'cu' or 'bk'. Resampling method from set\
            {"nn", "li", "cu", "bk"}. these are for "nearest neighbor", "linear",\
            "cubic" and "blocky"interpolation, respectively. default is nn.
        voxel_size: (a float, a float, a float). Resample to new dx, dy and dz.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dresampleOutputs`).
    """
    params = v_3dresample_params(
        in_file=in_file,
        master=master,
        orientation=orientation,
        prefix=prefix,
        outputtype=outputtype,
        resample_mode=resample_mode,
        voxel_size=voxel_size,
    )
    return v_3dresample_execute(params, runner)


__all__ = [
    "V3dresampleOutputs",
    "V_3DRESAMPLE_METADATA",
    "v_3dresample",
    "v_3dresample_execute",
    "v_3dresample_params",
]
