# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DRETROICOR_METADATA = Metadata(
    id="ac5b72f1993f14309c37ea9caf0344ab63a04ab3.boutiques",
    name="3dretroicor",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dretroicorParameters = typing.TypedDict('V3dretroicorParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dretroicor"]],
    "ignore": typing.NotRequired[float | None],
    "prefix": typing.NotRequired[str | None],
    "card": typing.NotRequired[InputPathType | None],
    "cardphase": typing.NotRequired[str | None],
    "threshold": typing.NotRequired[float | None],
    "resp": typing.NotRequired[InputPathType | None],
    "respphase": typing.NotRequired[str | None],
    "order": typing.NotRequired[float | None],
    "dataset": InputPathType,
})
V3dretroicorParametersTagged = typing.TypedDict('V3dretroicorParametersTagged', {
    "@type": typing.Literal["afni/3dretroicor"],
    "ignore": typing.NotRequired[float | None],
    "prefix": typing.NotRequired[str | None],
    "card": typing.NotRequired[InputPathType | None],
    "cardphase": typing.NotRequired[str | None],
    "threshold": typing.NotRequired[float | None],
    "resp": typing.NotRequired[InputPathType | None],
    "respphase": typing.NotRequired[str | None],
    "order": typing.NotRequired[float | None],
    "dataset": InputPathType,
})


class V3dretroicorOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dretroicorParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    corrected_dataset: OutputPathType | None
    """Corrected dataset output."""
    output_cardiac_phase: OutputPathType | None
    """Cardiac phase output file."""
    output_resp_phase: OutputPathType | None
    """Respiratory phase output file."""


def v_3dretroicor_params(
    dataset: InputPathType,
    ignore: float | None = None,
    prefix: str | None = None,
    card: InputPathType | None = None,
    cardphase: str | None = None,
    threshold: float | None = None,
    resp: InputPathType | None = None,
    respphase: str | None = None,
    order: float | None = None,
) -> V3dretroicorParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: 3D+time dataset to process.
        ignore: The number of initial timepoints to ignore in the input. These\
            points will be passed through uncorrected.
        prefix: Prefix for new, corrected dataset.
        card: 1D cardiac data file for cardiac correction.
        cardphase: Filename for 1D cardiac phase output.
        threshold: Threshold for detection of R-wave peaks in input. Make sure\
            it's above the background noise level; try 3/4 or 4/5 times range plus\
            minimum.
        resp: 1D respiratory waveform data for correction.
        respphase: Filename for 1D respiratory phase output.
        order: The order of the correction. Higher-order terms yield little\
            improvement according to Glover et al.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dretroicor",
        "dataset": dataset,
    }
    if ignore is not None:
        params["ignore"] = ignore
    if prefix is not None:
        params["prefix"] = prefix
    if card is not None:
        params["card"] = card
    if cardphase is not None:
        params["cardphase"] = cardphase
    if threshold is not None:
        params["threshold"] = threshold
    if resp is not None:
        params["resp"] = resp
    if respphase is not None:
        params["respphase"] = respphase
    if order is not None:
        params["order"] = order
    return params


def v_3dretroicor_cargs(
    params: V3dretroicorParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dretroicor")
    if params.get("ignore", None) is not None:
        cargs.extend([
            "-ignore",
            str(params.get("ignore", None))
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("card", None) is not None:
        cargs.extend([
            "-card",
            execution.input_file(params.get("card", None))
        ])
    if params.get("cardphase", None) is not None:
        cargs.extend([
            "-cardphase",
            params.get("cardphase", None)
        ])
    if params.get("threshold", None) is not None:
        cargs.extend([
            "-threshold",
            str(params.get("threshold", None))
        ])
    if params.get("resp", None) is not None:
        cargs.extend([
            "-resp",
            execution.input_file(params.get("resp", None))
        ])
    if params.get("respphase", None) is not None:
        cargs.extend([
            "-respphase",
            params.get("respphase", None)
        ])
    if params.get("order", None) is not None:
        cargs.extend([
            "-order",
            str(params.get("order", None))
        ])
    cargs.append(execution.input_file(params.get("dataset", None)))
    return cargs


def v_3dretroicor_outputs(
    params: V3dretroicorParameters,
    execution: Execution,
) -> V3dretroicorOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dretroicorOutputs(
        root=execution.output_file("."),
        corrected_dataset=execution.output_file(params.get("prefix", None) + ".nii.gz") if (params.get("prefix") is not None) else None,
        output_cardiac_phase=execution.output_file(params.get("cardphase", None)) if (params.get("cardphase") is not None) else None,
        output_resp_phase=execution.output_file(params.get("respphase", None)) if (params.get("respphase") is not None) else None,
    )
    return ret


def v_3dretroicor_execute(
    params: V3dretroicorParameters,
    runner: Runner | None = None,
) -> V3dretroicorOutputs:
    """
    3dretroicor
    
    Performs Retrospective Image Correction for physiological motion effects
    using a modified RETROICOR algorithm.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dretroicorOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DRETROICOR_METADATA)
    params = execution.params(params)
    cargs = v_3dretroicor_cargs(params, execution)
    ret = v_3dretroicor_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dretroicor(
    dataset: InputPathType,
    ignore: float | None = None,
    prefix: str | None = None,
    card: InputPathType | None = None,
    cardphase: str | None = None,
    threshold: float | None = None,
    resp: InputPathType | None = None,
    respphase: str | None = None,
    order: float | None = None,
    runner: Runner | None = None,
) -> V3dretroicorOutputs:
    """
    3dretroicor
    
    Performs Retrospective Image Correction for physiological motion effects
    using a modified RETROICOR algorithm.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: 3D+time dataset to process.
        ignore: The number of initial timepoints to ignore in the input. These\
            points will be passed through uncorrected.
        prefix: Prefix for new, corrected dataset.
        card: 1D cardiac data file for cardiac correction.
        cardphase: Filename for 1D cardiac phase output.
        threshold: Threshold for detection of R-wave peaks in input. Make sure\
            it's above the background noise level; try 3/4 or 4/5 times range plus\
            minimum.
        resp: 1D respiratory waveform data for correction.
        respphase: Filename for 1D respiratory phase output.
        order: The order of the correction. Higher-order terms yield little\
            improvement according to Glover et al.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dretroicorOutputs`).
    """
    params = v_3dretroicor_params(
        ignore=ignore,
        prefix=prefix,
        card=card,
        cardphase=cardphase,
        threshold=threshold,
        resp=resp,
        respphase=respphase,
        order=order,
        dataset=dataset,
    )
    return v_3dretroicor_execute(params, runner)


__all__ = [
    "V3dretroicorOutputs",
    "V_3DRETROICOR_METADATA",
    "v_3dretroicor",
    "v_3dretroicor_execute",
    "v_3dretroicor_params",
]
