# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DROTATE_METADATA = Metadata(
    id="faff662007ce788fdeb0edbcc281fab85f7a83d9.boutiques",
    name="3drotate",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3drotateParameters = typing.TypedDict('V3drotateParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3drotate"]],
    "dataset": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "verbose": bool,
    "ashift": typing.NotRequired[list[float] | None],
    "bshift": typing.NotRequired[list[float] | None],
    "rotate": typing.NotRequired[list[str] | None],
    "rotparent": typing.NotRequired[InputPathType | None],
    "gridparent": typing.NotRequired[InputPathType | None],
    "matvec_dicom": typing.NotRequired[InputPathType | None],
    "matvec_order": typing.NotRequired[InputPathType | None],
    "matvec_dset": typing.NotRequired[InputPathType | None],
    "dfile": typing.NotRequired[InputPathType | None],
    "1Dfile": typing.NotRequired[InputPathType | None],
    "points": bool,
    "origin": typing.NotRequired[list[float] | None],
    "Fourier": bool,
    "NN": bool,
    "linear": bool,
    "cubic": bool,
    "quintic": bool,
    "heptic": bool,
    "Fourier_nopad": bool,
    "clipit": bool,
    "noclip": bool,
    "zpad": typing.NotRequired[float | None],
})
V3drotateParametersTagged = typing.TypedDict('V3drotateParametersTagged', {
    "@type": typing.Literal["afni/3drotate"],
    "dataset": InputPathType,
    "prefix": typing.NotRequired[str | None],
    "verbose": bool,
    "ashift": typing.NotRequired[list[float] | None],
    "bshift": typing.NotRequired[list[float] | None],
    "rotate": typing.NotRequired[list[str] | None],
    "rotparent": typing.NotRequired[InputPathType | None],
    "gridparent": typing.NotRequired[InputPathType | None],
    "matvec_dicom": typing.NotRequired[InputPathType | None],
    "matvec_order": typing.NotRequired[InputPathType | None],
    "matvec_dset": typing.NotRequired[InputPathType | None],
    "dfile": typing.NotRequired[InputPathType | None],
    "1Dfile": typing.NotRequired[InputPathType | None],
    "points": bool,
    "origin": typing.NotRequired[list[float] | None],
    "Fourier": bool,
    "NN": bool,
    "linear": bool,
    "cubic": bool,
    "quintic": bool,
    "heptic": bool,
    "Fourier_nopad": bool,
    "clipit": bool,
    "noclip": bool,
    "zpad": typing.NotRequired[float | None],
})


class V3drotateOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3drotateParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_head: OutputPathType | None
    """Output dataset header file"""
    out_brick: OutputPathType | None
    """Output dataset brick file"""


def v_3drotate_params(
    dataset: InputPathType,
    prefix: str | None = None,
    verbose: bool = False,
    ashift: list[float] | None = None,
    bshift: list[float] | None = None,
    rotate: list[str] | None = None,
    rotparent: InputPathType | None = None,
    gridparent: InputPathType | None = None,
    matvec_dicom: InputPathType | None = None,
    matvec_order: InputPathType | None = None,
    matvec_dset: InputPathType | None = None,
    dfile: InputPathType | None = None,
    v_1_dfile: InputPathType | None = None,
    points: bool = False,
    origin: list[float] | None = None,
    fourier: bool = False,
    nn: bool = False,
    linear: bool = False,
    cubic: bool = False,
    quintic: bool = False,
    heptic: bool = False,
    fourier_nopad: bool = False,
    clipit: bool = False,
    noclip: bool = False,
    zpad: float | None = None,
) -> V3drotateParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset: Input AFNI dataset, may contain a sub-brick selector list.
        prefix: Sets the output dataset prefix name.
        verbose: Prints out progress reports (to stderr).
        ashift: Shifts the dataset by specified distances (dx, dy, dz) in mm in\
            x, y, z directions respectively, AFTER rotation.
        bshift: Shifts the dataset by specified distances (dx, dy, dz) in mm in\
            x, y, z directions respectively, BEFORE rotation.
        rotate: Specifies the 3D rotation angles (th1, th2, th3) about certain\
            axes.
        rotparent: Rotation and translation should be taken from the first\
            3dvolreg transformation found in the header of dataset 'rset'.
        gridparent: Output dataset should be shifted to match the grid of\
            dataset 'gset'. Can only be used with -rotparent.
        matvec_dicom: Rotation and translation should be read from DICOM file\
            'mfile'.
        matvec_order: Rotation and translation should be read from file 'mfile'\
            with dataset coordinate order.
        matvec_dset: Rotation and translation should be read from the .HEAD\
            file of dataset 'mset' created by 3dTagalign.
        dfile: Reads movement parameters for each sub-brick from an ASCII file\
            'dname'.
        v_1_dfile: Reads movement parameters for each sub-brick from a 1D ASCII\
            file 'dname'.
        points: Specifies that (x,y,z) points are to be rotated instead of a\
            dataset.
        origin: Specifies the rotation origin point (xo, yo, zo).
        fourier: Use Fourier interpolation method during transformation.
        nn: Use nearest neighbor interpolation method during transformation.
        linear: Use linear interpolation (1st order polynomial) during\
            transformation.
        cubic: Use cubic interpolation (3rd order polynomial) during\
            transformation.
        quintic: Use quintic interpolation (5th order Lagrange polynomial)\
            during transformation.
        heptic: Use heptic interpolation (7th order Lagrange polynomial) during\
            transformation.
        fourier_nopad: Use the Fourier method WITHOUT padding.
        clipit: Clip results to input brick range [default option].
        noclip: Do not clip results to input brick range.
        zpad: Zero pad around the edges by 'n' voxels during rotations.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3drotate",
        "dataset": dataset,
        "verbose": verbose,
        "points": points,
        "Fourier": fourier,
        "NN": nn,
        "linear": linear,
        "cubic": cubic,
        "quintic": quintic,
        "heptic": heptic,
        "Fourier_nopad": fourier_nopad,
        "clipit": clipit,
        "noclip": noclip,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if ashift is not None:
        params["ashift"] = ashift
    if bshift is not None:
        params["bshift"] = bshift
    if rotate is not None:
        params["rotate"] = rotate
    if rotparent is not None:
        params["rotparent"] = rotparent
    if gridparent is not None:
        params["gridparent"] = gridparent
    if matvec_dicom is not None:
        params["matvec_dicom"] = matvec_dicom
    if matvec_order is not None:
        params["matvec_order"] = matvec_order
    if matvec_dset is not None:
        params["matvec_dset"] = matvec_dset
    if dfile is not None:
        params["dfile"] = dfile
    if v_1_dfile is not None:
        params["1Dfile"] = v_1_dfile
    if origin is not None:
        params["origin"] = origin
    if zpad is not None:
        params["zpad"] = zpad
    return params


def v_3drotate_cargs(
    params: V3drotateParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3drotate")
    cargs.append(execution.input_file(params.get("dataset", None)))
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("verbose", False):
        cargs.append("-verbose")
    if params.get("ashift", None) is not None:
        cargs.extend([
            "-ashift",
            *map(str, params.get("ashift", None))
        ])
    if params.get("bshift", None) is not None:
        cargs.extend([
            "-bshift",
            *map(str, params.get("bshift", None))
        ])
    if params.get("rotate", None) is not None:
        cargs.extend([
            "-rotate",
            *params.get("rotate", None)
        ])
    if params.get("rotparent", None) is not None:
        cargs.extend([
            "-rotparent",
            execution.input_file(params.get("rotparent", None))
        ])
    if params.get("gridparent", None) is not None:
        cargs.extend([
            "-gridparent",
            execution.input_file(params.get("gridparent", None))
        ])
    if params.get("matvec_dicom", None) is not None:
        cargs.extend([
            "-matvec_dicom",
            execution.input_file(params.get("matvec_dicom", None))
        ])
    if params.get("matvec_order", None) is not None:
        cargs.extend([
            "-matvec_order",
            execution.input_file(params.get("matvec_order", None))
        ])
    if params.get("matvec_dset", None) is not None:
        cargs.extend([
            "-matvec_dset",
            execution.input_file(params.get("matvec_dset", None))
        ])
    if params.get("dfile", None) is not None:
        cargs.extend([
            "-dfile",
            execution.input_file(params.get("dfile", None))
        ])
    if params.get("1Dfile", None) is not None:
        cargs.extend([
            "-1Dfile",
            execution.input_file(params.get("1Dfile", None))
        ])
    if params.get("points", False):
        cargs.append("-points")
    if params.get("origin", None) is not None:
        cargs.extend([
            "-origin",
            *map(str, params.get("origin", None))
        ])
    if params.get("Fourier", False):
        cargs.append("-Fourier")
    if params.get("NN", False):
        cargs.append("-NN")
    if params.get("linear", False):
        cargs.append("-linear")
    if params.get("cubic", False):
        cargs.append("-cubic")
    if params.get("quintic", False):
        cargs.append("-quintic")
    if params.get("heptic", False):
        cargs.append("-heptic")
    if params.get("Fourier_nopad", False):
        cargs.append("-Fourier_nopad")
    if params.get("clipit", False):
        cargs.append("-clipit")
    if params.get("noclip", False):
        cargs.append("-noclip")
    if params.get("zpad", None) is not None:
        cargs.extend([
            "-zpad",
            str(params.get("zpad", None))
        ])
    return cargs


def v_3drotate_outputs(
    params: V3drotateParameters,
    execution: Execution,
) -> V3drotateOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3drotateOutputs(
        root=execution.output_file("."),
        out_head=execution.output_file(params.get("prefix", None) + "+orig.HEAD") if (params.get("prefix") is not None) else None,
        out_brick=execution.output_file(params.get("prefix", None) + "+orig.BRIK") if (params.get("prefix") is not None) else None,
    )
    return ret


def v_3drotate_execute(
    params: V3drotateParameters,
    runner: Runner | None = None,
) -> V3drotateOutputs:
    """
    3drotate
    
    Rotates and/or translates all bricks from an AFNI dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3drotateOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DROTATE_METADATA)
    params = execution.params(params)
    cargs = v_3drotate_cargs(params, execution)
    ret = v_3drotate_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3drotate(
    dataset: InputPathType,
    prefix: str | None = None,
    verbose: bool = False,
    ashift: list[float] | None = None,
    bshift: list[float] | None = None,
    rotate: list[str] | None = None,
    rotparent: InputPathType | None = None,
    gridparent: InputPathType | None = None,
    matvec_dicom: InputPathType | None = None,
    matvec_order: InputPathType | None = None,
    matvec_dset: InputPathType | None = None,
    dfile: InputPathType | None = None,
    v_1_dfile: InputPathType | None = None,
    points: bool = False,
    origin: list[float] | None = None,
    fourier: bool = False,
    nn: bool = False,
    linear: bool = False,
    cubic: bool = False,
    quintic: bool = False,
    heptic: bool = False,
    fourier_nopad: bool = False,
    clipit: bool = False,
    noclip: bool = False,
    zpad: float | None = None,
    runner: Runner | None = None,
) -> V3drotateOutputs:
    """
    3drotate
    
    Rotates and/or translates all bricks from an AFNI dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset: Input AFNI dataset, may contain a sub-brick selector list.
        prefix: Sets the output dataset prefix name.
        verbose: Prints out progress reports (to stderr).
        ashift: Shifts the dataset by specified distances (dx, dy, dz) in mm in\
            x, y, z directions respectively, AFTER rotation.
        bshift: Shifts the dataset by specified distances (dx, dy, dz) in mm in\
            x, y, z directions respectively, BEFORE rotation.
        rotate: Specifies the 3D rotation angles (th1, th2, th3) about certain\
            axes.
        rotparent: Rotation and translation should be taken from the first\
            3dvolreg transformation found in the header of dataset 'rset'.
        gridparent: Output dataset should be shifted to match the grid of\
            dataset 'gset'. Can only be used with -rotparent.
        matvec_dicom: Rotation and translation should be read from DICOM file\
            'mfile'.
        matvec_order: Rotation and translation should be read from file 'mfile'\
            with dataset coordinate order.
        matvec_dset: Rotation and translation should be read from the .HEAD\
            file of dataset 'mset' created by 3dTagalign.
        dfile: Reads movement parameters for each sub-brick from an ASCII file\
            'dname'.
        v_1_dfile: Reads movement parameters for each sub-brick from a 1D ASCII\
            file 'dname'.
        points: Specifies that (x,y,z) points are to be rotated instead of a\
            dataset.
        origin: Specifies the rotation origin point (xo, yo, zo).
        fourier: Use Fourier interpolation method during transformation.
        nn: Use nearest neighbor interpolation method during transformation.
        linear: Use linear interpolation (1st order polynomial) during\
            transformation.
        cubic: Use cubic interpolation (3rd order polynomial) during\
            transformation.
        quintic: Use quintic interpolation (5th order Lagrange polynomial)\
            during transformation.
        heptic: Use heptic interpolation (7th order Lagrange polynomial) during\
            transformation.
        fourier_nopad: Use the Fourier method WITHOUT padding.
        clipit: Clip results to input brick range [default option].
        noclip: Do not clip results to input brick range.
        zpad: Zero pad around the edges by 'n' voxels during rotations.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3drotateOutputs`).
    """
    params = v_3drotate_params(
        dataset=dataset,
        prefix=prefix,
        verbose=verbose,
        ashift=ashift,
        bshift=bshift,
        rotate=rotate,
        rotparent=rotparent,
        gridparent=gridparent,
        matvec_dicom=matvec_dicom,
        matvec_order=matvec_order,
        matvec_dset=matvec_dset,
        dfile=dfile,
        v_1_dfile=v_1_dfile,
        points=points,
        origin=origin,
        fourier=fourier,
        nn=nn,
        linear=linear,
        cubic=cubic,
        quintic=quintic,
        heptic=heptic,
        fourier_nopad=fourier_nopad,
        clipit=clipit,
        noclip=noclip,
        zpad=zpad,
    )
    return v_3drotate_execute(params, runner)


__all__ = [
    "V3drotateOutputs",
    "V_3DROTATE_METADATA",
    "v_3drotate",
    "v_3drotate_execute",
    "v_3drotate_params",
]
