# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DSVM_METADATA = Metadata(
    id="3ad70f45d095b310a05d2e815ab123318d7dff8f.boutiques",
    name="3dsvm",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dsvmParameters = typing.TypedDict('V3dsvmParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dsvm"]],
    "train_vol": typing.NotRequired[InputPathType | None],
    "train_labels": typing.NotRequired[InputPathType | None],
    "mask": typing.NotRequired[InputPathType | None],
    "no_model_mask": bool,
    "model": str,
    "alpha": typing.NotRequired[str | None],
    "bucket": typing.NotRequired[str | None],
    "type": typing.NotRequired[typing.Literal["classification", "regression"] | None],
    "c_value": typing.NotRequired[float | None],
    "epsilon": typing.NotRequired[float | None],
    "kernel": typing.NotRequired[typing.Literal["linear", "polynomial", "rbf", "sigmoid"] | None],
    "d_value": typing.NotRequired[float | None],
    "gamma": typing.NotRequired[float | None],
    "s_value": typing.NotRequired[float | None],
    "r_value": typing.NotRequired[float | None],
    "max_iterations": typing.NotRequired[float | None],
    "wout": bool,
    "test_vol": typing.NotRequired[InputPathType | None],
    "predictions": typing.NotRequired[str | None],
    "classout": bool,
    "nopred_censored": bool,
    "nodetrend": bool,
    "nopred_scale": bool,
    "test_labels": typing.NotRequired[InputPathType | None],
    "multiclass": typing.NotRequired[typing.Literal["DAG", "vote"] | None],
    "help": bool,
    "version": bool,
})
V3dsvmParametersTagged = typing.TypedDict('V3dsvmParametersTagged', {
    "@type": typing.Literal["afni/3dsvm"],
    "train_vol": typing.NotRequired[InputPathType | None],
    "train_labels": typing.NotRequired[InputPathType | None],
    "mask": typing.NotRequired[InputPathType | None],
    "no_model_mask": bool,
    "model": str,
    "alpha": typing.NotRequired[str | None],
    "bucket": typing.NotRequired[str | None],
    "type": typing.NotRequired[typing.Literal["classification", "regression"] | None],
    "c_value": typing.NotRequired[float | None],
    "epsilon": typing.NotRequired[float | None],
    "kernel": typing.NotRequired[typing.Literal["linear", "polynomial", "rbf", "sigmoid"] | None],
    "d_value": typing.NotRequired[float | None],
    "gamma": typing.NotRequired[float | None],
    "s_value": typing.NotRequired[float | None],
    "r_value": typing.NotRequired[float | None],
    "max_iterations": typing.NotRequired[float | None],
    "wout": bool,
    "test_vol": typing.NotRequired[InputPathType | None],
    "predictions": typing.NotRequired[str | None],
    "classout": bool,
    "nopred_censored": bool,
    "nodetrend": bool,
    "nopred_scale": bool,
    "test_labels": typing.NotRequired[InputPathType | None],
    "multiclass": typing.NotRequired[typing.Literal["DAG", "vote"] | None],
    "help": bool,
    "version": bool,
})


class V3dsvmOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dsvmParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_model: OutputPathType
    """Output model file in .1D format."""
    out_alpha: OutputPathType
    """Output alphas file in .1D format."""
    out_bucket: OutputPathType
    """Output bucket file in .1D format."""
    out_predictions: OutputPathType
    """Output predictions file in .1D format."""


def v_3dsvm_params(
    model: str,
    train_vol: InputPathType | None = None,
    train_labels: InputPathType | None = None,
    mask: InputPathType | None = None,
    no_model_mask: bool = False,
    alpha: str | None = None,
    bucket: str | None = None,
    type_: typing.Literal["classification", "regression"] | None = None,
    c_value: float | None = None,
    epsilon: float | None = None,
    kernel: typing.Literal["linear", "polynomial", "rbf", "sigmoid"] | None = None,
    d_value: float | None = None,
    gamma: float | None = None,
    s_value: float | None = None,
    r_value: float | None = None,
    max_iterations: float | None = None,
    wout: bool = False,
    test_vol: InputPathType | None = None,
    predictions: str | None = None,
    classout: bool = False,
    nopred_censored: bool = False,
    nodetrend: bool = False,
    nopred_scale: bool = False,
    test_labels: InputPathType | None = None,
    multiclass: typing.Literal["DAG", "vote"] | None = None,
    help_: bool = False,
    version: bool = False,
) -> V3dsvmParametersTagged:
    """
    Build parameters.
    
    Args:
        model: The basename for the model brik containing the SVM model during\
            training or testing.
        train_vol: A 3D+t AFNI brik dataset to be used for training.
        train_labels: Filename of class category .1D labels corresponding to\
            the stimulus paradigm for the training data set.
        mask: Specify a mask dataset to only perform the analysis on non-zero\
            mask voxels.
        no_model_mask: Flag to enable the omission of a mask file. Required if\
            '-mask' is not used.
        alpha: Write the alphas to a specified .1D file.
        bucket: Outputs the sum of weighted linear support vectors written out\
            to a functional (fim) brik file.
        type_: Specify type: classification (default) or regression.
        c_value: Control SVM model complexity (C value).
        epsilon: Specify epsilon for regression.
        kernel: Specify type of kernel function.
        d_value: D parameter in polynomial kernel.
        gamma: Gamma parameter in rbf kernel.
        s_value: S parameter in sigmoid/poly kernel.
        r_value: R parameter in sigmoid/poly kernel.
        max_iterations: Specify the maximum number of iterations for the\
            optimization. Default is 1 million.
        wout: Flag to output sum of weighted linear support vectors to the\
            bucket file.
        test_vol: A 3D or 3D+t AFNI brik dataset to be used for testing.
        predictions: Basename for .1D prediction files.
        classout: Flag to specify that prediction files should be\
            integer-valued, corresponding to class category decisions.
        nopred_censored: Do not write predicted values for censored time-points\
            to predictions file.
        nodetrend: Flag to specify that prediction files should NOT be linearly\
            detrended.
        nopred_scale: Do not scale predictions. Values below 0.0 correspond to\
            (class A) and values above 0.0 to (class B).
        test_labels: Filename of 'true' class category .1D labels for the test\
            dataset.
        multiclass: Specify the multiclass algorithm for classification.
        help_: Print help message.
        version: Print version history.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dsvm",
        "no_model_mask": no_model_mask,
        "model": model,
        "wout": wout,
        "classout": classout,
        "nopred_censored": nopred_censored,
        "nodetrend": nodetrend,
        "nopred_scale": nopred_scale,
        "help": help_,
        "version": version,
    }
    if train_vol is not None:
        params["train_vol"] = train_vol
    if train_labels is not None:
        params["train_labels"] = train_labels
    if mask is not None:
        params["mask"] = mask
    if alpha is not None:
        params["alpha"] = alpha
    if bucket is not None:
        params["bucket"] = bucket
    if type_ is not None:
        params["type"] = type_
    if c_value is not None:
        params["c_value"] = c_value
    if epsilon is not None:
        params["epsilon"] = epsilon
    if kernel is not None:
        params["kernel"] = kernel
    if d_value is not None:
        params["d_value"] = d_value
    if gamma is not None:
        params["gamma"] = gamma
    if s_value is not None:
        params["s_value"] = s_value
    if r_value is not None:
        params["r_value"] = r_value
    if max_iterations is not None:
        params["max_iterations"] = max_iterations
    if test_vol is not None:
        params["test_vol"] = test_vol
    if predictions is not None:
        params["predictions"] = predictions
    if test_labels is not None:
        params["test_labels"] = test_labels
    if multiclass is not None:
        params["multiclass"] = multiclass
    return params


def v_3dsvm_cargs(
    params: V3dsvmParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dsvm")
    if params.get("train_vol", None) is not None:
        cargs.extend([
            "-trainvol",
            execution.input_file(params.get("train_vol", None))
        ])
    if params.get("train_labels", None) is not None:
        cargs.extend([
            "-trainlabels",
            execution.input_file(params.get("train_labels", None))
        ])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask", None))
        ])
    if params.get("no_model_mask", False):
        cargs.append("-nomodelmask")
    cargs.extend([
        "-model",
        params.get("model", None)
    ])
    if params.get("alpha", None) is not None:
        cargs.extend([
            "-alpha",
            params.get("alpha", None)
        ])
    if params.get("bucket", None) is not None:
        cargs.extend([
            "-bucket",
            params.get("bucket", None)
        ])
    if params.get("type", None) is not None:
        cargs.extend([
            "-type",
            params.get("type", None)
        ])
    if params.get("c_value", None) is not None:
        cargs.extend([
            "-c",
            str(params.get("c_value", None))
        ])
    if params.get("epsilon", None) is not None:
        cargs.extend([
            "-e",
            str(params.get("epsilon", None))
        ])
    if params.get("kernel", None) is not None:
        cargs.extend([
            "-kernel",
            params.get("kernel", None)
        ])
    if params.get("d_value", None) is not None:
        cargs.extend([
            "-d",
            str(params.get("d_value", None))
        ])
    if params.get("gamma", None) is not None:
        cargs.extend([
            "-g",
            str(params.get("gamma", None))
        ])
    if params.get("s_value", None) is not None:
        cargs.extend([
            "-s",
            str(params.get("s_value", None))
        ])
    if params.get("r_value", None) is not None:
        cargs.extend([
            "-r",
            str(params.get("r_value", None))
        ])
    if params.get("max_iterations", None) is not None:
        cargs.extend([
            "-max_iterations",
            str(params.get("max_iterations", None))
        ])
    if params.get("wout", False):
        cargs.append("-wout")
    if params.get("test_vol", None) is not None:
        cargs.extend([
            "-testvol",
            execution.input_file(params.get("test_vol", None))
        ])
    if params.get("predictions", None) is not None:
        cargs.extend([
            "-predictions",
            params.get("predictions", None)
        ])
    if params.get("classout", False):
        cargs.append("-classout")
    if params.get("nopred_censored", False):
        cargs.append("-nopredcensored")
    if params.get("nodetrend", False):
        cargs.append("-nodetrend")
    if params.get("nopred_scale", False):
        cargs.append("-nopredscale")
    if params.get("test_labels", None) is not None:
        cargs.extend([
            "-testlabels",
            execution.input_file(params.get("test_labels", None))
        ])
    if params.get("multiclass", None) is not None:
        cargs.extend([
            "-multiclass",
            params.get("multiclass", None)
        ])
    if params.get("help", False):
        cargs.append("-help")
    if params.get("version", False):
        cargs.append("-version")
    return cargs


def v_3dsvm_outputs(
    params: V3dsvmParameters,
    execution: Execution,
) -> V3dsvmOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dsvmOutputs(
        root=execution.output_file("."),
        out_model=execution.output_file("model_{output}.1D"),
        out_alpha=execution.output_file("alpha_{output}.1D"),
        out_bucket=execution.output_file("bucket_{output}.1D"),
        out_predictions=execution.output_file("predictions_{output}.1D"),
    )
    return ret


def v_3dsvm_execute(
    params: V3dsvmParameters,
    runner: Runner | None = None,
) -> V3dsvmOutputs:
    """
    3dsvm
    
    Support vector machine analysis of brain data using the SVM-light package.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dsvmOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DSVM_METADATA)
    params = execution.params(params)
    cargs = v_3dsvm_cargs(params, execution)
    ret = v_3dsvm_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dsvm(
    model: str,
    train_vol: InputPathType | None = None,
    train_labels: InputPathType | None = None,
    mask: InputPathType | None = None,
    no_model_mask: bool = False,
    alpha: str | None = None,
    bucket: str | None = None,
    type_: typing.Literal["classification", "regression"] | None = None,
    c_value: float | None = None,
    epsilon: float | None = None,
    kernel: typing.Literal["linear", "polynomial", "rbf", "sigmoid"] | None = None,
    d_value: float | None = None,
    gamma: float | None = None,
    s_value: float | None = None,
    r_value: float | None = None,
    max_iterations: float | None = None,
    wout: bool = False,
    test_vol: InputPathType | None = None,
    predictions: str | None = None,
    classout: bool = False,
    nopred_censored: bool = False,
    nodetrend: bool = False,
    nopred_scale: bool = False,
    test_labels: InputPathType | None = None,
    multiclass: typing.Literal["DAG", "vote"] | None = None,
    help_: bool = False,
    version: bool = False,
    runner: Runner | None = None,
) -> V3dsvmOutputs:
    """
    3dsvm
    
    Support vector machine analysis of brain data using the SVM-light package.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        model: The basename for the model brik containing the SVM model during\
            training or testing.
        train_vol: A 3D+t AFNI brik dataset to be used for training.
        train_labels: Filename of class category .1D labels corresponding to\
            the stimulus paradigm for the training data set.
        mask: Specify a mask dataset to only perform the analysis on non-zero\
            mask voxels.
        no_model_mask: Flag to enable the omission of a mask file. Required if\
            '-mask' is not used.
        alpha: Write the alphas to a specified .1D file.
        bucket: Outputs the sum of weighted linear support vectors written out\
            to a functional (fim) brik file.
        type_: Specify type: classification (default) or regression.
        c_value: Control SVM model complexity (C value).
        epsilon: Specify epsilon for regression.
        kernel: Specify type of kernel function.
        d_value: D parameter in polynomial kernel.
        gamma: Gamma parameter in rbf kernel.
        s_value: S parameter in sigmoid/poly kernel.
        r_value: R parameter in sigmoid/poly kernel.
        max_iterations: Specify the maximum number of iterations for the\
            optimization. Default is 1 million.
        wout: Flag to output sum of weighted linear support vectors to the\
            bucket file.
        test_vol: A 3D or 3D+t AFNI brik dataset to be used for testing.
        predictions: Basename for .1D prediction files.
        classout: Flag to specify that prediction files should be\
            integer-valued, corresponding to class category decisions.
        nopred_censored: Do not write predicted values for censored time-points\
            to predictions file.
        nodetrend: Flag to specify that prediction files should NOT be linearly\
            detrended.
        nopred_scale: Do not scale predictions. Values below 0.0 correspond to\
            (class A) and values above 0.0 to (class B).
        test_labels: Filename of 'true' class category .1D labels for the test\
            dataset.
        multiclass: Specify the multiclass algorithm for classification.
        help_: Print help message.
        version: Print version history.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dsvmOutputs`).
    """
    params = v_3dsvm_params(
        train_vol=train_vol,
        train_labels=train_labels,
        mask=mask,
        no_model_mask=no_model_mask,
        model=model,
        alpha=alpha,
        bucket=bucket,
        type_=type_,
        c_value=c_value,
        epsilon=epsilon,
        kernel=kernel,
        d_value=d_value,
        gamma=gamma,
        s_value=s_value,
        r_value=r_value,
        max_iterations=max_iterations,
        wout=wout,
        test_vol=test_vol,
        predictions=predictions,
        classout=classout,
        nopred_censored=nopred_censored,
        nodetrend=nodetrend,
        nopred_scale=nopred_scale,
        test_labels=test_labels,
        multiclass=multiclass,
        help_=help_,
        version=version,
    )
    return v_3dsvm_execute(params, runner)


__all__ = [
    "V3dsvmOutputs",
    "V_3DSVM_METADATA",
    "v_3dsvm",
    "v_3dsvm_execute",
    "v_3dsvm_params",
]
